/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;

public class PortValidator
implements Validator {
    private static final String PARAM_EXCLUDED_PORTS = "excluded";

    @Override
    public boolean validate(ProcessingClient client, AutomatedInstallData adata) {
        String param;
        Object inet = null;
        String host = "localhost";
        boolean retValue = true;
        int numfields = client.getNumFields();
        ArrayList<String> exludedPorts = new ArrayList<String>();
        Boolean modifyinstallation = Boolean.valueOf(adata.getVariable("MODIFY.IZPACK.INSTALL"));
        if (client.hasParams() && (param = client.getValidatorParams().get(PARAM_EXCLUDED_PORTS)) != null && !"".equals(param)) {
            VariableSubstitutor vs = new VariableSubstitutor(adata.getVariables());
            param = vs.substitute(param, null);
            exludedPorts.addAll(Arrays.asList(param.split(";")));
        }
        for (int i = 0; i < numfields; ++i) {
            String value = client.getFieldContents(i);
            if (value == null || value.length() == 0) {
                Debug.log("Port value is null");
                return false;
            }
            if (modifyinstallation.booleanValue() && exludedPorts.contains(value.trim())) continue;
            try {
                Socket socket = new Socket("localhost", Integer.parseInt(value));
                socket.close();
                Debug.log("Someone responding on port - seems not open");
                retValue = false;
                continue;
            }
            catch (Exception ex) {
                Debug.log(ex);
                retValue = true;
            }
        }
        return retValue;
    }
}

