/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoIterable;

public class MongoDBValidator
implements DataValidator {
    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        DataValidator.Status bReturn = DataValidator.Status.ERROR;
        try {
            String userName = adata.getVariable("mongodb.url.username");
            String passWord = adata.getVariable("mongodb.url.password");
            if ("false".equalsIgnoreCase(adata.getVariable("MONGODB.DATA.IMPORT"))) {
                return DataValidator.Status.OK;
            }
            boolean bImportMode = "true".equals(adata.getVariable("MONGODB.DATA.IMPORT"));
            String hostName = bImportMode ? adata.getVariable("mongodb.import.hostname") : adata.getVariable("mongodb.service.hostname");
            String hostPort = bImportMode ? adata.getVariable("mongodb.import.port") : adata.getVariable("mongodb.service.port");
            MongoClient mongoClient = new MongoClient(hostName, Integer.parseInt(hostPort));
            bReturn = bImportMode ? DataValidator.Status.WARNING : DataValidator.Status.OK;
            MongoIterable<String> lstDb = mongoClient.listDatabaseNames();
            for (String dbb : lstDb) {
                if (!dbb.equals("syracuse")) continue;
                if (bImportMode) {
                    bReturn = DataValidator.Status.OK;
                    continue;
                }
                bReturn = DataValidator.Status.WARNING;
            }
        }
        catch (Exception ex) {
            Debug.trace(ex.getMessage());
            bReturn = DataValidator.Status.ERROR;
        }
        return bReturn;
    }

    @Override
    public String getErrorMessageId() {
        return "mongodbtesterror";
    }

    @Override
    public String getWarningMessageId() {
        return "mongodbtestwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

