/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CheckProductAlreadyInstalled
implements DataValidator {
    private static final String SPEC_FILE_NAME = "productsSpec.txt";
    protected String errMessage = "";
    protected String warnMessage = "";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        InputStream input = null;
        try {
            String line;
            input = ResourceManager.getInstance().getInputStream(SPEC_FILE_NAME);
            if (input == null) {
                this.errMessage = "specFileMissing";
                return DataValidator.Status.ERROR;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            StringBuilder out = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                if (Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Wow6432Node\\Sage\\" + line) || Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Sage\\" + line)) {
                    this.errMessage = String.format(adata.langpack.getString("errIsProductFound"), line);
                    return DataValidator.Status.ERROR;
                }
                if (!Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + line)) continue;
                this.warnMessage = String.format(adata.langpack.getString("compFoundAskUpdate"), line);
                String oldInstallPath = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + line, "DisplayIcon");
                oldInstallPath = oldInstallPath.substring(0, oldInstallPath.indexOf("Uninstaller") - 1);
                adata.setInstallPath(oldInstallPath);
                Debug.trace("modification installation");
                Debug.trace("old path applied :" + oldInstallPath);
                adata.setVariable("MODIFY.IZPACK.INSTALL", "true");
                return DataValidator.Status.WARNING;
            }
            reader.close();
        }
        catch (Exception ex) {
            this.errMessage = ex.getMessage();
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    @Override
    public String getErrorMessageId() {
        return this.errMessage;
    }

    @Override
    public String getWarningMessageId() {
        return this.warnMessage;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

