/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.ssl.CertificateVerifier;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CheckCertificateSyrDataValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        Security.addProvider(new BouncyCastleProvider());
        String fieldPemCertFile = adata.getVariable("syracuse.ssl.certfile");
        String fieldPemKeyFile = adata.getVariable("syracuse.ssl.pemkeyfile");
        String fieldPemKeyPassword = adata.getVariable("syracuse.ssl.pemkeypassword");
        String fieldPemCaFile = adata.getVariable("syracuse.ssl.pemcafile");
        try {
            KeyPair kp;
            FileInputStream inPemKeyFile = new FileInputStream(fieldPemKeyFile);
            FileInputStream inPemCertFile = new FileInputStream(fieldPemCertFile);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
            FileInputStream inPemCaFile = new FileInputStream(fieldPemCaFile);
            Collection<? extends Certificate> certCAChain = factory.generateCertificates(inPemCaFile);
            certCAChain.add(cert);
            PKIXCertPathBuilderResult verifiedCertChain = CertificateVerifier.verifyCertificate(cert, new HashSet<Certificate>(certCAChain));
            PEMParser pemParser = new PEMParser(new InputStreamReader(inPemKeyFile));
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(fieldPemKeyPassword.toCharArray());
                kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
            } else {
                PEMKeyPair ukp = (PEMKeyPair)object;
                kp = converter.getKeyPair(ukp);
            }
            byte[] input = "1234567890ABCDEF".getBytes();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, cert.getPublicKey());
            byte[] cipherText = cipher.doFinal(input);
            cipher.init(2, kp.getPrivate());
            byte[] decrypted = cipher.doFinal(cipherText);
            if (Arrays.equals(decrypted, input)) {
                return DataValidator.Status.OK;
            }
            this.strMessage = "Unknow error";
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

