/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.CertManagerDataValidator;
import com.izforge.izpack.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CheckCertificateP12Validator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        try {
            String serverpassphrase = adata.getVariable("mongodb.ssl.serverpassphrase");
            if (serverpassphrase == null || serverpassphrase.isEmpty()) {
                serverpassphrase = adata.getVariable("mongodb.ssl.pemkeypassword");
            }
            CheckCertificateP12Validator.writeP12File(serverpassphrase, adata);
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    static void writeP12File(String passphrase, AutomatedInstallData adata) throws Exception {
        KeyPair pairServer;
        InputStreamReader keyStreamReader;
        InputStream inCertFile;
        BouncyCastleProvider bcprovider = new BouncyCastleProvider();
        Security.addProvider(bcprovider);
        String strCertPath = adata.getVariable("mongodb.dir.certs");
        String hostname = adata.getVariable("mongodb.ssl.certificate.hostname");
        String pemKeyFile = strCertPath + File.separator + hostname + ".pem";
        String certFile = strCertPath + File.separator + hostname + ".crt";
        String privKeyFile = strCertPath + File.separator + hostname + ".key";
        String p12File = strCertPath + File.separator + hostname + ".p12";
        String serverpassphrase = passphrase;
        if (!new File(privKeyFile).exists()) {
            byte[] certAndKey = Files.readAllBytes(Paths.get(pemKeyFile, new String[0]));
            String delimiter = "-----END CERTIFICATE-----";
            String[] tokens = new String(certAndKey).split(delimiter);
            byte[] certBytes = tokens[0].concat(delimiter).getBytes();
            byte[] keyBytes = tokens[1].getBytes();
            inCertFile = new ByteArrayInputStream(certBytes);
            keyStreamReader = new InputStreamReader(new ByteArrayInputStream(keyBytes));
        } else {
            FileInputStream inPrivKeyFile = new FileInputStream(privKeyFile);
            keyStreamReader = new InputStreamReader(inPrivKeyFile);
            inCertFile = new FileInputStream(certFile);
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate servercert = (X509Certificate)factory.generateCertificate(inCertFile);
        X500Principal x500Principal = servercert.getSubjectX500Principal();
        String name = x500Principal.getName();
        String cname = CertManagerDataValidator.extractCommonName(name);
        adata.setVariable("mongodb.ssl.certificate.cname", cname);
        Debug.trace("Set certificate cname " + cname);
        String thumbPrint = CheckCertificateP12Validator.getThumbprint(servercert);
        adata.setVariable("mongodb.ssl.certificate.thumbprint", thumbPrint);
        Debug.trace("Set certificate thumbPrint " + thumbPrint);
        Security.addProvider(new BouncyCastleProvider());
        PEMParser pemParser = new PEMParser(keyStreamReader);
        Object object = pemParser.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(bcprovider);
        if (object instanceof PEMEncryptedKeyPair) {
            PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
            PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(serverpassphrase.toCharArray());
            pairServer = converter.getKeyPair(ckp.decryptKeyPair(decProv));
        } else {
            PEMKeyPair ukp = (PEMKeyPair)object;
            pairServer = converter.getKeyPair(ukp);
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12", bcprovider);
        keyStore.load(null, null);
        keyStore.setKeyEntry(cname, pairServer.getPrivate(), null, new Certificate[]{servercert});
        FileOutputStream foStream = new FileOutputStream(strCertPath + File.separator + hostname + ".p12");
        keyStore.store(foStream, serverpassphrase.toCharArray());
        foStream.close();
    }

    private static String getThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        String digestHex = CheckCertificateP12Validator.bytesToHex(digest);
        return digestHex.toLowerCase();
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

