/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.CheckCertificateP12Validator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.KeyPairGeneratorDataValidator;
import com.izforge.izpack.util.ssl.CertificateVerifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;

public class CheckCertificateDataValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        Security.addProvider(new BouncyCastleProvider());
        String strCertPath = adata.getVariable("mongodb.dir.certs");
        String hostname = adata.getVariable("HOST_NAME");
        String fieldPemCertFile = adata.getVariable("mongodb.ssl.certfile");
        String fieldPemKeyFile = adata.getVariable("mongodb.ssl.pemkeyfile");
        String fieldPemKeyPassword = adata.getVariable("mongodb.ssl.pemkeypassword");
        String fieldPemCaFile = adata.getVariable("mongodb.ssl.pemcafile");
        Boolean useCaFile = false;
        try {
            KeyPair kp;
            FileInputStream inPemKeyFile = new FileInputStream(fieldPemKeyFile);
            FileInputStream inPemCertFile = new FileInputStream(fieldPemCertFile);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
            if (fieldPemCaFile != null && !fieldPemCaFile.trim().equals("")) {
                FileInputStream inPemCaFile = new FileInputStream(fieldPemCaFile);
                Collection<? extends Certificate> certCAChain = factory.generateCertificates(inPemCaFile);
                certCAChain.add(cert);
                PKIXCertPathBuilderResult verifiedCertChain = CertificateVerifier.verifyCertificate(cert, new HashSet<Certificate>(certCAChain));
                adata.setVariable("mongodb.ssl.usecafile", "true");
                useCaFile = true;
            }
            PEMParser pemParser = new PEMParser(new InputStreamReader(inPemKeyFile));
            Object object = pemParser.readObject();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            if (object instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair ckp = (PEMEncryptedKeyPair)object;
                PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(fieldPemKeyPassword.toCharArray());
                kp = converter.getKeyPair(ckp.decryptKeyPair(decProv));
            } else {
                PEMKeyPair ukp = (PEMKeyPair)object;
                kp = converter.getKeyPair(ukp);
            }
            byte[] input = "1234567890ABCDEF".getBytes();
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, cert.getPublicKey());
            byte[] cipherText = cipher.doFinal(input);
            cipher.init(2, kp.getPrivate());
            byte[] decrypted = cipher.doFinal(cipherText);
            if (Arrays.equals(decrypted, input)) {
                File certpath = new File(strCertPath);
                if (!certpath.exists()) {
                    certpath.mkdirs();
                }
                File pemKeyFile = new File(strCertPath + File.separator + hostname + ".pem");
                File certFile = new File(fieldPemCertFile);
                File privKeyFile = new File(fieldPemKeyFile);
                File destCertFile = new File(strCertPath + File.separator + hostname + ".crt");
                Files.copy(certFile.toPath(), destCertFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                File destKeyFile = new File(strCertPath + File.separator + hostname + ".key");
                Files.copy(privKeyFile.toPath(), destKeyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                KeyPairGeneratorDataValidator.mergeFiles(new File[]{certFile, privKeyFile}, pemKeyFile);
                if (useCaFile.booleanValue()) {
                    File caPath = new File(fieldPemCaFile);
                    File certCaPath = new File(strCertPath + File.separator + "ca.cacrt");
                    Files.copy(caPath.toPath(), certCaPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                CheckCertificateP12Validator.writeP12File(fieldPemKeyPassword, adata);
                adata.setVariable("mongodb.ssl.alreadydone", "true");
                return DataValidator.Status.OK;
            }
            this.strMessage = "Unknow error";
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            if (this.strMessage != null && this.strMessage.indexOf("JCE cannot authenticate the provider BC") >= 0) {
                this.strMessage = this.strMessage + " Please use an OpenJDK distribution to solve the issue (Java Zulu, ..) .";
            }
            Debug.trace(ex.getMessage());
            Debug.trace(this.strMessage);
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

