/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.CreateCertsValidator;
import com.izforge.izpack.util.KeyPairGeneratorDataValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.openssl.PEMWriter;

public class CertManagerDataValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";
    private KeyPair pairCA = null;
    private X509Certificate cacert = null;

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    public static String extractCommonName(String name) {
        String[] parts;
        for (String part : parts = name.split(",")) {
            if (!part.trim().startsWith("CN=")) continue;
            return part.trim().substring(3);
        }
        return null;
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        Boolean modifyinstallation = Boolean.valueOf(adata.getVariable("MODIFY.IZPACK.INSTALL"));
        Boolean mongoSSL = Boolean.valueOf(adata.getVariable("mongodb.ssl.enable"));
        DataValidator.Status statusReturn = DataValidator.Status.OK;
        try {
            if (!modifyinstallation.booleanValue()) {
                String localHOST_NAME = adata.getVariable("HOST_NAME").toLowerCase();
                String strCertPath = adata.getVariable("syracuse.dir.certs") + File.separator + localHOST_NAME;
                String hostname = "";
                Boolean certCreate = Boolean.valueOf(adata.getVariable("syracuse.certificate.install"));
                if (certCreate.booleanValue()) {
                    this.certCreate(adata);
                    hostname = adata.getVariable("syracuse.certificate.hostname").toLowerCase();
                } else {
                    adata.setVariable("syracuse.certificate.certtool", adata.getVariable("INSTALL_PATH") + File.separator + "syracuse" + File.separator + "certs_tools");
                    this.readCerts(adata);
                    CertificateFactory factory = CertificateFactory.getInstance("X.509");
                    FileInputStream inPemCertFile = new FileInputStream(adata.getVariable("syracuse.ssl.certfile"));
                    X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
                    X500Principal x500Principal = cert.getSubjectX500Principal();
                    String name = x500Principal.getName();
                    String commonName = CertManagerDataValidator.extractCommonName(name);
                    hostname = commonName.toLowerCase();
                    adata.setVariable("syracuse.certificate.serverpassphrase", adata.getVariable("syracuse.ssl.pemkeypassword"));
                }
                adata.setVariable("mongodb.ssl.server.serverpassphrase", adata.getVariable("syracuse.certificate.serverpassphrase"));
                adata.setVariable("mongodb.ssl.server.certfile", strCertPath + File.separator + localHOST_NAME + ".crt");
                adata.setVariable("mongodb.ssl.server.pemkeyfile", strCertPath + File.separator + localHOST_NAME + ".key");
                adata.setVariable("mongodb.ssl.server.pemcafile", strCertPath + File.separator + "ca.cacrt");
            }
            if (mongoSSL.booleanValue()) {
                if (!modifyinstallation.booleanValue()) {
                    Boolean mongodbInstall = Boolean.valueOf(adata.getVariable("mongodb.service.install"));
                    Boolean certCreate = Boolean.valueOf(adata.getVariable("syracuse.certificate.install"));
                    if (certCreate.booleanValue()) {
                        if (mongodbInstall.booleanValue()) {
                            this.clientCertCreate(adata);
                            adata.setVariable("mongodb.service.hostname", adata.getVariable("syracuse.certificate.hostname").toLowerCase());
                        } else {
                            this.clientPutInPlace(adata, adata.getVariable("mongodb.ssl.pemcafile"));
                        }
                    } else if (mongodbInstall.booleanValue()) {
                        this.clientPutInPlace(adata, adata.getVariable("syracuse.ssl.pemcafile"));
                        CertificateFactory factory = CertificateFactory.getInstance("X.509");
                        FileInputStream inPemCertFile = new FileInputStream(adata.getVariable("syracuse.ssl.certfile"));
                        X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
                        X500Principal x500Principal = cert.getSubjectX500Principal();
                        String name = x500Principal.getName();
                        String commonName = CertManagerDataValidator.extractCommonName(name);
                        adata.setVariable("mongodb.service.hostname", commonName.toLowerCase());
                    } else {
                        this.clientPutInPlace(adata, adata.getVariable("mongodb.ssl.pemcafile"));
                    }
                } else {
                    this.clientPutInPlace(adata, adata.getVariable("mongodb.ssl.pemcafile"));
                }
            }
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    public void clientPutInPlace(AutomatedInstallData adata, String strFieldCa) throws Exception {
        String fieldPemCertFile = adata.getVariable("mongodb.ssl.client.certfile");
        String fieldPemKeyFile = adata.getVariable("mongodb.ssl.client.pemkeyfile");
        String fieldPemCaFile = strFieldCa;
        String strCertPath = adata.getVariable("syracuse.dir.certs") + File.separator + "mongodb";
        File dirCerts = new File(strCertPath);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        File certsCaCRT = new File(strCertPath + File.separator + "ca.cacrt");
        File certsServerCRT = new File(strCertPath + File.separator + "client.crt");
        File certsServerKey = new File(strCertPath + File.separator + "client.key");
        File certsServerPem = new File(strCertPath + File.separator + "client.pem");
        if (fieldPemCaFile != null && !"".equals(fieldPemCaFile) && !fieldPemCaFile.equals(strCertPath + File.separator + "ca.cacrt")) {
            File sourceCaCRT = new File(fieldPemCaFile);
            Files.copy(sourceCaCRT.toPath(), certsCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (!fieldPemCertFile.equals(strCertPath + File.separator + "client.crt")) {
            File sourceServerCRT = new File(fieldPemCertFile);
            Files.copy(sourceServerCRT.toPath(), certsServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if (!fieldPemKeyFile.equals(strCertPath + File.separator + "client.key")) {
            File sourceServerKey = new File(fieldPemKeyFile);
            Files.copy(sourceServerKey.toPath(), certsServerKey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        KeyPairGeneratorDataValidator.mergeFiles(new File[]{certsServerCRT, certsServerKey}, certsServerPem);
        adata.setVariable("mongodb.ssl.client.certfile", strCertPath + File.separator + "client.crt");
        adata.setVariable("mongodb.ssl.client.pemkeyfile", strCertPath + File.separator + "client.key");
        adata.setVariable("mongodb.ssl.pemcafile", strCertPath + File.separator + "ca.cacrt");
    }

    public void clientCertCreate(AutomatedInstallData adata) throws Exception {
        String countryCode = adata.getVariable("syracuse.certificate.countrycode");
        String state = adata.getVariable("syracuse.certificate.state");
        String city = adata.getVariable("syracuse.certificate.city");
        String organization = adata.getVariable("syracuse.certificate.organization");
        String organizationalUnit = adata.getVariable("syracuse.certificate.organisationalunit");
        String name = adata.getVariable("syracuse.certificate.name");
        String email = adata.getVariable("syracuse.certificate.email");
        int validity = Integer.parseInt(adata.getVariable("syracuse.certificate.validity"));
        String localHOST_NAME = adata.getVariable("HOST_NAME").toLowerCase();
        KeyPair pairClient = CreateCertsValidator.generateRSAKeyPair(2048);
        X509Certificate clientcert = CreateCertsValidator.generateClientV3Certificate(pairClient, countryCode, organization, organizationalUnit, state, city, name, email, validity, this.cacert, this.pairCA);
        String strCertPath = adata.getVariable("syracuse.dir.certs") + File.separator + "mongodb";
        File dirCerts = new File(strCertPath);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        File certsCaCRT = new File(strCertPath + File.separator + "ca.cacrt");
        File certsServerCRT = new File(strCertPath + File.separator + "client.crt");
        File certsServerKey = new File(strCertPath + File.separator + "client.key");
        File certsServerPem = new File(strCertPath + File.separator + "client.pem");
        FileWriter cacertfile = new FileWriter(certsCaCRT);
        PEMWriter pem = new PEMWriter(cacertfile);
        pem.writeObject(this.cacert);
        pem.close();
        FileWriter clientcertfile = new FileWriter(certsServerCRT);
        pem = new PEMWriter(clientcertfile);
        pem.writeObject(clientcert);
        pem.close();
        KeyPairGeneratorDataValidator.writePrivateKey(strCertPath + File.separator + "client.key", pairClient, null);
        KeyPairGeneratorDataValidator.mergeFiles(new File[]{certsServerCRT, certsServerKey}, certsServerPem);
        adata.setVariable("mongodb.ssl.client.certfile", strCertPath + File.separator + "client.crt");
        adata.setVariable("mongodb.ssl.client.pemkeyfile", strCertPath + File.separator + "client.key");
        adata.setVariable("mongodb.ssl.pemcafile", strCertPath + File.separator + "ca.cacrt");
    }

    public void readCerts(AutomatedInstallData adata) throws Exception {
        Boolean setx3webserver;
        File dirCertToolPrivatePath;
        File dirCertToolOutputPath;
        String strCertToolPath;
        File dirCertToolPath;
        String fieldPemCertFile = adata.getVariable("syracuse.ssl.certfile");
        String fieldPemKeyFile = adata.getVariable("syracuse.ssl.pemkeyfile");
        String fieldPemKeyPassword = adata.getVariable("syracuse.ssl.pemkeypassword");
        String fieldPemCaFile = adata.getVariable("syracuse.ssl.pemcafile");
        String localHOST_NAME = adata.getVariable("HOST_NAME").toLowerCase();
        String strCertPath = adata.getVariable("syracuse.dir.certs") + File.separator + localHOST_NAME;
        File dirCerts = new File(strCertPath);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        if (!(dirCertToolPath = new File(strCertToolPath = adata.getVariable("syracuse.certificate.certtool"))).exists()) {
            dirCertToolPath.mkdirs();
        }
        if (!(dirCertToolOutputPath = new File(strCertToolPath + File.separator + "output")).exists()) {
            dirCertToolOutputPath.mkdirs();
        }
        if (!(dirCertToolPrivatePath = new File(strCertToolPath + File.separator + "private")).exists()) {
            dirCertToolPrivatePath.mkdirs();
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream inPemCaFile = new FileInputStream(fieldPemCaFile);
        this.cacert = (X509Certificate)factory.generateCertificate(inPemCaFile);
        File sourceCaCRT = new File(fieldPemCaFile);
        File certToolOutputCaCRT = new File(strCertToolPath + File.separator + "output" + File.separator + "ca.cacrt");
        File certsCaCRT = new File(strCertPath + File.separator + "ca.cacrt");
        Files.copy(sourceCaCRT.toPath(), certToolOutputCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(sourceCaCRT.toPath(), certsCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        FileInputStream inPemCertFile = new FileInputStream(fieldPemCertFile);
        X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
        X500Principal x500Principal = cert.getSubjectX500Principal();
        String name = x500Principal.getName();
        String cn = CertManagerDataValidator.extractCommonName(name);
        File sourceserverCRT = new File(fieldPemCertFile);
        File certToolOutputServerCRT = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".crt");
        File certsServerCRT = new File(strCertPath + File.separator + localHOST_NAME + ".crt");
        Files.copy(sourceserverCRT.toPath(), certToolOutputServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(sourceserverCRT.toPath(), certsServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File sourceserverKey = new File(fieldPemKeyFile);
        File certToolOutputServerkey = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".key");
        File certsServerkey = new File(strCertPath + File.separator + localHOST_NAME + ".key");
        Files.copy(sourceserverKey.toPath(), certToolOutputServerkey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        Files.copy(sourceserverKey.toPath(), certsServerkey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        PublicKey pubKey = cert.getPublicKey();
        File certToolOutputServerPub = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".pem");
        FileWriter serverpubfile = new FileWriter(certToolOutputServerPub);
        PEMWriter pem = new PEMWriter(serverpubfile);
        pem.writeObject(pubKey);
        pem.close();
        Boolean setx3runtime = Boolean.valueOf(adata.getVariable("syracuse.certificate.setx3runtime"));
        if (setx3runtime.booleanValue()) {
            String strX3RuntimePath = adata.getVariable("syracuse.certificate.x3runtime");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3RuntimePath + File.separator + "keys" + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if ((setx3webserver = Boolean.valueOf(adata.getVariable("syracuse.certificate.setx3webserver"))).booleanValue()) {
            String strX3WebserverPath = adata.getVariable("syracuse.certificate.x3webserverdata");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3WebserverPath + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void certCreate(AutomatedInstallData adata) throws Exception {
        Boolean setx3webserver;
        File dirCertToolPrivatePath;
        File dirCertToolOutputPath;
        String strCertToolPath;
        File dirCertToolPath;
        String countryCode = adata.getVariable("syracuse.certificate.countrycode");
        String state = adata.getVariable("syracuse.certificate.state");
        String city = adata.getVariable("syracuse.certificate.city");
        String organization = adata.getVariable("syracuse.certificate.organization");
        String organizationalUnit = adata.getVariable("syracuse.certificate.organisationalunit");
        String name = adata.getVariable("syracuse.certificate.name");
        String email = adata.getVariable("syracuse.certificate.email");
        int validity = Integer.parseInt(adata.getVariable("syracuse.certificate.validity"));
        String localHOST_NAME = adata.getVariable("HOST_NAME").toLowerCase();
        String strCertPath = adata.getVariable("syracuse.dir.certs") + File.separator + localHOST_NAME;
        File dirCerts = new File(strCertPath);
        if (!dirCerts.exists()) {
            dirCerts.mkdirs();
        }
        if (!(dirCertToolPath = new File(strCertToolPath = adata.getVariable("syracuse.certificate.certtool"))).exists()) {
            dirCertToolPath.mkdirs();
        }
        if (!(dirCertToolOutputPath = new File(strCertToolPath + File.separator + "output")).exists()) {
            dirCertToolOutputPath.mkdirs();
        }
        if (!(dirCertToolPrivatePath = new File(strCertToolPath + File.separator + "private")).exists()) {
            dirCertToolPrivatePath.mkdirs();
        }
        this.pairCA = CreateCertsValidator.generateRSAKeyPair(4096);
        this.cacert = CreateCertsValidator.generateCAV3Certificate(this.pairCA, countryCode, organization, organizationalUnit, state, city, name, email, validity);
        File certsCaCRT = new File(strCertPath + File.separator + "ca.cacrt");
        FileWriter cacertfile = new FileWriter(certsCaCRT);
        PEMWriter pem = new PEMWriter(cacertfile);
        pem.writeObject(this.cacert);
        pem.close();
        File certToolOutputCaCRT = new File(strCertToolPath + File.separator + "output" + File.separator + "ca.cacrt");
        Files.copy(certsCaCRT.toPath(), certToolOutputCaCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String capassphrase = adata.getVariable("syracuse.certificate.capassphrase");
        KeyPairGeneratorDataValidator.writePrivateKey(strCertToolPath + File.separator + "private" + File.separator + "ca.cakey", this.pairCA, capassphrase.toCharArray());
        KeyPair pairServer = CreateCertsValidator.generateRSAKeyPair(2048);
        String hostname = adata.getVariable("syracuse.certificate.hostname").toLowerCase();
        X509Certificate servercert = CreateCertsValidator.generateServerV3Certificate(pairServer, countryCode, organization, organizationalUnit, state, city, hostname, hostname, null, validity, this.cacert, this.pairCA);
        File certsServerCRT = new File(strCertPath + File.separator + localHOST_NAME + ".crt");
        FileWriter servercertfile = new FileWriter(certsServerCRT);
        pem = new PEMWriter(servercertfile);
        pem.writeObject(servercert);
        pem.close();
        File certToolOutputServerCRT = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".crt");
        Files.copy(certsServerCRT.toPath(), certToolOutputServerCRT.toPath(), StandardCopyOption.REPLACE_EXISTING);
        String serverpassphrase = adata.getVariable("syracuse.certificate.serverpassphrase");
        KeyPairGeneratorDataValidator.writePrivateKey(strCertPath + File.separator + localHOST_NAME + ".key", pairServer, serverpassphrase.toCharArray());
        File certToolOutputServerkey = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".key");
        File certsServerkey = new File(strCertPath + File.separator + localHOST_NAME + ".key");
        Files.copy(certsServerkey.toPath(), certToolOutputServerkey.toPath(), StandardCopyOption.REPLACE_EXISTING);
        File certToolOutputServerPub = new File(strCertToolPath + File.separator + "output" + File.separator + localHOST_NAME + ".pem");
        FileWriter serverpubfile = new FileWriter(certToolOutputServerPub);
        pem = new PEMWriter(serverpubfile);
        pem.writeObject(pairServer.getPublic());
        pem.close();
        Boolean setx3runtime = Boolean.valueOf(adata.getVariable("syracuse.certificate.setx3runtime"));
        if (setx3runtime.booleanValue()) {
            String strX3RuntimePath = adata.getVariable("syracuse.certificate.x3runtime");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3RuntimePath + File.separator + "keys" + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        if ((setx3webserver = Boolean.valueOf(adata.getVariable("syracuse.certificate.setx3webserver"))).booleanValue()) {
            String strX3WebserverPath = adata.getVariable("syracuse.certificate.x3webserverdata");
            String pemName = localHOST_NAME.replace('@', '_').replace('$', '_').replace('.', '_');
            File x3ServerPub = new File(strX3WebserverPath + File.separator + pemName + ".pem");
            Files.copy(certToolOutputServerPub.toPath(), x3ServerPub.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

