/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;

public class DirectoryExistCondition
extends Condition {
    protected String directoryName;

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        try {
            this.directoryName = xmlcondition.getFirstChildNamed("directory").getContent();
        }
        catch (Exception e) {
            Debug.log("missing element directory in <condition type=\"DirectoryExistCondition\"/>");
        }
    }

    @Override
    public boolean isTrue() {
        try {
            VariableSubstitutor substitutor = new VariableSubstitutor(this.installdata.getVariables());
            File file = new File(substitutor.substitute(this.directoryName, "plain"));
            return file.isDirectory() && file.exists();
        }
        catch (Exception ex) {
            Debug.log(ex);
            return false;
        }
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameEl = new XMLElementImpl("file", conditionRoot);
        nameEl.setContent(this.directoryName);
        conditionRoot.addChild(nameEl);
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on existence of the directory <b>");
        details.append(this.directoryName);
        details.append("</b><br/>");
        return details.toString();
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }
}

