/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;

public class CompareVersionsCondition
extends Condition {
    private static final long serialVersionUID = 5605592864539142416L;
    protected String variablename;
    protected String value;
    protected String operator;
    private static final transient Logger logger = Logger.getLogger(CompareVersionsCondition.class.getName());
    private static final Set<String> EMPTY_STRINGS = Collections.singleton("");
    private static final String VERSION_DELIMITER = "[^\\d]+";
    protected static final int NOT_ASSUME_MISSING_MINOR_PARTS_AS_0 = 1;
    protected int flags = 0;

    public CompareVersionsCondition() {
        this(0);
    }

    public CompareVersionsCondition(int flags) {
        this.flags |= flags;
    }

    protected boolean hasFlag(int f) {
        return (this.flags & f) != 0;
    }

    @Override
    public boolean isTrue() {
        String val;
        logger.fine("Version comparison: " + this.variablename + " " + this.operator + " " + this.value + " (flags: " + this.flags + ")");
        boolean result = false;
        if (this.installdata != null && (val = this.installdata.getVariable(this.variablename)) != null) {
            if (this.operator == null) {
                this.operator = "eq";
            }
            int res = 0;
            try {
                res = new Version(val).compareTo(new Version(this.value));
            }
            catch (IllegalArgumentException e) {
                logger.warning("[" + this.getClass().getSimpleName() + "] " + e.getMessage());
                return false;
            }
            logger.finer("Raw version comparison result: " + res);
            switch (this.operator) {
                case "eq": {
                    result = res == 0;
                    break;
                }
                case "gt": {
                    result = res > 0;
                    break;
                }
                case "geq": {
                    result = res >= 0;
                    break;
                }
                case "lt": {
                    result = res < 0;
                    break;
                }
                case "leq": {
                    result = res <= 0;
                    break;
                }
            }
        }
        logger.fine(this.variablename + " " + this.operator + " " + this.value + ": " + result);
        return result;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        try {
            this.variablename = xmlcondition.getFirstChildNamed("name").getContent();
            this.value = xmlcondition.getFirstChildNamed("value").getContent();
            this.operator = xmlcondition.getFirstChildNamed("operator").getContent();
        }
        catch (Exception e) {
            Debug.log("missing element in <condition type=\"variable\"/>");
        }
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameXml = new XMLElementImpl("name", conditionRoot);
        nameXml.setContent(this.variablename);
        conditionRoot.addChild(nameXml);
        XMLElementImpl valueXml = new XMLElementImpl("value", conditionRoot);
        valueXml.setContent(this.value);
        conditionRoot.addChild(valueXml);
        XMLElementImpl opXml = new XMLElementImpl("op", conditionRoot);
        opXml.setContent(this.operator);
        conditionRoot.addChild(opXml);
    }

    class Version
    implements Comparable<Version> {
        private String version;

        public final String get() {
            return this.version;
        }

        public Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version can not be null");
            }
            if (!version.matches("[^\\d]*[\\d]+([^\\d]+[\\d]+)*[^\\d]*")) {
                throw new IllegalArgumentException("Invalid version format: '" + version + "'");
            }
            this.version = version;
        }

        @Override
        public int compareTo(Version version) {
            if (version == null) {
                return 1;
            }
            String[] parts1 = this.get().split(CompareVersionsCondition.VERSION_DELIMITER);
            ArrayList<String> leftOps = new ArrayList<String>(Arrays.asList(parts1));
            leftOps.removeAll(EMPTY_STRINGS);
            String[] parts2 = version.get().split(CompareVersionsCondition.VERSION_DELIMITER);
            ArrayList<String> rightOps = new ArrayList<String>(Arrays.asList(parts2));
            rightOps.removeAll(EMPTY_STRINGS);
            int length = CompareVersionsCondition.this.hasFlag(1) ? Math.min(leftOps.size(), rightOps.size()) : Math.max(leftOps.size(), rightOps.size());
            logger.finer("Effective number of version parts: " + length);
            for (int i = 0; i < length; ++i) {
                int part1 = i < leftOps.size() ? Integer.parseInt((String)leftOps.get(i)) : 0;
                int part2 = i < rightOps.size() ? Integer.parseInt((String)rightOps.get(i)) : 0;
                logger.finer("Compare version parts: " + part1 + " <-> " + part2);
                if (part1 < part2) {
                    return -1;
                }
                if (part1 <= part2) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(Object version) {
            if (this == version) {
                return true;
            }
            if (version == null) {
                return false;
            }
            if (this.getClass() != version.getClass()) {
                return false;
            }
            return this.compareTo((Version)version) == 0;
        }
    }
}

