/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.MultipleFieldValidator;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserInputPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    protected int instanceNumber = instanceCount++;
    private static int instanceCount = 0;
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String LANG_FILE_NAME = "userInputLang.xml";
    private static final String NODE_ID = "panel";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String FIELD_NODE_ID = "field";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    private static final String VARIABLE = "variable";
    private static final String SET = "set";
    private static final String TEXT = "txt";
    private static final String SPEC = "spec";
    private static final String PWD = "pwd";
    private static final String TYPE_ATTRIBUTE = "type";
    private static final String TEXT_FIELD = "text";
    private static final String COMBO_FIELD = "combo";
    private static final String STATIC_TEXT = "staticText";
    private static final String CHOICE = "choice";
    private static final String DIR = "dir";
    private static final String FILE = "file";
    private static final String PASSWORD = "password";
    private static final String VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String TITLE_FIELD = "title";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String SPACE = "space";
    private static final String DIVIDER = "divider";
    static final String DISPLAY_FORMAT = "displayFormat";
    static final String PLAIN_STRING = "plainString";
    static final String SPECIAL_SEPARATOR = "specialSeparator";
    static final String LAYOUT = "layout";
    static final String RESULT_FORMAT = "resultFormat";
    private static final String DESCRIPTION = "description";
    private static final String TRUE = "true";
    private static final String NAME = "name";
    private static final String FAMILY = "family";
    private static final String OS = "os";
    private static final String SELECTEDPACKS = "createForPack";
    private static Input SPACE_INTPUT_FIELD = new Input("space", null, null, "space", "\r", 0);
    private static Input DIVIDER_INPUT_FIELD = new Input("divider", null, null, "divider", "------------------------------------------", 0);
    public List<Input> listInputs = new ArrayList<Input>();

    private List<ValidatorContainer> analyzeValidator(IXMLElement specElement, AutomatedInstallData idata) {
        ArrayList<ValidatorContainer> result = null;
        Vector<IXMLElement> validatorsElem = specElement.getChildrenNamed("validator");
        if (validatorsElem != null && validatorsElem.size() > 0) {
            int vsize = validatorsElem.size();
            result = new ArrayList<ValidatorContainer>(vsize);
            for (int i = 0; i < vsize; ++i) {
                IXMLElement element2 = validatorsElem.get(i);
                String validator = element2.getAttribute("class");
                String message = this.getText(element2, idata);
                HashMap<String, String> validateParamMap = new HashMap<String, String>();
                Vector<IXMLElement> validateParams = element2.getChildrenNamed("param");
                if (validateParams != null && validateParams.size() > 0) {
                    for (IXMLElement element2 : validateParams) {
                        String paramName = element2.getAttribute(NAME);
                        String paramValue = element2.getAttribute(VALUE);
                        validateParamMap.put(paramName, paramValue);
                    }
                }
                result.add(new ValidatorContainer(validator, message, validateParamMap));
            }
        }
        return result;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        this.collectInputs(installData);
        Iterator<Input> inputIterator = this.listInputs.iterator();
        while (inputIterator.hasNext()) {
            String strVariableValue;
            String strVariableName = inputIterator.next().strVariableName;
            if (strVariableName == null || (strVariableValue = p.getProperty(strVariableName)) == null) continue;
            installData.setVariable(strVariableName, strVariableValue);
        }
        return true;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        this.collectInputs(installData);
        for (Input input : this.listInputs) {
            if (input.strVariableName == null) continue;
            printWriter.println(input.strVariableName + "=");
        }
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata) {
        try {
            String resource = "userInputLang.xml_" + idata.localeISO3;
            idata.langpack.add(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (ResourceNotFoundException e) {
            Debug.trace(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean processpanel = this.collectInputs(idata);
        if (!processpanel) {
            return true;
        }
        boolean status = true;
        Iterator<Input> inputsIterator = this.listInputs.iterator();
        String summaryCaption = idata.langpack.getString("UserInputPanel.summaryCaption");
        ArrayList<String> lstTarget = new ArrayList<String>();
        try {
            while (inputsIterator.hasNext()) {
                Input input = inputsIterator.next();
                if (TEXT_FIELD.equals(input.strFieldType) || FILE.equals(input.strFieldType) || RULE_FIELD.equals(input.strFieldType) || DIR.equals(input.strFieldType)) {
                    status = status && this.processTextField(input, idata);
                } else if (COMBO_FIELD.equals(input.strFieldType) || RADIO_FIELD.equals(input.strFieldType)) {
                    status = status && this.processComboRadioField(input, idata);
                } else if (CHECK_FIELD.equals(input.strFieldType)) {
                    status = status && this.processCheckField(input, idata);
                } else if (STATIC_TEXT.equals(input.strFieldType) || TITLE_FIELD.equals(input.strFieldType) || DIVIDER.equals(input.strFieldType) || SPACE.equals(input.strFieldType)) {
                    status = status && this.processSimpleField(input, idata);
                } else if (PASSWORD.equals(input.strFieldType)) {
                    boolean bl = status = status && this.processPasswordField(input, idata);
                }
                if (STATIC_TEXT.equals(input.strFieldType) || TITLE_FIELD.equals(input.strFieldType) || DIVIDER.equals(input.strFieldType) || SPACE.equals(input.strFieldType) || input.strVariableName == null || input.strVariableName.trim() == "") continue;
                String variable = input.strVariableName;
                String value = idata.getVariable(variable);
                if (variable.indexOf("pass") > -1) {
                    String strBody = "";
                    for (int i = 0; i < variable.length(); ++i) {
                        strBody = strBody + "*";
                    }
                    lstTarget.add(variable + "=" + strBody);
                    continue;
                }
                lstTarget.add(variable + "=" + value);
            }
        }
        catch (RevalidationTriggeredException e) {
            return this.runConsole(idata);
        }
        int i = this.askEndOfConsolePanel(idata);
        if (i == 1) {
            idata.summaryText.put(summaryCaption, lstTarget);
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(idata);
    }

    public boolean collectInputs(AutomatedInstallData idata) {
        this.listInputs.clear();
        IXMLElement spec = null;
        String panelid = idata.panelsOrder.get(idata.curPanelNumber).getPanelid();
        String instance = Integer.toString(this.instanceNumber);
        SpecHelper specHelper = new SpecHelper();
        try {
            specHelper.readSpec(specHelper.getResource(SPEC_FILE_NAME));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        Vector<IXMLElement> specElements = specHelper.getSpec().getChildrenNamed(NODE_ID);
        for (int i = 0; i < specElements.size(); ++i) {
            IXMLElement data = specElements.elementAt(i);
            String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
            String dataID = data.getAttribute(PANEL_IDENTIFIER);
            if ((attribute == null || !instance.equals(attribute)) && (dataID == null || panelid == null || !panelid.equals(dataID))) continue;
            Vector<IXMLElement> forPacks = data.getChildrenNamed(SELECTEDPACKS);
            Vector<IXMLElement> forOs = data.getChildrenNamed(OS);
            if (!this.itemRequiredFor(forPacks, idata) || !this.itemRequiredForOs(forOs)) continue;
            spec = data;
            break;
        }
        if (spec == null) {
            return false;
        }
        Vector<IXMLElement> fields = spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < fields.size(); ++i) {
            Input in;
            String conditionid;
            IXMLElement field = fields.elementAt(i);
            Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
            Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
            if (!this.itemRequiredFor(forPacks, idata) || !this.itemRequiredForOs(forOs) || (conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !idata.getRules().isConditionTrue(conditionid, idata.getVariables()) || (in = this.getInputFromField(field, idata)) == null) continue;
            in.validators = this.analyzeValidator(field, idata);
            if (in instanceof Password) {
                for (Input singleInput : ((Password)in).input) {
                    singleInput.validators = in.validators;
                }
            }
            this.listInputs.add(in);
        }
        return true;
    }

    boolean processSimpleField(Input input, AutomatedInstallData idata) {
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        System.out.println(vs.substitute(input.strText, null));
        return true;
    }

    boolean processPasswordField(Input input, AutomatedInstallData idata) {
        Password pwd = (Password)input;
        boolean rtn = false;
        LinkedList<String> values = new LinkedList<String>();
        for (int i = 0; i < pwd.input.length; ++i) {
            boolean done;
            do {
                MultipleFieldValidator validation;
                done = true;
                rtn = this.processTextField(pwd.input[i], idata);
                if (!rtn) {
                    return rtn;
                }
                values.add(idata.getVariable(pwd.input[i].strVariableName));
                if (i <= 0 || pwd.validators == null || pwd.validators.isEmpty() || (validation = new MultipleFieldValidator(idata, values, pwd.validators)).validate()) continue;
                values.remove(values.size() - 1);
                done = false;
                System.out.println("Validation failed, please verify your input.");
                System.out.println("Validation error: " + validation.getValidationMessage());
            } while (!done);
        }
        return rtn;
    }

    boolean processTextField(Input input, AutomatedInstallData idata) {
        boolean done;
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        if (input.listChoices.size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        String set = input.strDefaultValue;
        if (set == null && (set = idata.getVariable(variable)) == null) {
            set = "";
        }
        if (set != null && !"".equals(set)) {
            VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
            set = vs.substitute(set, null);
        }
        String fieldText = input.listChoices.get((int)0).strText;
        String value = set;
        do {
            done = false;
            System.out.println(fieldText + " [" + set + "] ");
            try {
                StringInputProcessingClient validation;
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String strIn = br.readLine();
                value = !strIn.trim().equals("") ? strIn : set;
                boolean bokForInputDir = true;
                if (DIR.equals(input.strFieldType)) {
                    File dir = new File(value).getAbsoluteFile();
                    value = dir.getAbsolutePath();
                    boolean mustExist = input.mustExist;
                    boolean canCreate = input.canCreate;
                    if (dir.isDirectory()) {
                        bokForInputDir = true;
                    } else if (mustExist) {
                        bokForInputDir = false;
                    } else if (canCreate) {
                        if (!dir.exists()) {
                            int nRet = this.emitWarning(idata, idata.langpack.getString("installer.warning"), idata.langpack.getString("TargetPanel.createdir") + " " + value);
                            if (nRet == 3) {
                                return false;
                            }
                            bokForInputDir = nRet != 2;
                        }
                        if (bokForInputDir) {
                            if (!this.isWriteable(dir.toString())) {
                                this.emitError(idata, idata.langpack.getString("installer.error"), idata.langpack.getString("TargetPanel.notwritable"));
                                bokForInputDir = false;
                            } else {
                                bokForInputDir = dir.mkdirs();
                            }
                        }
                    } else {
                        bokForInputDir = true;
                    }
                }
                if (!bokForInputDir) continue;
                done = true;
                if (input.validators == null || input.validators.isEmpty() || (validation = new StringInputProcessingClient(this.instalData, value, input.validators)).validate()) continue;
                done = false;
                System.out.println("Validation failed, please verify your input.");
                System.out.println("Validation error: " + validation.getValidationMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                done = false;
            }
        } while (!done);
        idata.setVariable(variable, value);
        return true;
    }

    boolean processComboRadioField(Input input, AutomatedInstallData idata) {
        List<Choice> lisChoices;
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        String currentvariablevalue = idata.getVariable(variable);
        input.iSelectedChoice = -1;
        boolean userinput = false;
        if (input.strText != null) {
            System.out.println(input.strText);
        }
        if ((lisChoices = input.listChoices).size() == 0) {
            Debug.trace("Error: no spec element defined in file field");
            return false;
        }
        if (currentvariablevalue != null) {
            userinput = true;
        }
        for (int i = 0; i < lisChoices.size(); ++i) {
            Choice choice = lisChoices.get(i);
            String value = choice.strValue;
            if (userinput) {
                if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                    input.iSelectedChoice = i;
                }
            } else {
                String set = choice.strSet;
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    if (set.equals(TRUE)) {
                        input.iSelectedChoice = i;
                    }
                }
            }
            System.out.println(i + "  [" + (input.iSelectedChoice == i ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            boolean bKeepAsking = true;
            while (bKeepAsking) {
                System.out.println("input selection:");
                String strIn = br.readLine();
                if (strIn.trim().equals("") && input.iSelectedChoice != -1) {
                    bKeepAsking = false;
                }
                int j = -1;
                try {
                    j = Integer.valueOf(strIn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (j < 0 || j >= lisChoices.size()) continue;
                input.iSelectedChoice = j;
                bKeepAsking = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String newValue = input.listChoices.get((int)input.iSelectedChoice).strValue;
        idata.setVariable(variable, newValue);
        if (input.revalidate && !currentvariablevalue.equals(newValue)) {
            throw new RevalidationTriggeredException();
        }
        return true;
    }

    boolean processCheckField(Input input, AutomatedInstallData idata) {
        List<Choice> lisChoices;
        String variable = input.strVariableName;
        if (variable == null || variable.length() == 0) {
            return false;
        }
        String currentvariablevalue = idata.getVariable(variable);
        if (currentvariablevalue == null) {
            currentvariablevalue = "";
        }
        if ((lisChoices = input.listChoices).size() == 0) {
            Debug.trace("Error: no spec element defined in check field");
            return false;
        }
        Choice choice = null;
        for (int i = 0; i < lisChoices.size(); ++i) {
            choice = lisChoices.get(i);
            String value = choice.strValue;
            if (value != null && value.length() > 0 && currentvariablevalue.equals(value)) {
                input.iSelectedChoice = i;
                continue;
            }
            String set = input.strDefaultValue;
            if (set == null) continue;
            if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
                set = vs.substitute(set, null);
            }
            if (!set.equals(TRUE)) continue;
            input.iSelectedChoice = 1;
        }
        System.out.println("  [" + (input.iSelectedChoice == 1 ? "x" : " ") + "] " + (choice.strText != null ? choice.strText : ""));
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            boolean bKeepAsking = true;
            while (bKeepAsking) {
                System.out.println("input 1 to select, 0 to deselect:");
                String strIn = br.readLine();
                if (strIn.trim().equals("")) {
                    bKeepAsking = false;
                }
                int j = -1;
                try {
                    j = Integer.valueOf(strIn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (j != 0 && j != 1) continue;
                input.iSelectedChoice = j;
                bKeepAsking = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String newValue = input.listChoices.get((int)input.iSelectedChoice).strValue;
        idata.setVariable(variable, newValue);
        if (input.revalidate && !currentvariablevalue.equals(newValue)) {
            throw new RevalidationTriggeredException();
        }
        return true;
    }

    public Input getInputFromField(IXMLElement field, AutomatedInstallData idata) {
        String strVariableName = field.getAttribute(VARIABLE);
        String strFieldType = field.getAttribute(TYPE_ATTRIBUTE);
        if (TITLE_FIELD.equals(strFieldType)) {
            String strText = null;
            strText = this.getText(field, idata);
            return new Input(strVariableName, null, null, TITLE_FIELD, strText, 0);
        }
        if (STATIC_TEXT.equals(strFieldType)) {
            String strText = null;
            String key = field.getAttribute(PANEL_IDENTIFIER);
            strText = field.getAttribute(TEXT);
            if (key != null && idata.langpack != null) {
                try {
                    String langPackText = idata.langpack.getString(key);
                    if (langPackText != null && !key.equals(langPackText)) {
                        strText = langPackText;
                    }
                }
                catch (Throwable langPackText) {
                    // empty catch block
                }
            }
            return new Input(strVariableName, null, null, STATIC_TEXT, strText, 0);
        }
        if (TEXT_FIELD.equals(strFieldType) || FILE.equals(strFieldType) || DIR.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec != null) {
                strText = this.getText(spec, idata);
                strSet = spec.getAttribute(SET);
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            choicesList.add(new Choice(strText, null, strSet));
            if (DIR.equals(strFieldType)) {
                boolean mustExist = true;
                boolean create = true;
                mustExist = Boolean.parseBoolean(spec.getAttribute("mustExist", TRUE));
                create = Boolean.parseBoolean(spec.getAttribute("create", "false"));
                return new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0, mustExist, create);
            }
            return new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0);
        }
        if (RULE_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec != null) {
                strText = spec.getAttribute(TEXT);
                strSet = spec.getAttribute(SET);
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            if (strSet != null && spec.getAttribute(LAYOUT) != null) {
                String token;
                StringTokenizer layoutTokenizer = new StringTokenizer(spec.getAttribute(LAYOUT));
                List<String> listSet = Arrays.asList(new String[layoutTokenizer.countTokens()]);
                StringTokenizer setTokenizer = new StringTokenizer(strSet);
                while (setTokenizer.hasMoreTokens()) {
                    token = setTokenizer.nextToken();
                    if (token.indexOf(":") <= -1) continue;
                    listSet.set(new Integer(token.substring(0, token.indexOf(":"))), token.substring(token.indexOf(":") + 1));
                }
                int iCounter = 0;
                StringBuffer sb = new StringBuffer();
                String strRusultFormat = spec.getAttribute(RESULT_FORMAT);
                String strSpecialSeparator = spec.getAttribute(SPECIAL_SEPARATOR);
                while (layoutTokenizer.hasMoreTokens()) {
                    token = layoutTokenizer.nextToken();
                    if (token.matches(".*:.*:.*")) {
                        sb.append(listSet.get(iCounter) != null ? listSet.get(iCounter) : "");
                        ++iCounter;
                        continue;
                    }
                    if (SPECIAL_SEPARATOR.equals(strRusultFormat)) {
                        sb.append(strSpecialSeparator);
                        continue;
                    }
                    if (PLAIN_STRING.equals(strRusultFormat)) continue;
                    sb.append(token);
                }
                strSet = sb.toString();
            }
            choicesList.add(new Choice(strText, null, strSet));
            return new Input(strVariableName, strSet, choicesList, TEXT_FIELD, strFieldText, 0);
        }
        if (COMBO_FIELD.equals(strFieldType) || RADIO_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            int selection = -1;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            Vector<IXMLElement> choices = null;
            if (spec != null) {
                choices = spec.getChildrenNamed(CHOICE);
                strFieldText = this.getText(spec, idata);
            }
            for (int i = 0; i < choices.size(); ++i) {
                VariableSubstitutor vs;
                String set;
                IXMLElement choice = choices.elementAt(i);
                String processorClass = choice.getAttribute("processor");
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).newInstance()).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    set = choice.getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        vs = new VariableSubstitutor(idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        String choiceSet = null;
                        if (token.equals(set)) {
                            choiceSet = TRUE;
                            selection = counter;
                        }
                        choicesList.add(new Choice(token, token, choiceSet));
                        ++counter;
                    }
                    continue;
                }
                String value = choice.getAttribute(VALUE);
                set = choice.getAttribute(SET);
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        vs = new VariableSubstitutor(idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    if (set.equalsIgnoreCase(TRUE)) {
                        selection = i;
                    }
                }
                choicesList.add(new Choice(choice.getAttribute(TEXT), value, set));
            }
            if (choicesList.size() == 1) {
                selection = 0;
            }
            return new Input(strVariableName, null, choicesList, strFieldType, strFieldText, selection, "yes".equals(spec.getAttribute("revalidate")));
        }
        if (CHECK_FIELD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            int iSelectedChoice = 0;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            IXMLElement description = field.getFirstChildNamed(DESCRIPTION);
            if (spec != null) {
                strText = this.getText(spec, idata);
                strSet = spec.getAttribute(SET);
                choicesList.add(new Choice(strText, spec.getAttribute("false"), null));
                choicesList.add(new Choice(strText, spec.getAttribute(TRUE), null));
                if (strSet != null && strSet.equalsIgnoreCase(TRUE)) {
                    iSelectedChoice = 1;
                }
            } else {
                System.out.println("No spec specified for input of type check");
            }
            if (description != null) {
                strFieldText = description.getAttribute(TEXT);
            }
            return new Input(strVariableName, strSet, choicesList, CHECK_FIELD, strFieldText, iSelectedChoice, "yes".equals(spec.getAttribute("revalidate")));
        }
        if (SPACE.equals(strFieldType)) {
            return SPACE_INTPUT_FIELD;
        }
        if (DIVIDER.equals(strFieldType)) {
            return DIVIDER_INPUT_FIELD;
        }
        if (PASSWORD.equals(strFieldType)) {
            ArrayList<Choice> choicesList = new ArrayList<Choice>();
            String strFieldText = null;
            String strSet = null;
            String strText = null;
            IXMLElement spec = field.getFirstChildNamed(SPEC);
            if (spec != null) {
                Vector<IXMLElement> pwds = spec.getChildrenNamed(PWD);
                if (pwds == null || pwds.size() == 0) {
                    System.out.println("No pwd specified in the spec for type password");
                    return null;
                }
                Input[] inputs = new Input[pwds.size()];
                for (int i = 0; i < pwds.size(); ++i) {
                    IXMLElement pwde = pwds.elementAt(i);
                    strText = this.getText(pwde, idata);
                    strSet = pwde.getAttribute(SET);
                    choicesList.add(new Choice(strText, null, strSet));
                    inputs[i] = new Input(strVariableName, strSet, choicesList, strFieldType, strFieldText, 0);
                }
                return new Password(strFieldType, inputs);
            }
            System.out.println("No spec specified for input of type password");
            return null;
        }
        System.out.println(strFieldType + " field collection not implemented");
        return null;
    }

    private boolean itemRequiredFor(Vector<IXMLElement> packs, AutomatedInstallData idata) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < idata.selectedPacks.size(); ++i) {
            String selected = idata.selectedPacks.get((int)i).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute(NAME, "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean itemRequiredForOs(Vector<IXMLElement> os) {
        if (os.size() == 0) {
            return true;
        }
        for (int i = 0; i < os.size(); ++i) {
            String family = os.elementAt(i).getAttribute(FAMILY);
            boolean match = false;
            if ("windows".equals(family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(family)) {
                match = OsVersion.IS_UNIX;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private String getText(IXMLElement element, AutomatedInstallData idata) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute(PANEL_IDENTIFIER);
        String text = element.getAttribute(TEXT);
        if (key != null && idata.langpack != null) {
            try {
                String langPackText = idata.langpack.getString(key);
                if (langPackText != null && !key.equals(langPackText)) {
                    text = langPackText;
                }
            }
            catch (Throwable langPackText) {
                // empty catch block
            }
        }
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        return vs.substitute(text, null);
    }

    public static class Password
    extends Input {
        Input[] input;

        public Password(String strFieldType, Input[] input) {
            super(strFieldType);
            this.input = input;
        }
    }

    public static class Choice {
        String strText;
        String strValue;
        String strSet;

        public Choice(String strText, String strValue, String strSet) {
            this.strText = strText;
            this.strValue = strValue;
            this.strSet = strSet;
        }
    }

    public static class Input {
        boolean canCreate = true;
        boolean mustExist = true;
        String strVariableName;
        String strDefaultValue;
        List<Choice> listChoices;
        String strFieldType;
        String strText;
        int iSelectedChoice = -1;
        boolean revalidate;
        public List<ValidatorContainer> validators;

        public Input(String strFieldType) {
            this.strFieldType = strFieldType;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice, boolean mustExist, boolean canCreate) {
            this(strVariableName, strDefaultValue, listChoices, strFieldType, strFieldText, iSelectedChoice);
            this.mustExist = mustExist;
            this.canCreate = canCreate;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice) {
            this.strVariableName = strVariableName;
            this.strDefaultValue = strDefaultValue;
            this.listChoices = listChoices;
            this.strFieldType = strFieldType;
            this.strText = strFieldText;
            this.iSelectedChoice = iSelectedChoice;
        }

        public Input(String strVariableName, String strDefaultValue, List<Choice> listChoices, String strFieldType, String strFieldText, int iSelectedChoice, boolean revalidate) {
            this(strVariableName, strDefaultValue, listChoices, strFieldType, strFieldText, iSelectedChoice);
            this.revalidate = revalidate;
        }
    }

    private class RevalidationTriggeredException
    extends RuntimeException {
        private RevalidationTriggeredException() {
        }
    }
}

