/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;

public class PacksPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    public LocaleDatabase langpack;

    private boolean askSelected(boolean defaultValue) {
        boolean selected = defaultValue;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            boolean bKeepAsking = true;
            while (bKeepAsking) {
                PacksPanelConsoleHelper.out(this.langpack.getString("PacksPanel.packselect"));
                String strIn = br.readLine();
                if (strIn.trim().equals("")) {
                    bKeepAsking = false;
                }
                int j = -1;
                try {
                    j = Integer.valueOf(strIn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (j != 0 && j != 1) continue;
                selected = j == 1;
                bKeepAsking = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return selected;
    }

    private static void out(String message) {
        System.out.println(message);
    }

    private String getI18n(LocaleDatabase langpack, String key, String defaultValue) {
        String text = langpack.getString(key);
        return text != null && !text.equals(key) ? text : defaultValue;
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData) {
        this.langpack = installData.langpack;
        try {
            InputStream inputStream = ResourceManager.getInstance().getInputStream("packsLang.xml");
            this.langpack.add(inputStream);
        }
        catch (Exception e) {
            Debug.trace(e);
        }
        LinkedList<Pack> selectedPacks = new LinkedList<Pack>();
        PacksPanelConsoleHelper.out("");
        PacksPanelConsoleHelper.out(this.langpack.getString("PacksPanel.info"));
        PacksPanelConsoleHelper.out("");
        for (Pack pack : installData.availablePacks) {
            StringBuilder option = new StringBuilder(64);
            option.append("[").append(pack.required ? this.langpack.getString("PacksPanel.required") : (pack.preselected ? "x" : " ")).append("] ").append(this.getI18n(this.langpack, pack.id, pack.name));
            String descr = this.getI18n(this.langpack, pack.id + ".description", pack.description);
            if (descr != null && descr.length() > 0) {
                option.append(" (" + descr + ")");
            }
            PacksPanelConsoleHelper.out(option.toString());
            if (!pack.required && !this.askSelected(pack.preselected)) continue;
            selectedPacks.add(pack);
        }
        PacksPanelConsoleHelper.out("");
        PacksPanelConsoleHelper.out(this.langpack.getString("PacksPanel.done"));
        installData.selectedPacks = selectedPacks;
        int i = this.askEndOfConsolePanel(installData);
        if (i == 1) {
            String summaryCaption = installData.langpack.getString("PacksPanel.summaryCaption");
            ArrayList<String> lstTarget = new ArrayList<String>();
            for (Pack pack : installData.selectedPacks) {
                lstTarget.add(this.getI18NPackName(installData, pack));
            }
            installData.summaryText.put(summaryCaption, lstTarget);
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(installData);
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return false;
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return false;
    }
}

