/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.InstallTypePanelAutomationHelper;
import com.izforge.izpack.panels.TargetPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InstallTypePanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private static final String SPEC_FILE_NAME = "productsSpec.txt";
    public static String ADX_NODE_TYPE = "component.node.type";
    public static String ADX_NODE_FAMILY = "component.node.family";
    private JRadioButton normalinstall;
    private JRadioButton modifyinstall;
    private DefaultListModel<String> listItems;
    private JList<String> installedComponents;
    private HashMap<String, String[]> lstCompProps;
    private String selectedKey;

    public InstallTypePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.buildGUI();
    }

    private void loadComponents() {
        if (this.idata.info.needAdxAdmin()) {
            this.loadListFromAdxadmin();
        } else if (OsVersion.IS_WINDOWS) {
            this.loadListFromRegistry();
        }
    }

    private void loadListFromRegistry() {
        try {
            String uninstallName = this.idata.getVariable("UNINSTALL_NAME");
            String uninstallKeySuffix = this.idata.getVariable("UninstallKeySuffix");
            String uninstallKeyPrefix = new String(uninstallName);
            ArrayList<String> uninstallKeyPrefixList = new ArrayList<String>();
            if (uninstallKeySuffix != null && !"".equals(uninstallKeySuffix)) {
                uninstallKeyPrefix = uninstallKeyPrefix.substring(0, uninstallKeyPrefix.length() - uninstallKeySuffix.length());
            }
            uninstallKeyPrefixList.add(uninstallKeyPrefix);
            try {
                InputStream input = ResourceManager.getInstance().getInputStream(SPEC_FILE_NAME);
                if (input != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    StringBuilder out = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        uninstallKeyPrefixList.add(line.trim());
                    }
                    reader.close();
                }
            }
            catch (Exception ex) {
                Debug.log(ex);
            }
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh == null) {
                return;
            }
            rh.verify(this.idata);
            String UninstallKeyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
            int oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            List<String> lstSubKeys = Arrays.asList(rh.getSubkeys(UninstallKeyName));
            for (String uninstallKey : lstSubKeys) {
                for (String keyToSearchFor : uninstallKeyPrefixList) {
                    File installInformation;
                    if (!uninstallKey.startsWith(keyToSearchFor)) continue;
                    String productPath = null;
                    try {
                        productPath = rh.getValue(UninstallKeyName + "\\" + uninstallKey, "UninstallString").getStringData();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    String productVersion = null;
                    try {
                        productVersion = rh.getValue(UninstallKeyName + "\\" + uninstallKey, "DisplayVersion").getStringData();
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    productPath = productPath.substring(productPath.lastIndexOf("\"", productPath.length() - 2) + 1, productPath.length() - 29);
                    String name = uninstallKey;
                    if (name.indexOf(" - ") > 0) {
                        name = name.substring(name.indexOf(" - ") + 3);
                    }
                    if (!(installInformation = new File(productPath + File.separator + ".installationinformation")).exists()) continue;
                    String key = name + " " + productVersion + " (" + productPath + ")";
                    this.listItems.addElement(key);
                    this.lstCompProps.put(key, new String[]{name, productPath, productVersion});
                }
            }
            rh.setRoot(oldVal);
        }
        catch (Exception ex) {
            Debug.trace(ex);
        }
    }

    private void loadListFromAdxadmin() {
        try {
            String strAdxAdminPath = "";
            if (OsVersion.IS_UNIX) {
                File adxadmFile = new File("/sage/adxadm");
                if (!adxadmFile.exists()) {
                    adxadmFile = new File("/adonix/adxadm");
                }
                if (!adxadmFile.exists()) {
                    return;
                }
                FileReader readerAdxAdmFile = new FileReader(adxadmFile);
                BufferedReader buffread = new BufferedReader(readerAdxAdmFile);
                strAdxAdminPath = buffread.readLine();
            } else {
                RegistryHandler rh = RegistryDefaultHandler.getInstance();
                if (rh == null) {
                    return;
                }
                rh.verify(this.idata);
                if (!rh.adxadminProductRegistered()) {
                    return;
                }
                String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
                int oldVal = rh.getRoot();
                rh.setRoot(-2147483646);
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
                }
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    return;
                }
                strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
                rh.setRoot(oldVal);
            }
            if (strAdxAdminPath == null || "".equals(strAdxAdminPath)) {
                return;
            }
            File dirAdxDir = new File(strAdxAdminPath);
            if (!dirAdxDir.exists() || !dirAdxDir.isDirectory()) {
                return;
            }
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(dirAdxDir.getAbsolutePath());
            strBuilder.append(File.separator);
            strBuilder.append("inst");
            strBuilder.append(File.separator);
            strBuilder.append("adxinstalls.xml");
            File fileAdxinstalls = new File(strBuilder.toString());
            if (!fileAdxinstalls.exists()) {
                return;
            }
            String strComponentType = this.idata.getVariable(ADX_NODE_TYPE);
            String strComponentFamily = this.idata.getVariable(ADX_NODE_FAMILY);
            if (strComponentFamily == null) {
                return;
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fileAdxinstalls);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//module[@family='" + strComponentFamily + "'";
            if (strComponentType != null) {
                expression = expression + " and @type='" + strComponentType + "'";
            }
            expression = expression + "]";
            NodeList nodeLst = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeLst.getLength(); ++i) {
                String key;
                Element moduleNode = (Element)nodeLst.item(i);
                String path = xPath.evaluate("./component." + strComponentFamily.toLowerCase() + ".path", moduleNode);
                String strversion = xPath.evaluate("./component." + strComponentFamily.toLowerCase() + ".version", moduleNode);
                String name = moduleNode.getAttribute("name");
                File installInformation = new File(path + File.separator + ".installationinformation");
                if (installInformation.exists()) {
                    key = name + " " + strversion + " (" + path + ")";
                    this.listItems.addElement(key);
                    this.lstCompProps.put(key, new String[]{name, path, strversion});
                    continue;
                }
                if (!path.endsWith(File.separator + "tool") || !(installInformation = new File((path = path.substring(0, path.length() - 5)) + File.separator + ".installationinformation")).exists()) continue;
                key = name + " " + strversion + " (" + path + ")";
                this.listItems.addElement(key);
                this.lstCompProps.put(key, new String[]{name, path, strversion});
            }
        }
        catch (Exception ex) {
            Debug.trace(ex);
        }
    }

    private void buildGUI() {
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 3));
        topPanel.add(LabelFactory.create(this.parent.langpack.getString("InstallationTypePanel.info"), this.parent.icons.getImageIcon("history"), 10));
        topPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        ButtonGroup group = new ButtonGroup();
        boolean modifyinstallation = Boolean.valueOf(this.idata.getVariable("MODIFY.IZPACK.INSTALL"));
        this.normalinstall = new JRadioButton(this.parent.langpack.getString("InstallationTypePanel.normal"), !modifyinstallation);
        this.normalinstall.addActionListener(this);
        group.add(this.normalinstall);
        topPanel.add(this.normalinstall);
        this.modifyinstall = new JRadioButton(this.parent.langpack.getString("InstallationTypePanel.modify"), modifyinstallation);
        this.modifyinstall.addActionListener(this);
        group.add(this.modifyinstall);
        topPanel.add(this.modifyinstall);
        this.lstCompProps = new HashMap();
        this.listItems = new DefaultListModel();
        this.installedComponents = new JList<String>(this.listItems);
        this.installedComponents.setSelectionMode(0);
        this.installedComponents.setLayoutOrientation(0);
        this.installedComponents.setVisibleRowCount(5);
        this.installedComponents.setEnabled(false);
        JScrollPane listScroller = new JScrollPane(this.installedComponents);
        listScroller.setPreferredSize(new Dimension(600, 100));
        listScroller.setAlignmentX(0.0f);
        topPanel.add(listScroller);
        this.add((Component)topPanel, "nextLine");
        this.setInitialFocus(this.normalinstall);
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public void panelActivate() {
        this.listItems.clear();
        this.lstCompProps.clear();
        this.loadComponents();
        boolean modifyinstallation = Boolean.valueOf(this.idata.getVariable("MODIFY.IZPACK.INSTALL"));
        if (modifyinstallation) {
            this.modifyinstall.setSelected(true);
            this.installedComponents.setEnabled(true);
            if (this.selectedKey != null) {
                if (this.listItems.contains(this.selectedKey)) {
                    this.installedComponents.setSelectedValue(this.selectedKey, true);
                } else if (this.listItems.size() > 0) {
                    this.installedComponents.setSelectedIndex(0);
                }
            } else if (this.listItems.size() > 0) {
                this.installedComponents.setSelectedIndex(0);
            }
        } else {
            this.normalinstall.setSelected(true);
            this.installedComponents.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Debug.trace("installation type changed");
        if (e.getSource() == this.normalinstall) {
            Debug.trace("normal installation");
            this.installedComponents.clearSelection();
            this.installedComponents.setEnabled(false);
            this.idata.setVariable("MODIFY.IZPACK.INSTALL", "false");
        } else if (e.getSource() == this.modifyinstall) {
            Debug.trace("modification installation");
            this.installedComponents.setEnabled(true);
            this.idata.setVariable("MODIFY.IZPACK.INSTALL", "true");
            if (this.selectedKey != null) {
                if (this.listItems.contains(this.selectedKey)) {
                    this.installedComponents.setSelectedValue(this.selectedKey, true);
                } else if (this.listItems.size() > 0) {
                    this.installedComponents.setSelectedIndex(0);
                }
            } else if (this.listItems.size() > 0) {
                this.installedComponents.setSelectedIndex(0);
            }
        } else if (e.getSource() == this.installedComponents) {
            // empty if block
        }
    }

    public String getPathFromSelected() {
        String compPath = null;
        if (this.installedComponents.getSelectedValue() != null) {
            String key = this.installedComponents.getSelectedValue();
            String[] compProps = this.lstCompProps.get(key);
            compPath = compProps[1];
        }
        return compPath;
    }

    @Override
    public boolean isValidated() {
        Boolean modifyinstallation = Boolean.valueOf(this.idata.getVariable("MODIFY.IZPACK.INSTALL"));
        if (modifyinstallation.booleanValue()) {
            String compPath = this.getPathFromSelected();
            if (compPath == null) {
                return false;
            }
            File installationinformation = new File(compPath + File.separator + ".installationinformation");
            if (!installationinformation.exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.required.forModificationInstallation"));
                return false;
            }
            TargetPanel.reset();
            this.idata.setInstallPath(compPath);
            this.selectedKey = this.installedComponents.getSelectedValue();
        }
        return super.isValidated();
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        new InstallTypePanelAutomationHelper().makeXMLData(this.idata, panelRoot);
    }

    @Override
    public String getSummaryBody() {
        if (Boolean.parseBoolean(this.idata.getVariable("MODIFY.IZPACK.INSTALL"))) {
            return this.parent.langpack.getString("InstallationTypePanel.modify");
        }
        return this.parent.langpack.getString("InstallationTypePanel.normal");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.selectedKey = this.installedComponents.getSelectedValue();
    }
}

