/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.UnpackerFactory;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.io.PrintWriter;
import java.util.Properties;

public class InstallPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole,
AbstractUIProgressHandler {
    private int noOfPacks = 0;
    private AutomatedInstallData installdata;

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return this.runConsole(installData);
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata) {
        this.installdata = idata;
        IUnpacker unpacker = UnpackerFactory.getUnpacker(idata.info.getUnpackerClassName(), idata, this);
        Thread unpackerthread = new Thread((Runnable)unpacker, "IzPack - Unpacker thread");
        unpacker.setRules(idata.getRules());
        unpackerthread.start();
        boolean done = false;
        while (!done && unpackerthread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("");
        if (unpacker.getResult()) {
            int i;
            do {
                if ((i = this.askEndOfConsolePanel(idata)) != 1) continue;
                return true;
            } while (i != 2);
            return false;
        }
        return false;
    }

    @Override
    public void emitNotification(String message) {
        System.out.println(message);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        System.err.println("[ WARNING: " + title + " ]");
        System.err.println(message);
        return true;
    }

    @Override
    public void emitError(String title, String message) {
        System.err.println("[ ERROR: " + title + " ]");
        System.err.println(message);
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        System.err.println("[ ERROR: " + title + " ]");
        System.err.println(message);
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, 2);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        boolean jo_choices = false;
        if (choices == 37) {
            jo_choices = false;
        } else if (choices == 38) {
            jo_choices = true;
        }
        System.out.println("[ " + title + " ]");
        System.out.println(question);
        int user_choice = this.askQuestion(this.installdata, this.installdata.langpack.getString("consolehelper.askyesnocancel"), 2) - 1;
        if (user_choice == 2) {
            return 45;
        }
        if (user_choice == 0) {
            return 47;
        }
        if (user_choice == -1) {
            return 49;
        }
        if (user_choice == 1) {
            return 49;
        }
        return default_choice;
    }

    @Override
    public void startAction(String name, int no_of_steps) {
        System.out.println("[ Starting to unpack ]");
        this.noOfPacks = no_of_steps;
    }

    @Override
    public void stopAction() {
        System.out.println("[ Unpacking finished ]");
        boolean done = true;
    }

    @Override
    public void progress(int val, String msg) {
    }

    @Override
    public void nextStep(String packName, int stepno, int stepsize) {
        System.out.print("[ Processing package: " + packName + " (");
        System.out.print(stepno);
        System.out.print('/');
        System.out.print(this.noOfPacks);
        System.out.println(") ]");
    }

    @Override
    public void setSubStepNo(int no_of_substeps) {
    }
}

