/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class InstallPanel
extends IzPanel
implements AbstractUIProgressHandler {
    private static final long serialVersionUID = 3257282547959410992L;
    protected JLabel tipLabel;
    protected JLabel packOpLabel;
    protected JLabel overallOpLabel;
    protected String iconName = "preferences";
    protected JProgressBar packProgressBar;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;

    public InstallPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.tipLabel = LabelFactory.create(parent.langpack.getString("InstallPanel.tip"), parent.icons.getImageIcon(this.iconName), 10);
        this.add((Component)this.tipLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packOpLabel = LabelFactory.create(" ", 10);
        this.add((Component)this.packOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(parent.langpack.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        this.add((Component)this.packProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.add(IzPanelLayout.createVerticalStrut(5));
        this.overallOpLabel = LabelFactory.create(parent.langpack.getString("InstallPanel.progress"), parent.icons.getImageIcon(this.iconName), 10);
        this.add((Component)this.overallOpLabel, IzPanelLayout.getDefaultConstraint(7));
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        if (this.noOfPacks == 1) {
            this.overallProgressBar.setIndeterminate(true);
        }
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        this.add((Component)this.overallProgressBar, IzPanelLayout.getDefaultConstraint(7));
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void startAction(String name, int noOfJobs) {
        this.noOfPacks = noOfJobs;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.parent.blockGUI();
                InstallPanel.this.overallProgressBar.setMinimum(0);
                InstallPanel.this.overallProgressBar.setMaximum(InstallPanel.this.noOfPacks);
                InstallPanel.this.overallProgressBar.setString("0 / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    @Override
    public void emitError(String title, String error) {
        this.packOpLabel.setText(error);
        this.idata.installSuccess = false;
        JOptionPane.showMessageDialog(this, error, this.parent.langpack.getString("installer.error"), 0);
    }

    @Override
    public void stopAction() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.parent.releaseGUI();
                InstallPanel.this.parent.lockPrevButton();
                InstallPanel.this.overallProgressBar.setValue(InstallPanel.this.overallProgressBar.getMaximum());
                int ppbMax = InstallPanel.this.packProgressBar.getMaximum();
                if (ppbMax < 1) {
                    ppbMax = 1;
                    InstallPanel.this.packProgressBar.setMaximum(ppbMax);
                }
                InstallPanel.this.packProgressBar.setValue(ppbMax);
                InstallPanel.this.packProgressBar.setString(((InstallPanel)InstallPanel.this).parent.langpack.getString("InstallPanel.finished"));
                InstallPanel.this.packProgressBar.setEnabled(false);
                String no_of_packs = Integer.toString(InstallPanel.this.noOfPacks);
                if (InstallPanel.this.noOfPacks == 1) {
                    InstallPanel.this.overallProgressBar.setIndeterminate(false);
                }
                InstallPanel.this.overallProgressBar.setString(no_of_packs + " / " + no_of_packs);
                InstallPanel.this.overallProgressBar.setEnabled(false);
                InstallPanel.this.packOpLabel.setText(" ");
                InstallPanel.this.packOpLabel.setEnabled(false);
                ((InstallPanel)InstallPanel.this).idata.canClose = true;
                InstallPanel.this.validated = true;
                if (((InstallPanel)InstallPanel.this).idata.panels.indexOf(this) != ((InstallPanel)InstallPanel.this).idata.panels.size() - 1) {
                    InstallPanel.this.parent.unlockNextButton();
                }
            }
        });
    }

    @Override
    public void progress(final int val, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.packProgressBar.setValue(val + 1);
                InstallPanel.this.packOpLabel.setText(msg);
            }
        });
    }

    @Override
    public void nextStep(final String packName, final int stepno, final int max) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.packProgressBar.setValue(0);
                InstallPanel.this.packProgressBar.setMinimum(0);
                InstallPanel.this.packProgressBar.setMaximum(max);
                InstallPanel.this.packProgressBar.setString(packName);
                InstallPanel.this.overallProgressBar.setValue(stepno - 1);
                InstallPanel.this.overallProgressBar.setString(Integer.toString(stepno) + " / " + Integer.toString(InstallPanel.this.noOfPacks));
            }
        });
    }

    @Override
    public void setSubStepNo(final int no_of_substeps) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPanel.this.packProgressBar.setMaximum(no_of_substeps);
            }
        });
    }

    @Override
    public void panelActivate() {
        Dimension dim = this.parent.getPanelsContainerSize();
        dim.width -= dim.width / 4;
        dim.height = 150;
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.parent.lockNextButton();
        this.parent.install(this);
    }
}

