/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;

public class HTMLLicencePanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata) {
        String license = null;
        String resNamePrefix = "HTMLLicencePanel.licence";
        try {
            license = ResourceManager.getInstance().getTextResource(resNamePrefix);
        }
        catch (Exception err) {
            license = "Error : could not load the licence text for defined resource " + resNamePrefix;
            System.out.println(license);
            return false;
        }
        int lines = 25;
        int l = 0;
        String strippedHTML = this.removeHTML(license);
        StringTokenizer st = new StringTokenizer(strippedHTML, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            System.out.println(token);
            if (++l < lines) continue;
            if (!this.doContinue()) {
                return false;
            }
            l = 0;
        }
        int i = this.askToAcceptLicense();
        if (i == 1) {
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(idata);
    }

    private boolean doContinue() {
        try {
            System.out.println("\r");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("press Enter to continue, X to exit");
            String strIn = br.readLine();
            return !strIn.equalsIgnoreCase("x");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private int askToAcceptLicense() {
        try {
            String strIn;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            do {
                System.out.println("press 1 to accept, 2 to reject, 3 to redisplay");
                strIn = br.readLine();
                if (strIn.equals("1")) {
                    return 1;
                }
                if (!strIn.equals("2")) continue;
                return 2;
            } while (!strIn.equals("3"));
            return 3;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 2;
        }
    }

    private String removeHTML(String source) {
        String result = "";
        try {
            result = source.replaceAll("\r", " ");
            result = result.replaceAll("\t", "");
            result = result.replaceAll("( )+", " ");
            result = result.replaceAll("<( )*head([^>])*>", "<head>");
            result = result.replaceAll("(<( )*(/)( )*head( )*>)", "</head>");
            result = result.replaceAll("(<head>).*(</head>)", "");
            result = result.replaceAll("<( )*script([^>])*>", "<script>");
            result = result.replaceAll("(<( )*(/)( )*script( )*>)", "</script>");
            result = result.replaceAll("(<script>).*(</script>)", "");
            result = result.replaceAll("<( )*style([^>])*>", "<style>");
            result = result.replaceAll("(<( )*(/)( )*style( )*>)", "</style>");
            result = result.replaceAll("(<style>).*(</style>)", "");
            result = result.replaceAll("(<( )*(/)( )*sup( )*>)", "</sup>");
            result = result.replaceAll("<( )*sup([^>])*>", "<sup>");
            result = result.replaceAll("(<sup>).*(</sup>)", "");
            result = result.replaceAll("<( )*td([^>])*>", "\t");
            result = result.replaceAll("<( )*br( )*>", "\r");
            result = result.replaceAll("<( )*li( )*>", "\r");
            result = result.replaceAll("<( )*div([^>])*>", "\r\r");
            result = result.replaceAll("<( )*tr([^>])*>", "\r\r");
            result = result.replaceAll("(<) h (\\w+) >", "\r");
            result = result.replaceAll("(\\b) (</) h (\\w+) (>) (\\b)", "");
            result = result.replaceAll("<( )*p([^>])*>", "\r\r");
            result = result.replaceAll("<[^>]*>", "");
            result = result.replaceAll("&bull;", " * ");
            result = result.replaceAll("&lsaquo;", "<");
            result = result.replaceAll("&rsaquo;", ">");
            result = result.replaceAll("&trade;", "(tm)");
            result = result.replaceAll("&frasl;", "/");
            result = result.replaceAll("&lt;", "<");
            result = result.replaceAll("&gt;", ">");
            result = result.replaceAll("&copy;", "(c)");
            result = result.replaceAll("&reg;", "(r)");
            result = result.replaceAll("&(.{2,6});", "");
            result = result.replaceAll("(\r)( )+(\r)", "\r\r");
            result = result.replaceAll("(\t)( )+(\t)", "\t\t");
            result = result.replaceAll("(\t)( )+(\r)", "\t\r");
            result = result.replaceAll("(\r)( )+(\t)", "\r\t");
            result = result.replaceAll("(\r)(\t)+(\\r)", "\r\r");
            result = result.replaceAll("(\r)(\t)+", "\r\t");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

