/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.StringInputProcessingClient;
import com.izforge.izpack.panels.UserInputFileFilter;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileInputField
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 4673684743657328492L;
    InstallerFrame parentFrame;
    IzPanel parent;
    List<ValidatorContainer> validators;
    JTextField filetxt;
    JButton browseBtn;
    String set;
    int size;
    InstallData data;
    String fileExtension;
    String fileExtensionDescription;
    boolean allowEmpty;
    protected static final int INVALID = 0;
    protected static final int EMPTY = 1;

    public FileInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig) {
        this(parent, data, directory, set, size, validatorConfig, null, null);
    }

    public FileInputField(IzPanel parent, InstallData data, boolean directory, String set, int size, List<ValidatorContainer> validatorConfig, String fileExt, String fileExtDesc) {
        this.parent = parent;
        this.parentFrame = parent.getInstallerFrame();
        this.data = data;
        this.validators = validatorConfig;
        this.set = set;
        this.size = size;
        this.fileExtension = fileExt;
        this.fileExtensionDescription = fileExtDesc;
        this.initialize();
    }

    private void initialize() {
        this.filetxt = new JTextField(this.set, this.size);
        this.filetxt.setCaretPosition(0);
        this.browseBtn = ButtonFactory.createButton(this.data.langpack.getString("UserInputPanel.search.browse"), this.data.buttonsHColor);
        this.browseBtn.addActionListener(this);
        this.add(this.filetxt);
        this.add(this.browseBtn);
    }

    public void setFile(String filename) {
        this.filetxt.setText(filename);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.browseBtn) {
            Debug.trace("Show dirchooser");
            String initialPath = ".";
            if (this.filetxt.getText() != null) {
                initialPath = this.filetxt.getText();
            }
            JFileChooser filechooser = new JFileChooser(initialPath);
            this.prepareFileChooser(filechooser);
            if (filechooser.showOpenDialog(this.parentFrame) == 0) {
                String selectedFile = filechooser.getSelectedFile().getAbsolutePath();
                this.filetxt.setText(selectedFile);
                Debug.trace("Setting current file chooser directory to: " + selectedFile);
            }
        }
    }

    protected void prepareFileChooser(JFileChooser filechooser) {
        filechooser.setFileSelectionMode(0);
        if (this.fileExtension != null && this.fileExtensionDescription != null) {
            UserInputFileFilter fileFilter = new UserInputFileFilter();
            fileFilter.setFileExt(this.fileExtension);
            fileFilter.setFileExtDesc(this.fileExtensionDescription);
            filechooser.setFileFilter(fileFilter);
        }
    }

    public File getSelectedFile() {
        File result = null;
        if (this.filetxt.getText() != null) {
            result = new File(this.filetxt.getText());
        }
        return result;
    }

    protected void showMessage(int k) {
        if (k == 0) {
            this.showMessage("file.notfile");
        } else if (k == 1) {
            this.showMessage("file.nofile");
        }
    }

    protected void showMessage(String messageType) {
        JOptionPane.showMessageDialog(this.parentFrame, this.parentFrame.langpack.getString("UserInputPanel." + messageType + ".message"), this.parentFrame.langpack.getString("UserInputPanel." + messageType + ".caption"), 2);
    }

    public boolean validateField() {
        boolean result = false;
        String input = this.filetxt.getText().trim();
        if (this.allowEmpty && (input == null || input.length() == 0)) {
            result = true;
        } else if (input != null && !input.equals("")) {
            if (input.startsWith("~")) {
                String home = System.getProperty("user.home");
                input = home + input.substring(1);
            }
            File file = new File(input).getAbsoluteFile();
            input = file.toString();
            this.filetxt.setText(input);
            if (!this._validate(file)) {
                result = false;
                this.showMessage(0);
            } else {
                StringInputProcessingClient processingClient = new StringInputProcessingClient(this.data, input, this.validators);
                boolean success = processingClient.validate();
                if (!success) {
                    JOptionPane.showMessageDialog(this.parentFrame, processingClient.getValidationMessage(), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                }
                result = success;
            }
        } else {
            this.showMessage(1);
        }
        return result;
    }

    protected boolean _validate(File file) {
        return file.isFile();
    }

    public boolean isAllowEmptyInput() {
        return this.allowEmpty;
    }

    public void setAllowEmptyInput(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
}

