/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.LoggedInputStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class WebAccessor {
    private Thread openerThread = null;
    private InputStream iStream = null;
    private Exception exception = null;
    private Object soloCancelOption = null;
    private Component parent = null;
    private JDialog dialog = null;
    private boolean tryProxy = false;
    private JPanel passwordPanel = null;
    private JLabel promptLabel;
    private JTextField nameField;
    private JPasswordField passField;
    private JPanel proxyPanel = null;
    private JLabel errorLabel;
    private JTextField hostField;
    private JTextField portField;
    private String url;
    private int contentLength = -1;

    public WebAccessor() {
        throw new UnsupportedOperationException();
    }

    public WebAccessor(Component parent) {
        this.parent = parent;
        Locale l = null;
        if (parent != null) {
            parent.getLocale();
        }
        this.soloCancelOption = UIManager.get("OptionPane.cancelButtonText", l);
        Authenticator.setDefault(new MyDialogAuthenticator());
    }

    public InputStream openInputStream(URL url) {
        this.setUrl(url.toExternalForm());
        block6: while (true) {
            int result;
            this.startOpening(url);
            Thread.yield();
            int retry = 28;
            while (this.exception == null && this.iStream == null && retry > 0) {
                try {
                    Thread.sleep(200L);
                    --retry;
                }
                catch (Exception e) {
                    System.out.println("In openInputStream: " + e);
                }
            }
            if (this.iStream != null || !this.tryProxy) break;
            JPanel panel = this.getProxyPanel();
            this.errorLabel.setText("Unable to connect: " + this.exception.getMessage());
            while ((result = JOptionPane.showConfirmDialog(this.parent, panel, "Proxy Configuration", 2, 3)) == 0) {
                String host = null;
                String port = null;
                try {
                    InetAddress addr = InetAddress.getByName(this.hostField.getText());
                    host = addr.getHostName();
                }
                catch (Exception x) {
                    this.errorLabel.setText("Unable to resolve Host");
                    Toolkit.getDefaultToolkit().beep();
                }
                try {
                    if (host != null) {
                        port = Integer.valueOf(this.portField.getText()).toString();
                    }
                }
                catch (NumberFormatException x) {
                    this.errorLabel.setText("Invalid Port");
                    Toolkit.getDefaultToolkit().beep();
                }
                if (host == null || port == null) continue;
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", host);
                System.getProperties().put("proxyPort", port);
                continue block6;
            }
            break;
        }
        if (this.iStream == null) {
            this.openerThread.interrupt();
        }
        return this.iStream;
    }

    private void startOpening(final URL url) {
        final WebAccessor wa = this;
        this.openerThread = new Thread(){

            @Override
            public void run() {
                WebAccessor.this.iStream = null;
                try {
                    WebAccessor.this.tryProxy = false;
                    URLConnection connection = url.openConnection();
                    if (connection instanceof HttpURLConnection) {
                        HttpURLConnection htc = (HttpURLConnection)connection;
                        WebAccessor.this.contentLength = htc.getContentLength();
                    }
                    InputStream i = connection.getInputStream();
                    WebAccessor.this.iStream = new LoggedInputStream(i, wa);
                }
                catch (ConnectException x) {
                    WebAccessor.this.tryProxy = true;
                    WebAccessor.this.exception = x;
                }
                catch (Exception x) {
                    WebAccessor.this.exception = x;
                }
                finally {
                    if (WebAccessor.this.dialog != null) {
                        Thread.yield();
                        WebAccessor.this.dialog.setVisible(false);
                    }
                }
            }
        };
        this.openerThread.start();
    }

    private JPanel getProxyPanel() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new JPanel(new BorderLayout(5, 5));
            this.errorLabel = new JLabel();
            JPanel fields = new JPanel(new GridLayout(2, 2));
            String h = (String)System.getProperties().get("proxyHost");
            String p = (String)System.getProperties().get("proxyPort");
            this.hostField = new JTextField(h != null ? h : "");
            this.portField = new JTextField(p != null ? p : "");
            JLabel host = new JLabel("Host: ");
            JLabel port = new JLabel("Port: ");
            fields.add(host);
            fields.add(this.hostField);
            fields.add(port);
            fields.add(this.portField);
            JLabel exampleLabel = new JLabel("e.g. host=\"gatekeeper.example.com\" port=\"80\"");
            this.proxyPanel.add((Component)this.errorLabel, "North");
            this.proxyPanel.add((Component)fields, "Center");
            this.proxyPanel.add((Component)exampleLabel, "South");
        }
        this.proxyPanel.validate();
        return this.proxyPanel;
    }

    private JPanel getPasswordPanel() {
        if (this.passwordPanel == null) {
            this.passwordPanel = new JPanel(new BorderLayout(5, 5));
            this.promptLabel = new JLabel();
            JPanel fields = new JPanel(new GridLayout(2, 2));
            this.nameField = new JTextField();
            this.passField = new JPasswordField();
            JLabel name = new JLabel("Name: ");
            JLabel pass = new JLabel("Password: ");
            fields.add(name);
            fields.add(this.nameField);
            fields.add(pass);
            fields.add(this.passField);
            this.passwordPanel.add((Component)this.promptLabel, "North");
            this.passwordPanel.add((Component)fields, "Center");
        }
        this.passField.setText("");
        return this.passwordPanel;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    private class MyDialogAuthenticator
    extends Authenticator {
        private MyDialogAuthenticator() {
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            JPanel p = WebAccessor.this.getPasswordPanel();
            String prompt = this.getRequestingPrompt();
            InetAddress addr = this.getRequestingSite();
            if (addr != null) {
                prompt = prompt + " (" + addr.getHostName() + ")";
            }
            WebAccessor.this.promptLabel.setText(prompt);
            int result = JOptionPane.showConfirmDialog(WebAccessor.this.parent, p, "Enter Password", 2, 3);
            if (result != 0) {
                return null;
            }
            return new PasswordAuthentication(WebAccessor.this.nameField.getText(), WebAccessor.this.passField.getPassword());
        }
    }
}

