/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PreValidatePacksPanelAction
implements PanelAction {
    private Map<String, Pack> installedpacks = null;

    @Override
    public void executeAction(AutomatedInstallData adata, AbstractUIHandler handler) {
        Boolean modifyinstallation = Boolean.valueOf(adata.getVariable("MODIFY.IZPACK.INSTALL"));
        this.installedpacks = new HashMap<String, Pack>();
        if (modifyinstallation.booleanValue()) {
            Debug.trace("Update mode, loading installed packs ...");
            try {
                FileInputStream fin = new FileInputStream(new File(adata.getInstallPath() + File.separator + ".installationinformation"));
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                for (Object e : packsinstalled) {
                    Pack pack = (Pack)e;
                    if (pack.id != null && pack.id.length() > 0) {
                        this.installedpacks.put(pack.id, pack);
                        Debug.trace("Found " + pack.id);
                        continue;
                    }
                    this.installedpacks.put(pack.name, pack);
                    Debug.trace("Found " + pack.name);
                }
                this.removeAlreadyInstalledPacks(adata.selectedPacks);
                adata.installedPacks = packsinstalled;
                for (Object object : adata.availablePacks) {
                    if (!this.installedpacks.containsKey(((Pack)object).id) && !this.installedpacks.containsKey(((Pack)object).name)) continue;
                    adata.selectedPacks.add((Pack)object);
                    ((Pack)object).preselected = true;
                    ((Pack)object).required = true;
                }
                Debug.trace("Found " + packsinstalled.size() + " installed packs");
                Debug.trace("Loading properties ...");
                Properties variables = (Properties)oin.readObject();
                for (String string : variables.keySet()) {
                    if (Character.isLowerCase(string.charAt(0)) || "UNINSTALL_NAME".equals(string)) {
                        adata.setVariable(string, (String)variables.get(string));
                        Debug.trace(string + "=" + (String)variables.get(string));
                    }
                    if (!string.equals("syracuse.winservice.username")) continue;
                    adata.setVariable("syracuse.winservice.username.oldvalue", (String)variables.get(string));
                }
                fin.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    private void removeAlreadyInstalledPacks(List<?> selectedpacks) {
        ArrayList<Pack> removepacks = new ArrayList<Pack>();
        for (Object selectedpack1 : selectedpacks) {
            Pack selectedpack = (Pack)selectedpack1;
            String key = "";
            key = selectedpack.id != null && selectedpack.id.length() > 0 ? selectedpack.id : selectedpack.name;
            if (!this.installedpacks.containsKey(key)) continue;
            removepacks.add(selectedpack);
        }
        for (Pack removepack : removepacks) {
            selectedpacks.remove(removepack);
        }
    }
}

