/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public abstract class PanelConsoleHelper {
    protected AutomatedInstallData instalData = null;
    private DataValidator validationService = null;
    private List<PanelAction> preActivateActions = null;
    private List<PanelAction> preValidateActions = null;
    private List<PanelAction> postValidateActions = null;

    public String getI18NPackName(AutomatedInstallData idata, Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (idata.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = idata.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    public boolean isWriteable(String pstrPath) {
        File existParent = IoHelper.existingParent(new File(pstrPath));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public void emitNotification(AutomatedInstallData idata, String message) {
        System.out.println(message);
    }

    public int emitWarning(AutomatedInstallData idata, String title, String message) {
        System.out.println(idata.langpack.getString("installer.warning") + " " + message);
        return this.askQuestion(idata, idata.langpack.getString("consolehelper.askyesno"), 3);
    }

    public void emitError(AutomatedInstallData idata, String title, String message) {
        System.out.println(idata.langpack.getString("installer.error") + " " + message);
    }

    public void emitErrorAndBlockNext(String title, String message) {
        this.emitNotification(null, "[GENERAL ERROR]");
        this.emitNotification(null, message);
        Housekeeper.getInstance().shutDown(10);
    }

    public int doContinue(AutomatedInstallData idata) {
        return this.askQuestion(idata, idata.langpack.getString("consolehelper.askcontinue"), 3);
    }

    public int askToAccept(AutomatedInstallData idata) {
        return this.askQuestion(idata, idata.langpack.getString("consolehelper.askaccept"), 2);
    }

    public int askEndOfConsolePanel(AutomatedInstallData idata) {
        return this.askQuestion(idata, idata.langpack.getString("consolehelper.askredisplay"), 2);
    }

    public int askQuestion(AutomatedInstallData idata, String pstrQuestion, int pDef) {
        try {
            String strIn;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            do {
                System.out.println(pstrQuestion);
                strIn = br.readLine();
                if (strIn.equals("1")) {
                    return 1;
                }
                if (!strIn.equals("2")) continue;
                return 2;
            } while (!strIn.equals("3"));
            return 3;
        }
        catch (IOException e) {
            e.printStackTrace();
            return pDef;
        }
    }

    public void addPreActivationAction(PanelAction preActivateAction) {
        if (this.preActivateActions == null) {
            this.preActivateActions = new ArrayList<PanelAction>();
        }
        this.preActivateActions.add(preActivateAction);
    }

    public void addPreValidationAction(PanelAction preValidateAction) {
        if (this.preValidateActions == null) {
            this.preValidateActions = new ArrayList<PanelAction>();
        }
        this.preValidateActions.add(preValidateAction);
    }

    public void addPostValidationAction(PanelAction postValidateAction) {
        if (this.postValidateActions == null) {
            this.postValidateActions = new ArrayList<PanelAction>();
        }
        this.postValidateActions.add(postValidateAction);
    }

    public final void executePreActivationActions() {
        if (this.preActivateActions != null) {
            for (int actionIndex = 0; actionIndex < this.preActivateActions.size(); ++actionIndex) {
                this.preActivateActions.get(actionIndex).executeAction(this.instalData, null);
            }
        }
    }

    public final void executePreValidationActions() {
        if (this.preValidateActions != null) {
            for (int actionIndex = 0; actionIndex < this.preValidateActions.size(); ++actionIndex) {
                this.preValidateActions.get(actionIndex).executeAction(this.instalData, null);
            }
        }
    }

    public final void executePostValidationActions() {
        if (this.postValidateActions != null) {
            for (int actionIndex = 0; actionIndex < this.postValidateActions.size(); ++actionIndex) {
                this.postValidateActions.get(actionIndex).executeAction(this.instalData, null);
            }
        }
    }

    public void setValidationService(DataValidator validationService) {
        this.validationService = validationService;
    }

    public void setAutomatedInstallData(AutomatedInstallData idata) {
        this.instalData = idata;
    }
}

