/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IMultiVolumeUnpackerHelper;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.panels.NextMediaDialog;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import java.awt.Frame;
import java.io.File;
import javax.swing.JOptionPane;

public class MultiVolumeUnpackerHelper
implements IMultiVolumeUnpackerHelper {
    private AutomatedInstallData idata;
    private AbstractUIProgressHandler handler;

    @Override
    public File enterNextMediaMessage(String volumename, boolean lastcorrupt) {
        if (lastcorrupt) {
            InstallerFrame parent = null;
            if (this.handler != null && this.handler instanceof IzPanel) {
                parent = ((IzPanel)((Object)this.handler)).getInstallerFrame();
            }
            JOptionPane.showMessageDialog(parent, this.idata.langpack.getString("nextmedia.corruptmedia"), this.idata.langpack.getString("nextmedia.corruptmedia.title"), 0);
        }
        Debug.trace("Enter next media: " + volumename);
        File nextvolume = new File(volumename);
        NextMediaDialog nmd = null;
        while (!nextvolume.exists() || lastcorrupt) {
            if (this.handler != null && this.handler instanceof IzPanel) {
                InstallerFrame installframe = ((IzPanel)((Object)this.handler)).getInstallerFrame();
                nmd = new NextMediaDialog((Frame)installframe, this.idata, volumename);
            } else {
                nmd = new NextMediaDialog(null, this.idata, volumename);
            }
            nmd.setVisible(true);
            String nextmediainput = nmd.getNextMedia();
            if (nextmediainput != null) {
                nextvolume = new File(nextmediainput);
            } else {
                Debug.trace("Input from NextMediaDialog was null");
                nextvolume = new File(volumename);
            }
            if (volumename.equals(nextvolume.getAbsolutePath()) && lastcorrupt) continue;
            lastcorrupt = false;
        }
        return nextvolume;
    }

    @Override
    public File enterNextMediaMessage(String volumename) {
        return this.enterNextMediaMessage(volumename, false);
    }

    @Override
    public void init(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        this.idata = idata;
        this.handler = handler;
    }
}

