/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.installer.GUIInstaller;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Installer {
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    public static final int CONSOLE_INSTALL = 0;
    public static final int CONSOLE_GEN_TEMPLATE = 1;
    public static final int CONSOLE_FROM_TEMPLATE = 2;

    public static void main(String[] args) {
        Debug.log(" - Logger initialized at '" + new Date(System.currentTimeMillis()) + "'.");
        Debug.log(" - commandline args: " + StringTool.stringArrayToSpaceSeparatedString(args));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            int consoleAction = 0;
            String path = null;
            String langcode = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-console".equalsIgnoreCase(arg)) {
                        type = 2;
                        continue;
                    }
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 1;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        type = 2;
                        consoleAction = 2;
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-language".equalsIgnoreCase(arg)) {
                        type = 2;
                        langcode = args_it.next().trim();
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (NoSuchElementException e) {
                    System.err.println("- ERROR -");
                    System.err.println("Option \"" + arg + "\" requires an argument!");
                    System.exit(1);
                }
            }
            if (type == 0 && GraphicsEnvironment.isHeadless()) {
                type = 2;
            }
            switch (type) {
                case 0: {
                    GUIInstaller guiAi = new GUIInstaller(args);
                    break;
                }
                case 1: {
                    AutomatedInstaller ai = new AutomatedInstaller(path, args);
                    ai.doInstall();
                    break;
                }
                case 2: {
                    ConsoleInstaller consoleInstaller = new ConsoleInstaller(langcode, args);
                    consoleInstaller.run(consoleAction, path);
                }
            }
        }
        catch (Exception e) {
            System.err.println("- ERROR -");
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

