/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Panel;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.ConditionHistory;
import com.izforge.izpack.installer.ConditionHistoryTableCellRenderer;
import com.izforge.izpack.installer.ConditionHistoryTableModel;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.VariableHistory;
import com.izforge.izpack.installer.VariableHistoryTableCellRenderer;
import com.izforge.izpack.installer.VariableHistoryTableModel;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class Debugger {
    private RulesEngine rules;
    private InstallData idata;
    private Properties lasttimevariables;
    private JTextPane debugtxt;
    private IconsDatabase icons;
    private Map<String, VariableHistory> variableshistory;
    private Map<String, ConditionHistory> conditionhistory;
    private JTable variablestable;
    private VariableHistoryTableModel variablesmodel;
    private VariableHistoryTableCellRenderer variablesrenderer;
    private ConditionHistoryTableModel conditionhistorymodel;
    private ConditionHistoryTableCellRenderer conditionhistoryrenderer;

    public Debugger(InstallData installdata, IconsDatabase icons, RulesEngine rules) {
        this.idata = installdata;
        this.rules = rules;
        this.lasttimevariables = (Properties)this.idata.variables.clone();
        this.icons = icons;
        this.variableshistory = new HashMap<String, VariableHistory>();
        this.conditionhistory = new HashMap<String, ConditionHistory>();
        this.init();
    }

    private void init() {
        String[] conditionids;
        String[] variablekeys;
        for (String variablename : variablekeys = this.lasttimevariables.keySet().toArray(new String[this.lasttimevariables.size()])) {
            VariableHistory vh = new VariableHistory(variablename);
            vh.addValue(this.lasttimevariables.getProperty(variablename), "initial value");
            this.variableshistory.put(variablename, vh);
        }
        for (String conditionid : conditionids = this.rules.getKnownConditionIds()) {
            Condition currentcondition = RulesEngine.getCondition(conditionid);
            boolean result = this.rules.isConditionTrue(currentcondition);
            ConditionHistory ch = null;
            ch = new ConditionHistory(currentcondition);
            ch.addValue(result, "initial value");
            this.conditionhistory.put(conditionid, ch);
        }
    }

    private void debugVariables(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        this.getChangedVariables(nextpanelmetadata, lastpanelmetadata);
        this.lasttimevariables = (Properties)this.idata.variables.clone();
    }

    private void debugConditions(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        this.conditionhistoryrenderer.clearState();
        this.updateChangedConditions("changed after panel switch from " + lastpanelmetadata.getPanelid() + " to " + nextpanelmetadata.getPanelid());
    }

    private void updateChangedConditions(String comment) {
        String[] conditionids;
        for (String conditionid : conditionids = this.rules.getKnownConditionIds()) {
            Condition currentcondition = RulesEngine.getCondition(conditionid);
            ConditionHistory ch = null;
            if (!this.conditionhistory.containsKey(conditionid)) {
                ch = new ConditionHistory(currentcondition);
                this.conditionhistory.put(conditionid, ch);
            } else {
                ch = this.conditionhistory.get(conditionid);
            }
            ch.addValue(this.rules.isConditionTrue(currentcondition), comment);
        }
        this.conditionhistorymodel.fireTableDataChanged();
    }

    private Properties getChangedVariables(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        Properties currentvariables = (Properties)this.idata.variables.clone();
        Properties changedvariables = new Properties();
        this.variablesrenderer.clearState();
        Enumeration<Object> currentvariableskeys = currentvariables.keys();
        boolean changes = false;
        while (currentvariableskeys.hasMoreElements()) {
            VariableHistory vh;
            String key = (String)currentvariableskeys.nextElement();
            String currentvalue = currentvariables.getProperty(key);
            String oldvalue = this.lasttimevariables.getProperty(key);
            if (oldvalue == null) {
                vh = new VariableHistory(key);
                vh.addValue(currentvalue, "new after panel " + lastpanelmetadata.getPanelid());
                this.variableshistory.put(key, vh);
                changes = true;
                changedvariables.put(key, currentvalue);
                continue;
            }
            if (currentvalue.equals(oldvalue)) continue;
            vh = this.variableshistory.get(key);
            vh.addValue(currentvalue, "changed value after panel " + lastpanelmetadata.getPanelid());
            changes = true;
            changedvariables.put(key, currentvalue);
        }
        if (changes) {
            this.variablesmodel.fireTableDataChanged();
        }
        return changedvariables;
    }

    private void modifyVariableManually(String varnametxt, String varvaluetxt) {
        this.lasttimevariables = (Properties)this.idata.variables.clone();
        VariableHistory vh = this.variableshistory.get(varnametxt);
        if (vh != null) {
            vh.addValue(varvaluetxt, "modified manually");
        }
        this.variablesmodel.fireTableDataChanged();
        this.updateChangedConditions("after manual modification of variable " + varnametxt);
    }

    public JPanel getDebugPanel() {
        JPanel debugpanel = new JPanel();
        debugpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        debugpanel.setLayout(new BorderLayout());
        this.variablesmodel = new VariableHistoryTableModel(this.variableshistory);
        this.variablesrenderer = new VariableHistoryTableCellRenderer(this.variableshistory);
        this.variablestable = new JTable(this.variablesmodel);
        this.variablestable.setDefaultRenderer(VariableHistory.class, this.variablesrenderer);
        this.variablestable.setSelectionMode(0);
        this.variablestable.setRowSelectionAllowed(true);
        JScrollPane scrollpane = new JScrollPane(this.variablestable);
        debugpanel.add((Component)scrollpane, "Center");
        JPanel varchangepanel = new JPanel();
        varchangepanel.setLayout(new BoxLayout(varchangepanel, 2));
        final JTextField varname = new JTextField();
        varchangepanel.add(varname);
        JLabel label = new JLabel("=");
        varchangepanel.add(label);
        final JTextField varvalue = new JTextField();
        varchangepanel.add(varvalue);
        JButton changevarbtn = ButtonFactory.createButton(this.idata.langpack.getString("debug.changevariable"), this.icons.getImageIcon("debug.changevariable"), this.idata.buttonsHColor);
        changevarbtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String varnametxt = varname.getText();
                String varvaluetxt = varvalue.getText();
                if (varnametxt != null && varnametxt.length() > 0 && varvaluetxt != null && varvaluetxt.length() > 0) {
                    Debugger.this.idata.setVariable(varnametxt, varvaluetxt);
                    Debugger.this.modifyVariableManually(varnametxt, varvaluetxt);
                }
            }
        });
        this.variablestable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedrow = Debugger.this.variablestable.getSelectedRow();
                String selectedvariable = (String)Debugger.this.variablesmodel.getValueAt(selectedrow, 0);
                if (e.getClickCount() == 1) {
                    varname.setText(selectedvariable);
                } else {
                    VariableHistory vh = (VariableHistory)Debugger.this.variableshistory.get(selectedvariable);
                    JFrame variabledetails = new JFrame("Details");
                    JTextPane detailspane = new JTextPane();
                    detailspane.setContentType("text/html");
                    detailspane.setText(vh.getValueHistoryDetails());
                    detailspane.setEditable(false);
                    JScrollPane scroller = new JScrollPane(detailspane);
                    Container con = variabledetails.getContentPane();
                    con.setLayout(new BorderLayout());
                    con.add((Component)scroller, "Center");
                    variabledetails.pack();
                    variabledetails.setVisible(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        varchangepanel.add(changevarbtn);
        debugpanel.add((Component)varchangepanel, "South");
        JPanel conditionpanel = new JPanel();
        conditionpanel.setLayout(new BorderLayout());
        this.conditionhistorymodel = new ConditionHistoryTableModel(this.conditionhistory);
        final JTable conditiontable = new JTable(this.conditionhistorymodel);
        this.conditionhistoryrenderer = new ConditionHistoryTableCellRenderer(this.conditionhistory);
        conditiontable.setDefaultRenderer(ConditionHistory.class, this.conditionhistoryrenderer);
        conditiontable.setSelectionMode(0);
        conditiontable.setRowSelectionAllowed(true);
        conditiontable.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedrow = conditiontable.getSelectedRow();
                String selectedcondition = (String)conditiontable.getModel().getValueAt(selectedrow, 0);
                if (e.getClickCount() == 2) {
                    ConditionHistory ch = (ConditionHistory)Debugger.this.conditionhistory.get(selectedcondition);
                    JFrame variabledetails = new JFrame("Details");
                    JTextPane detailspane = new JTextPane();
                    detailspane.setContentType("text/html");
                    detailspane.setText(ch.getConditionHistoryDetails());
                    detailspane.setEditable(false);
                    JScrollPane scroller = new JScrollPane(detailspane);
                    Container con = variabledetails.getContentPane();
                    con.setLayout(new BorderLayout());
                    con.add((Component)scroller, "Center");
                    variabledetails.pack();
                    variabledetails.setVisible(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JScrollPane conditionscroller = new JScrollPane(conditiontable);
        conditionpanel.add((Component)conditionscroller, "Center");
        JTabbedPane tabpane = new JTabbedPane(1);
        tabpane.insertTab("Variable settings", null, debugpanel, "", 0);
        tabpane.insertTab("Condition settings", null, conditionpanel, "", 1);
        JPanel mainpanel = new JPanel();
        mainpanel.setLayout(new BorderLayout());
        mainpanel.add((Component)tabpane, "Center");
        return mainpanel;
    }

    public void switchPanel(Panel nextpanelmetadata, Panel lastpanelmetadata) {
        this.debugVariables(nextpanelmetadata, lastpanelmetadata);
        this.debugConditions(nextpanelmetadata, lastpanelmetadata);
    }

    public void packSelectionChanged(String comment) {
        this.updateChangedConditions(comment);
    }
}

