/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class ConsoleInstaller
extends InstallerBase {
    private AutomatedInstallData installdata = new AutomatedInstallData();
    private boolean result = false;
    private Properties properties;
    private PrintWriter printWriter;
    private ZipOutputStream outJar;

    public ConsoleInstaller(String langcode, String[] args) throws Exception {
        this.cmdLineArgs = args;
        this.loadInstallData(this.installdata);
        this.installdata.localeISO3 = langcode;
        if (this.installdata.localeISO3 == null) {
            this.installdata.localeISO3 = this.getAvailableLangPacks().get(0);
        }
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        this.installdata.langpack = new LocaleDatabase(in);
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.checkJavaVersion();
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        this.refreshDynamicVariables(new VariableSubstitutor(this.installdata.getVariables()), this.installdata);
        this.addCustomLangpack(this.installdata);
    }

    private void checkJavaVersion() throws Exception {
        String version = System.getProperty("java.version");
        String required = this.installdata.info.getJavaVersion();
        Debug.log("checkJavaVersion(installed:" + version + ", required:" + required + ")");
        if (required != null && version.compareTo(required) < 0) {
            String msg = this.getVersionNotAvailable(version, required);
            System.out.println(msg);
            System.exit(1);
        }
    }

    protected void iterateAndPerformAction(String strAction) throws Exception {
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        Debug.log("[ Starting console installation ] " + strAction);
        try {
            this.result = true;
            Iterator<Panel> panelsIterator = this.installdata.panelsOrder.iterator();
            this.installdata.curPanelNumber = -1;
            VariableSubstitutor substitutor = new VariableSubstitutor(this.installdata.getVariables());
            while (panelsIterator.hasNext()) {
                Panel p = panelsIterator.next();
                ++this.installdata.curPanelNumber;
                String praefix = "com.izforge.izpack.panels.";
                if (p.className.compareTo(".") > -1) {
                    praefix = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(p.osConstraints)) continue;
                String panelClassName = p.className;
                String consoleHelperClassName = praefix + panelClassName + "ConsoleHelper";
                Class<?> consoleHelperClass = null;
                Debug.log("ConsoleHelper:" + consoleHelperClassName);
                try {
                    consoleHelperClass = Class.forName(consoleHelperClassName);
                }
                catch (ClassNotFoundException e) {
                    Debug.log("ClassNotFoundException-skip :" + consoleHelperClassName);
                    continue;
                }
                PanelConsole consoleHelperInstance = null;
                if (consoleHelperClass != null) {
                    try {
                        this.refreshDynamicVariables(substitutor, this.installdata);
                        Debug.log("Precontruct action stage ...");
                        List<String> preConstgructionActions = p.getPreConstructionActions();
                        if (preConstgructionActions != null) {
                            for (int actionIndex = 0; actionIndex < preConstgructionActions.size(); ++actionIndex) {
                                PanelAction action = PanelActionFactory.createPanelAction(preConstgructionActions.get(actionIndex));
                                action.initialize(p.getPanelActionConfiguration(preConstgructionActions.get(actionIndex)));
                                action.executeAction(AutomatedInstallData.getInstance(), null);
                            }
                        }
                        Debug.log("Precontruct action stage done !");
                        Debug.log("Instantiate :" + consoleHelperClassName);
                        consoleHelperInstance = (PanelConsole)consoleHelperClass.newInstance();
                    }
                    catch (Exception e) {
                        Debug.log("ERROR: no default constructor for " + consoleHelperClassName + ", skipping...");
                        continue;
                    }
                }
                if (consoleHelperInstance == null) continue;
                try {
                    consoleHelperInstance.setAutomatedInstallData(this.installdata);
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " entered.");
                    boolean bActionResult = true;
                    boolean bIsConditionFulfilled = true;
                    String strCondition = p.getCondition();
                    if (strCondition != null) {
                        bIsConditionFulfilled = this.installdata.getRules().isConditionTrue(strCondition);
                    }
                    if (bIsConditionFulfilled) {
                        List<String> postValidateActions;
                        List<String> preValidateActions;
                        List<String> preActivateActions;
                        String dataValidator = p.getValidator();
                        if (dataValidator != null) {
                            consoleHelperInstance.setValidationService(DataValidatorFactory.createDataValidator(dataValidator));
                        }
                        if ((preActivateActions = p.getPreActivationActions()) != null) {
                            for (int actionIndex = 0; actionIndex < preActivateActions.size(); ++actionIndex) {
                                String panelActionClass = preActivateActions.get(actionIndex);
                                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                                consoleHelperInstance.addPreActivationAction(action);
                            }
                        }
                        if ((preValidateActions = p.getPreValidationActions()) != null) {
                            for (int actionIndex = 0; actionIndex < preValidateActions.size(); ++actionIndex) {
                                String panelActionClass = preValidateActions.get(actionIndex);
                                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                                consoleHelperInstance.addPreValidationAction(action);
                            }
                        }
                        if ((postValidateActions = p.getPostValidationActions()) != null) {
                            for (int actionIndex = 0; actionIndex < postValidateActions.size(); ++actionIndex) {
                                String panelActionClass = postValidateActions.get(actionIndex);
                                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                                action.initialize(p.getPanelActionConfiguration(panelActionClass));
                                consoleHelperInstance.addPostValidationAction(action);
                            }
                        }
                        if (strAction.equals("doInstall") && bIsConditionFulfilled) {
                            consoleHelperInstance.executePreActivationActions();
                            boolean bvalidated = false;
                            do {
                                if (!(bActionResult = consoleHelperInstance.runConsole(this.installdata))) {
                                    this.result = false;
                                    return;
                                }
                                consoleHelperInstance.executePreValidationActions();
                                bvalidated = this.validatePanel(p, consoleHelperInstance);
                                if (!bvalidated) continue;
                                consoleHelperInstance.executePostValidationActions();
                            } while (!bvalidated);
                        } else if (strAction.equals("doGeneratePropertiesFile")) {
                            bActionResult = consoleHelperInstance.runGeneratePropertiesFile(this.installdata, this.printWriter);
                        } else if (strAction.equals("doInstallFromPropertiesFile") && bIsConditionFulfilled) {
                            consoleHelperInstance.executePreActivationActions();
                            boolean bvalidated = false;
                            do {
                                if (!(bActionResult = consoleHelperInstance.runConsoleFromPropertiesFile(this.installdata, this.properties))) {
                                    this.result = false;
                                    return;
                                }
                                consoleHelperInstance.executePreValidationActions();
                                bvalidated = this.validatePanel(p, consoleHelperInstance);
                                if (!bvalidated) continue;
                                consoleHelperInstance.executePostValidationActions();
                            } while (!bvalidated);
                        }
                    }
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " successfully done.");
                }
                catch (Exception e) {
                    Debug.log("ERROR: console installation failed for panel " + panelClassName);
                    e.printStackTrace();
                    this.result = false;
                }
            }
            this.outJar = this.installdata.uninstallOutJar;
            this.writeUninstallData();
            if (this.result) {
                System.out.println("[ Console installation done ]");
            } else {
                System.out.println("[ Console installation FAILED! ]");
            }
        }
        catch (Exception e) {
            this.result = false;
            System.err.println(e.toString());
            e.printStackTrace();
            System.out.println("[ Console installation FAILED! ]");
        }
    }

    private void writeUninstallData() {
        String logfile = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = this.installdata.info.getUninstallerPath() + "/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, new VariableSubstitutor(this.installdata.getVariables())))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        try {
            String condition = this.installdata.getVariable("UNINSTALLER_CONDITION");
            if (condition != null && !RulesEngine.getCondition(condition).isTrue()) {
                return;
            }
            UninstallData udata = UninstallData.getInstance();
            List<String> files = udata.getUninstalableFilesList();
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            outJar.putNextEntry(new ZipEntry("install.log"));
            BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(this.installdata.getInstallPath());
            logWriter.newLine();
            Iterator<Object> iter = files.iterator();
            if (extLogWriter != null) {
                while (iter.hasNext()) {
                    String txt = iter.next();
                    logWriter.write(txt);
                    extLogWriter.write(txt);
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                    extLogWriter.newLine();
                }
                logWriter.flush();
                extLogWriter.flush();
                extLogWriter.close();
            } else {
                while (iter.hasNext()) {
                    logWriter.write(iter.next());
                    if (!iter.hasNext()) continue;
                    logWriter.newLine();
                }
                logWriter.flush();
            }
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("jarlocation.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(udata.getUninstallerJarFilename());
            logWriter.newLine();
            logWriter.write(udata.getUninstallerPath());
            logWriter.flush();
            outJar.closeEntry();
            outJar.putNextEntry(new ZipEntry("executables"));
            ObjectOutputStream execStream = new ObjectOutputStream(outJar);
            iter = udata.getExecutablesList().iterator();
            execStream.writeInt(udata.getExecutablesList().size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
            execStream.flush();
            outJar.closeEntry();
            Map<String, Object> additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator<String> keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            ArrayList<String> unInstallScripts = udata.getUninstallScripts();
            Iterator<String> unInstallIter = unInstallScripts.iterator();
            int idx = 0;
            while (unInstallIter.hasNext()) {
                outJar.putNextEntry(new ZipEntry("rootscript" + Integer.toString(idx)));
                ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
                String unInstallScript = unInstallIter.next();
                rootStream.writeUTF(unInstallScript);
                rootStream.flush();
                outJar.closeEntry();
                ++idx;
            }
            outJar.flush();
            outJar.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    protected void doInstall() throws Exception {
        try {
            this.iterateAndPerformAction("doInstall");
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doGeneratePropertiesFile(String strFile) throws Exception {
        try {
            this.printWriter = new PrintWriter(strFile);
            this.iterateAndPerformAction("doGeneratePropertiesFile");
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.printWriter.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doInstallFromPropertiesFile(String strFile) throws Exception {
        FileInputStream in = new FileInputStream(strFile);
        try {
            this.properties = new Properties();
            this.properties.load(in);
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                in.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        in.close();
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private boolean validatePanel(Panel p, PanelConsole consoleHelperInstance) throws InstallerException {
        DataValidator validator;
        DataValidator.Status validationResult;
        String dataValidator = p.getValidator();
        if (dataValidator != null && (validationResult = (validator = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.installdata)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING) {
                if (consoleHelperInstance instanceof PanelConsoleHelper) {
                    System.out.println(this.installdata.langpack.getString(validator.getWarningMessageId()));
                    switch (((PanelConsoleHelper)((Object)consoleHelperInstance)).askQuestion(this.installdata, this.installdata.langpack.getString("consolehelper.askyesno"), 2)) {
                        case 1: {
                            return true;
                        }
                        case 3: {
                            System.exit(0);
                        }
                    }
                    return false;
                }
                System.out.println(this.installdata.langpack.getString(validator.getErrorMessageId()));
                System.out.println("Validation failed, please verify your input");
                return false;
            }
            System.out.println(this.installdata.langpack.getString(validator.getErrorMessageId()));
            System.out.println("Validation failed, please verify your input");
            return false;
        }
        return true;
    }

    public void run(int type, String path) throws Exception {
        switch (type) {
            case 1: {
                this.doGeneratePropertiesFile(path);
                break;
            }
            case 2: {
                this.doInstallFromPropertiesFile(path);
                break;
            }
            default: {
                this.doInstall();
            }
        }
    }
}

