/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingConstants;

public class LabelFactory
implements SwingConstants {
    private static boolean useLabelIcons = true;
    private static float labelFontSizeVal = 1.0f;
    private static Font customLabelFontObj = null;

    public static boolean isUseLabelIcons() {
        return useLabelIcons;
    }

    public static void setUseLabelIcons(boolean b) {
        useLabelIcons = b;
    }

    public static float getLabelFontSize() {
        return labelFontSizeVal;
    }

    public static void setLabelFontSize(float val) {
        if (val > 0.0f && val <= 5.0f && val != labelFontSizeVal) {
            labelFontSizeVal = val;
            Font fontObj = new JLabel().getFont();
            customLabelFontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
    }

    public static JLabel create(Icon image) {
        return LabelFactory.create(image, 0);
    }

    public static JLabel create(Icon image, int horizontalAlignment) {
        return LabelFactory.create(null, image, horizontalAlignment);
    }

    public static JLabel create(String text) {
        return LabelFactory.create(text, 0);
    }

    public static JLabel create(String text, boolean isFullLine) {
        return LabelFactory.create(text, 0, isFullLine);
    }

    public static JLabel create(String text, int horizontalAlignment) {
        return LabelFactory.create(text, null, horizontalAlignment);
    }

    public static JLabel create(String text, int horizontalAlignment, boolean isFullLine) {
        return LabelFactory.create(text, null, horizontalAlignment, isFullLine);
    }

    public static JLabel create(String text, Icon image, int horizontalAlignment) {
        return LabelFactory.create(text, image, horizontalAlignment, false);
    }

    public static JLabel create(String text, Icon image, int horizontalAlignment, boolean isFullLine) {
        JLabel retval = null;
        retval = image != null && LabelFactory.isUseLabelIcons() ? (isFullLine ? new FullLineLabel(image) : new JLabel(image)) : (isFullLine ? new FullLineLabel() : new JLabel());
        if (text != null) {
            retval.setText(text);
        }
        if (customLabelFontObj != null) {
            retval.setFont(customLabelFontObj);
        }
        retval.setHorizontalAlignment(horizontalAlignment);
        return retval;
    }

    public static class FullLineLabel
    extends JLabel {
        private static final long serialVersionUID = 2918265795390777147L;

        public FullLineLabel(Icon image) {
            super(image);
        }

        public FullLineLabel() {
        }
    }
}

