/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.coi.tools.os.win.RegDataContainer;
import com.coi.tools.os.win.RegistryLogItem;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.RegistryUninstallerListener;
import com.izforge.izpack.util.Platforms;
import com.sage.izpack.AdxCompUninstallerListener;
import com.sage.izpack.InstallDataSage;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ResourcesHelper;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistryUninstallerNewListener
extends RegistryUninstallerListener {
    private static final Logger logger = Logger.getLogger(RegistryUninstallerNewListener.class.getName());
    private static final String LogPrefix = "RegistryUninstallerNewListener - ";
    private RegistryDefaultHandler myhandler;
    private final Prompt prompt;
    private final Resources resources;
    private final Messages messages;
    private AdxCompUninstallerListener adxCompUninstallerListener = null;

    public RegistryUninstallerNewListener(RegistryDefaultHandler handler, Resources resources, Messages messages, Prompt prompt) {
        super(handler, resources, messages);
        this.myhandler = handler;
        this.resources = resources;
        this.messages = messages;
        this.prompt = prompt;
    }

    @Override
    public void afterDelete(File file) {
        this.LogDebug("afterDelete. File : " + file);
        super.afterDelete(file);
    }

    private void LogDebug(String message) {
        logger.log(Level.FINE, LogPrefix + message);
        System.out.println(LogPrefix + message);
    }

    @Override
    public void beforeDelete(List<File> files, ProgressListener listener) {
        this.LogDebug("beforeDelete.");
        try {
            super.beforeDelete(files, listener);
        }
        catch (WrappedNativeLibException exception) {
            this.emitError(this.getString("privilegesIssue", "It looks that you don't have enough rights. You need to launch the 'Uninstaller' program from 'Add or remove programs' to get all privileges. "), exception);
            throw exception;
        }
        catch (Exception exception) {
            throw exception;
        }
        this.LogDebug("beforeDelete.  deleteRegistry");
        this.deleteRegistry();
    }

    @Override
    public void afterDelete(List<File> files, ProgressListener listener) {
        this.LogDebug("afterDelete.  ");
        super.afterDelete(files, listener);
        this.deleteInstallationInformation();
    }

    private void deleteInstallationInformation() {
        AdxCompUninstallerListener lst = this.getAdxCompUninstallerListener();
        String installPath = lst.getInstallPath();
        File installationinformation = new File(installPath + File.separator + ".installationinformation");
        if (installationinformation.exists()) {
            installationinformation.delete();
        }
    }

    private void deleteRegistry() {
        RegistryHandler myHandlerInstance = this.myhandler.getInstance();
        String unInstallName = myHandlerInstance.getUninstallName();
        String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + unInstallName;
        if (unInstallName == null) {
            this.LogDebug("Error in deleteRegistry: getUninstallName() is empty");
            this.LogDebug("Trying to read InstallPath from install.log");
            AdxCompUninstallerListener lst = this.getAdxCompUninstallerListener();
            String installPath = lst.getInstallPath();
            this.LogDebug("install.log read. installPath:" + installPath);
            if (installPath == null) {
                this.LogDebug("Warning: Cannot read installPath from install.log read.");
                return;
            }
            InstallDataSage data = new InstallDataSage(new DefaultVariables(), Platforms.WINDOWS);
            data.setInstallPath(installPath);
            this.LogDebug("Trying to read " + installPath + "\\.installationinformation");
            InstallationInformationHelper.readInformation(data);
            unInstallName = data.getVariable("UNINSTALL_NAME");
            if (unInstallName == null) {
                unInstallName = data.getVariable("APP_NAME");
            }
            this.LogDebug("unInstallName read from .installationinformation - APP_NAME:" + unInstallName);
            if (StringUtil.isNullOrBlank(unInstallName)) {
                unInstallName = this.getAppNameFromRegistryEntries();
                this.LogDebug("unInstallName read from 'registryEntries' file - APP_NAME:" + unInstallName);
            }
            if (unInstallName == null) {
                this.LogDebug("Cannot determine UninstallName. Exit");
                return;
            }
            keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + unInstallName;
        }
        this.LogDebug("UninstallName Registry key " + keyName);
        try {
            myHandlerInstance.setRoot(-2147483646);
            if (myHandlerInstance.keyExist(keyName)) {
                myHandlerInstance.deleteKey(keyName);
                this.LogDebug("Registry key '" + keyName + "' deleted");
            } else {
                this.LogDebug("Registry key '" + keyName + "' doesn't exist or not found.");
            }
        }
        catch (NativeLibException e) {
            e.printStackTrace();
            this.LogDebug("Error, registry key '" + keyName + "' NOT deleted");
        }
    }

    private String getAppNameFromRegistryEntries() {
        String result = null;
        List<RegistryLogItem> registryEntries = this.readRegistryEntries();
        if (registryEntries != null) {
            for (RegistryLogItem registryEntry : registryEntries) {
                String registryName = registryEntry.getValueName();
                if (!StringUtil.isNullOrBlank(registryName) && registryName.equalsIgnoreCase("DisplayName")) {
                    result = registryEntry.getKey();
                    if (registryEntry.getNewValue() instanceof RegDataContainer) {
                        RegDataContainer dataContainer = registryEntry.getNewValue();
                        result = dataContainer.getStringData();
                        break;
                    }
                    if (!StringUtil.isNullOrBlank(result) && result.lastIndexOf(92) > 0) {
                        result = result.substring(result.lastIndexOf(92));
                    }
                }
                if (!StringUtil.isNullOrBlank(registryName) || StringUtil.isNullOrBlank(result = registryEntry.getKey()) || result.lastIndexOf(92) <= 0) continue;
                result = result.substring(result.lastIndexOf(92));
            }
        }
        return result;
    }

    private List<RegistryLogItem> readRegistryEntries() {
        List logEntries = null;
        try {
            this.LogDebug("Read registryEntries");
            InputStream in = this.resources.getInputStream("registryEntries");
            ObjectInputStream objIn = new ObjectInputStream(in);
            logEntries = (List)objIn.readObject();
            for (Object logEntry : logEntries) {
                if (logEntry instanceof RegistryLogItem) {
                    RegistryLogItem item = (RegistryLogItem)logEntry;
                    this.LogDebug("RegistryLogItem: " + item.getKey() + " - " + item.getValueName() + " - " + item.getNewValue());
                    if (!(item.getNewValue() instanceof RegDataContainer)) continue;
                    RegDataContainer dataContainer = item.getNewValue();
                    this.LogDebug("RegistryLogItem getStringData: " + dataContainer.getStringData());
                    continue;
                }
                this.LogDebug("RegistryLogItem: " + logEntry);
            }
            objIn.close();
            in.close();
        }
        catch (ResourceNotFoundException ignore) {
            this.LogDebug("readRegistryEntries: " + ignore.getMessage());
        }
        catch (Exception exception) {
            this.LogDebug("Exception in readRegistryEntries: " + exception.getMessage());
        }
        return logEntries;
    }

    private AdxCompUninstallerListener getAdxCompUninstallerListener() {
        if (this.adxCompUninstallerListener == null) {
            this.adxCompUninstallerListener = new AdxCompUninstallerListener(this.myhandler, this.resources, this.messages, this.prompt);
        }
        return this.adxCompUninstallerListener;
    }

    private String getString(String resourceId, String defaultTranslation) {
        ResourcesHelper helper = new ResourcesHelper(null, this.resources);
        helper.mergeCustomMessages(this.messages);
        String result = helper.getCustomString(resourceId);
        if (result == null) {
            result = defaultTranslation;
        }
        return result;
    }

    protected void emitError(String message, Exception exceptionMesg) {
        PromptUIHandler UIHandler = new PromptUIHandler(this.prompt);
        if (this.prompt != null && UIHandler != null) {
            UIHandler.emitError("Error", message);
        } else {
            System.err.println(message);
        }
        if (exceptionMesg != null) {
            System.err.println(exceptionMesg.getMessage());
        }
    }
}

