/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.coi.tools.os.win.RegDataContainer;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.RegistryInstallerListener;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.util.Housekeeper;
import com.sage.izpack.InstallationInformationHelper;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistryInstallerNewListener
extends RegistryInstallerListener {
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String UNINSTALL_STRING = "UninstallString";
    private static final Logger logger = Logger.getLogger(RegistryInstallerNewListener.class.getName());
    private final RegistryDefaultHandler myhandler;
    private static final String LogPrefix = "RegistryInstallerNewListener - ";

    public RegistryInstallerNewListener(IUnpacker unpacker, VariableSubstitutor substitutor, InstallData installData, UninstallData uninstallData, Resources resources, RulesEngine rules, Housekeeper housekeeper, RegistryDefaultHandler handler) {
        super(unpacker, substitutor, installData, uninstallData, resources, rules, housekeeper, handler);
        this.myhandler = handler;
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        logger.log(Level.FINE, "RegistryInstallerNewListener - afterPacks start");
        super.afterPacks(packs, listener);
        this.updateRegistry();
        if (!InstallationInformationHelper.isReadInformation(this.getInstallData()) && !this.getInstallData().getInfo().isWriteInstallationInformation()) {
            this.deleteInstallInformation();
        }
    }

    private void deleteInstallInformation() {
        String installDir;
        String installInformationFileName;
        File installationInfo;
        InstallData installData = this.getInstallData();
        if (!installData.getInfo().isWriteInstallationInformation() && !installData.getInfo().isReadInstallationInformation() && (installationInfo = new File(installInformationFileName = (installDir = installData.getInstallPath()) + File.separator + ".installationinformation")).exists()) {
            installationInfo.delete();
            logger.log(Level.FINE, "RegistryInstallerNewListener - File " + installInformationFileName + " deleted.");
        }
    }

    @Override
    protected String getUninstallName() {
        Variables variables = this.getInstallData().getVariables();
        String result = variables.get("APP_NAME");
        logger.log(Level.FINE, "RegistryInstallerNewListener - getUninstallName():" + result + "");
        return result;
    }

    private void updateRegistry() {
        String appName;
        Variables variables = this.getInstallData().getVariables();
        String version = variables.get("app-version");
        if (version == null) {
            version = variables.get("APP_VER");
        }
        if ((appName = variables.get("UNINSTALL_NAME")) == null || appName.isBlank()) {
            appName = variables.get("APP_NAME");
        }
        String uninstallerPath = this.getInstallData().getInstallPath() + File.separator + "Uninstaller" + File.separator + "uninstaller.jar";
        String uninstallString = "\"" + this.getInstallData().getVariable(JAVA_HOME) + "\\bin\\javaw.exe\" -jar \"" + uninstallerPath + "\"";
        String publisher = variables.get("publisher");
        String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + appName;
        RegistryHandler myHandlerInstance = this.myhandler.getInstance();
        try {
            myHandlerInstance.setRoot(-2147483646);
            myHandlerInstance.setUninstallName("");
            myHandlerInstance.setUninstallName(appName);
            if (myHandlerInstance.keyExist(keyName)) {
                if (version != null) {
                    this.updateEntry(myHandlerInstance, keyName, "DisplayVersion", version);
                }
                if (publisher != null) {
                    this.updateEntry(myHandlerInstance, keyName, "Publisher", publisher);
                }
                if (uninstallString != null) {
                    this.updateEntry(myHandlerInstance, keyName, UNINSTALL_STRING, uninstallString);
                }
                this.updateUninstallString(myHandlerInstance, keyName);
            }
        }
        catch (NativeLibException e) {
            logger.log(Level.WARNING, "RegistryInstallerNewListener - Error: " + e.getMessage() + "");
            e.printStackTrace();
        }
    }

    private void updateUninstallString(RegistryHandler myHandlerInstance, String keyName) throws NativeLibException {
        String javaHome = System.getenv(JAVA_HOME);
        if (javaHome == null || javaHome.isBlank()) {
            logger.log(Level.FINE, "RegistryInstallerNewListener - updateUninstallString: %JAVA_HOME% is not set, exiting.");
            return;
        }
        javaHome = javaHome.replaceAll("\\\\", "\\\\");
        RegDataContainer uninstallString = myHandlerInstance.getValue(keyName, UNINSTALL_STRING);
        if (uninstallString == null || uninstallString.getStringData() == null || uninstallString.getStringData().isBlank()) {
            logger.log(Level.FINE, "RegistryInstallerNewListener - updateUninstallString: UninstallString is not set, exiting.");
            return;
        }
        String uninstallStringValue = uninstallString.getStringData();
        if (uninstallStringValue.contains(javaHome) && javaHome.equals(uninstallStringValue)) {
            this.updateEntry(myHandlerInstance, keyName, UNINSTALL_STRING, uninstallStringValue.replaceAll(javaHome, "%JAVA_HOME%"));
            logger.log(Level.FINE, "RegistryInstallerNewListener - updateUninstallString: done.");
        } else {
            logger.log(Level.FINE, "RegistryInstallerNewListener - updateUninstallString: \"main\" java was not used for this installation, exiting.");
        }
    }

    private void updateEntry(RegistryHandler myHandlerInstance, String keyName, String entryName, String entryValue) throws NativeLibException {
        if (!myHandlerInstance.valueExist(keyName, entryName)) {
            myHandlerInstance.setValue(keyName, entryName, entryValue);
        } else {
            String stringVal;
            RegDataContainer contVal = myHandlerInstance.getValue(keyName, entryName);
            if (contVal != null && (stringVal = contVal.getStringData()) != null && entryValue != null && !stringVal.equals(entryValue)) {
                myHandlerInstance.setValue(keyName, entryName, entryValue);
            }
        }
    }
}

