/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.ServiceWinHelper;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class PreValidateXtremServiceConfiguration
implements PanelAction {
    private static final Logger logger = Logger.getLogger(PreValidateXtremServiceConfiguration.class.getName());
    private static final String prefixLabel = "PreValidateXtremServiceConfiguration - ";
    private String serviceName;

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler uiHandler) {
        logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - executeAction. uiHandler=" + uiHandler);
        this.InitServiceUser(installData, this.serviceName);
        this.ReadYml(installData);
        logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - executeAction end");
    }

    private void InitServiceUser(InstallData installData, String serviceName) {
        String userName;
        logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - InitServiceUser");
        boolean updateMode = ModifyInstallationUtil.get(installData);
        if (updateMode && !StringUtil.isNullOrBlank(userName = ServiceWinHelper.getServiceUser(serviceName))) {
            installData.setVariable("winservice.username", userName);
            logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - ServiceName: " + serviceName + " UserName found: " + userName);
        }
        logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - InitServiceUser end");
    }

    private void ReadYml(InstallData installData) {
        Yaml yaml = new Yaml();
        try {
            String configDir = installData.getInstallPath();
            String syracuseClientId = installData.getVariable("syracuse.clientid");
            String syracuseSecret = installData.getVariable("syracuse.secret");
            logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - InstallPath: " + configDir);
            logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - Original syracuse.clientid: " + syracuseClientId);
            logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - Original syracuse.secret: " + syracuseSecret);
            String xstremConfigYml = configDir + File.separator + "xtrem-config.yml";
            File xStremConfigFile = new File(xstremConfigYml);
            if (xStremConfigFile.exists()) {
                FileInputStream inputStream = new FileInputStream(xStremConfigFile);
                Map data = (Map)yaml.load((InputStream)inputStream);
                Map server = (Map)data.get("server");
                if (server != null) {
                    logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - Port: " + server.get("port"));
                    if (server.get("port") != null) {
                        installData.setVariable("x3services.service.port", server.get("port").toString());
                    }
                    if (server.get("ssl") != null) {
                        Map ssl = (Map)server.get("ssl");
                        System.out.println("SSL Cert: " + ssl.get("cert"));
                    }
                }
            } else {
                logger.log(Level.FINE, prefixLabel + xstremConfigYml + " doesn't exist");
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, prefixLabel + e);
            e.printStackTrace();
        }
    }

    @Override
    public void initialize(PanelActionConfiguration actionConfiguration) {
        String serviceName;
        logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - initialize.");
        this.serviceName = serviceName = actionConfiguration.getProperty("servicename");
        logger.log(Level.FINE, "PreValidateXtremServiceConfiguration - initialize. ServiceName: " + serviceName);
    }
}

