/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.sage.izpack.CLoggerUtils;
import com.sage.izpack.CTextLineUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CReport {
    public static final char CHAR_NEWLINE = '\n';
    public static final char CHAR_PIPE = '|';
    public static final char CHAR_STEP = '+';
    public static final char CHAR_TITRE = '#';
    public static final boolean CONSOLE_LOG_OFF = false;
    public static final boolean CONSOLE_LOG_ON = true;
    private static final String EMPTY = "";
    private static final String EOF = CTextLineUtils.toInsecable("# eof");
    private static final String FOLLOWING = ">>\u00a0";
    private static final String PATTERN_ISO_8601 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String REGEX_SPLIT_LINES = "\n";
    private static final String REPORT_NAME = "report";
    private static final int REPORT_WITDH = 160;
    private static final SimpleDateFormat sIso8601Formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final String SUFFIX_EMPTY = "";
    public static final String SUFFIX_ON_ERROR = "_onError";
    private final StringBuilder pBuffer = new StringBuilder();
    private boolean pConsoleLogOn = false;
    private final String pCreatedAt;
    private final String pName;
    private int pStepIdx = 0;
    private int pTitleIdx = 0;
    private final int pWidth;

    public CReport(String aName) {
        this(aName, 160);
    }

    public CReport(String aName, int aWidth) {
        this.pName = this.nameValidation(aName);
        this.pWidth = this.widthValidation(aWidth);
        this.pCreatedAt = this.getNowForName();
    }

    public String append(String aText) {
        String wNow = this.getNowIso8601();
        block0: for (String wLine : aText.split(REGEX_SPLIT_LINES)) {
            String wRest = null;
            while (true) {
                if (wLine.length() > this.getWidth()) {
                    wRest = FOLLOWING + wLine.substring(this.getWidth());
                    wLine = wLine.substring(0, this.getWidth());
                }
                this.pBuffer.append('\n');
                this.pBuffer.append(wNow);
                this.pBuffer.append('|');
                this.pBuffer.append(wLine);
                if (this.pConsoleLogOn) {
                    this.consoleLog(wLine);
                }
                if (wRest == null) continue block0;
                wLine = wRest;
                wRest = null;
            }
        }
        return aText;
    }

    public String append(String aFormat, Object ... aArgs) {
        return this.append(String.format(aFormat, aArgs));
    }

    private String appendBanner(EKindOfBanner aKindOfBanner, char aBannerChar, String aFormat, Object ... aArgs) {
        String wTitle = String.format(aFormat, aArgs);
        if (EKindOfBanner.BANNER_STEP == aKindOfBanner) {
            wTitle = String.format("Step  [%2d] : %s", this.pStepIdx, wTitle);
        } else if (EKindOfBanner.BANNER_TITLE == aKindOfBanner) {
            wTitle = String.format("Title [%2d] : %s", this.pTitleIdx, wTitle);
        }
        String wLineFull = CTextLineUtils.generateLineFull(aBannerChar, this.getWidth());
        this.appendEmpty();
        this.append(wLineFull);
        this.append(CTextLineUtils.generateLineBeginEnd(aBannerChar, this.getWidth(), wTitle));
        this.append(wLineFull);
        this.appendEmpty();
        return wTitle;
    }

    public String appendEmpty() {
        return this.append("");
    }

    public String appendEof() {
        return this.append('\n' + EOF);
    }

    public String appendError(String aText) {
        return this.append("\nERROR  : " + aText);
    }

    public String appendError(String aFormat, Object ... aArgs) {
        return this.appendError(String.format(aFormat, aArgs));
    }

    public String appendError(Throwable e) {
        return this.appendError(CLoggerUtils.dumpStackTrace(e));
    }

    public String appendLineFull(char aChar) {
        return this.appendLineFull(aChar, this.getWidth(), null);
    }

    public String appendLineFull(char aChar, int aWidth, String aText) {
        return this.append(CTextLineUtils.generateLineFull(aChar, aWidth, aText));
    }

    public String appendLineFull(char aChar, String aText) {
        return this.appendLineFull(aChar, this.getWidth(), aText);
    }

    public int appendNumberedLines(String[] aLines) {
        int wIdx = 0;
        for (String wScriptLine : aLines) {
            this.append("(%3d) %s", ++wIdx, wScriptLine);
        }
        return wIdx;
    }

    public String appendOutput(String aOutPut) {
        this.appendLineFull('-', "Output begin");
        int wNbAppentLines = this.appendNumberedLines(aOutPut.split(REGEX_SPLIT_LINES));
        this.appendLineFull('-', "Output end");
        return String.format(" [%d] output lines appent", wNbAppentLines);
    }

    public String appendScript(String aScript) {
        this.appendLineFull('.', "Script begin");
        int wNbAppentLines = this.appendNumberedLines(aScript.split(REGEX_SPLIT_LINES));
        this.appendLineFull('.', "Script end");
        return String.format(" [%d] script lines appent", wNbAppentLines);
    }

    public String appendStep(String aFormat, Object ... aArgs) {
        ++this.pStepIdx;
        return this.appendBanner(EKindOfBanner.BANNER_STEP, '+', aFormat, aArgs);
    }

    public String appendSuccess(String aText) {
        return this.append("\nSUCCESS: " + aText);
    }

    public String appendSuccess(String aFormat, Object ... aArgs) {
        return this.appendSuccess(String.format(aFormat, aArgs));
    }

    public String appendTitle(String aFormat, Object ... aArgs) {
        ++this.pTitleIdx;
        return this.appendBanner(EKindOfBanner.BANNER_TITLE, '#', aFormat, aArgs);
    }

    private void consoleLog(String aLogLine) {
        System.out.print(aLogLine);
    }

    public String getFileName() {
        return this.getFileName("");
    }

    public String getFileName(String aSuffix) {
        return String.format("%s_%s%s.txt", this.pCreatedAt, this.getName(), aSuffix);
    }

    public String[] getLines() {
        return this.toString().split(REGEX_SPLIT_LINES);
    }

    public String getName() {
        return this.pName;
    }

    private String getNowForName() {
        return this.getNowIso8601().replace(' ', '_');
    }

    private String getNowIso8601() {
        return sIso8601Formatter.format(new Date(System.currentTimeMillis()));
    }

    public int getWidth() {
        return this.pWidth;
    }

    public boolean isEmpty() {
        return this.pBuffer.length() == 0;
    }

    private String nameValidation(String aName) {
        return aName == null || aName.isEmpty() ? REPORT_NAME : aName;
    }

    public void setConsoleLogOn(boolean aConsoleLogOn) {
        this.pConsoleLogOn = aConsoleLogOn;
    }

    public String toString() {
        return this.pBuffer.toString();
    }

    public String toStringWithoutNow() {
        String wPayload = this.toString();
        if (wPayload.charAt(0) == '\n') {
            wPayload = wPayload.substring(1);
        }
        int wBeginLinePos = wPayload.indexOf(124) + 1;
        StringBuilder wSB = new StringBuilder();
        for (String wLine : wPayload.split(REGEX_SPLIT_LINES)) {
            String wKeptPart = wLine.substring(wBeginLinePos);
            wSB.append('\n').append(wKeptPart);
        }
        return wSB.toString();
    }

    private int widthValidation(int aWidth) {
        return aWidth < 80 || aWidth > 512 ? 160 : aWidth;
    }

    public static enum EKindOfBanner {
        BANNER_STEP,
        BANNER_TITLE;

    }
}

