/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import com.izforge.izpack.util.TargetPlatformFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTargetPlatformFactory
implements TargetPlatformFactory {
    private final ObjectFactory factory;
    private final Platforms platforms;
    private final Platform platform;
    private Map<String, Implementations> implementations = new HashMap<String, Implementations>();
    private static final Logger logger = Logger.getLogger(DefaultTargetPlatformFactory.class.getName());
    private static final String RESOURCE_PATH = "com/izforge/izpack/util/TargetPlatformFactory.properties";

    public DefaultTargetPlatformFactory(ObjectFactory factory, Platform platform, Platforms platforms) {
        this.factory = factory;
        this.platform = platform;
        this.platforms = platforms;
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(RESOURCE_PATH);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    this.add(url);
                }
                catch (IOException exception) {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
            }
        }
        catch (IOException exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    @Override
    public <T> T create(Class<T> clazz) throws Exception {
        return this.create(clazz, this.platform);
    }

    @Override
    public <T> T create(Class<T> type, Platform platform) throws Exception {
        Class<T> impl = this.getImplementation(type, platform);
        return this.factory.create(impl, new Object[0]);
    }

    protected <T> Class<T> getImplementation(Class<T> type, Platform platform) throws ClassNotFoundException {
        String implName;
        Implementations impls = this.getImplementations(type);
        if (impls == null) {
            throw new IllegalArgumentException("No implementations registered for class=" + type.getName());
        }
        Platform match = null;
        Platform fallback = null;
        for (Platform p : impls.getPlatforms()) {
            if (p.equals(platform)) {
                match = p;
                break;
            }
            if (!platform.isA(p) || fallback != null && !this.moreSpecific(platform, fallback, p)) continue;
            fallback = p;
        }
        if (match == null && fallback != null) {
            match = fallback;
        }
        String string = implName = match != null ? impls.getImplementation(match) : impls.getDefault();
        if (implName == null) {
            throw new IllegalStateException("No implementation registered for class=" + type.getName() + " and platform=" + platform);
        }
        Class<?> impl = Class.forName(implName);
        if (!type.isAssignableFrom(impl)) {
            throw new IllegalStateException(impl.getName() + " does not extend " + type.getName());
        }
        return impl;
    }

    protected void add(Properties properties, URL url) {
        Parser parser = this.createParser(this.platforms, url);
        parser.parse(properties, this.implementations);
    }

    protected Parser createParser(Platforms platforms, URL url) {
        return new Parser(platforms, url);
    }

    protected Implementations getImplementations(Class clazz) {
        return this.implementations.get(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(URL url) throws IOException {
        Properties properties = new Properties();
        try (InputStream stream = url.openStream();){
            properties.load(stream);
        }
        this.add(properties, url);
    }

    private boolean moreSpecific(Platform requested, Platform fallback, Platform platform) {
        boolean result = platform.isA(fallback);
        if (!result && requested.getVersion() != null && requested.getVersion().equals(platform.getVersion()) && fallback.getVersion() == null) {
            result = true;
        }
        return result;
    }

    protected static class Implementations {
        private String defaultImplementation;
        private Map<Platform, String> implementations = new HashMap<Platform, String>();

        protected Implementations() {
        }

        public void setDefault(String defaultImplementation) {
            this.defaultImplementation = defaultImplementation;
        }

        public String getDefault() {
            return this.defaultImplementation;
        }

        public Set<Platform> getPlatforms() {
            return this.implementations.keySet();
        }

        public String getImplementation(Platform platform) {
            return this.implementations.get(platform);
        }

        public void addImplementation(Platform platform, String implementation) {
            this.implementations.put(platform, implementation);
        }
    }

    protected static class Parser {
        private final Platforms platforms;
        private final URL url;

        public Parser(Platforms platforms, URL url) {
            this.platforms = platforms;
            this.url = url;
        }

        public void parse(Properties properties, Map<String, Implementations> implementations) {
            for (String key : properties.stringPropertyNames()) {
                String[] interfacePlatform = key.split(",");
                if (interfacePlatform.length >= 1 && interfacePlatform.length <= 3) {
                    String iface = this.trimToNull(interfacePlatform[0]);
                    String name = interfacePlatform.length >= 2 ? this.trimToNull(interfacePlatform[1]) : null;
                    String arch = interfacePlatform.length == 3 ? this.trimToNull(interfacePlatform[2]) : null;
                    String impl = this.trimToNull(properties.getProperty(key));
                    if (iface == null) {
                        this.warning("Ignoring null interface=" + key + " from " + this.url);
                        continue;
                    }
                    if (impl == null) {
                        this.warning("Ignoring null implementation for key=" + key + " from " + this.url);
                        continue;
                    }
                    Implementations impls = implementations.get(iface);
                    if (impls == null) {
                        impls = new Implementations();
                        implementations.put(iface, impls);
                    }
                    if (name == null) {
                        if (impls.getDefault() == null) {
                            impls.setDefault(impl);
                            continue;
                        }
                        this.warning("Ignoring duplicate default implementation=" + impl + " from " + this.url);
                        continue;
                    }
                    Platform platform = this.platforms.getPlatform(name, arch);
                    if (platform.getName() == Platform.Name.UNKNOWN) {
                        this.warning("Ignoring unsupported platform=" + platform + " for key=" + key + " from " + this.url);
                        continue;
                    }
                    if (impls.getImplementation(platform) == null) {
                        impls.addImplementation(platform, impl);
                        continue;
                    }
                    this.warning("Ignoring duplicate implementation=" + impl + " for platform=" + platform + " from " + this.url);
                    continue;
                }
                this.warning("Ignoring invalid entry=" + key + ", length=" + interfacePlatform.length + " from " + this.url);
            }
        }

        protected void warning(String message) {
            logger.warning(message);
        }

        private String trimToNull(String str) {
            if (str != null) {
                str = str.trim();
            }
            return str == null || str.length() == 0 ? null : str;
        }
    }
}

