/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.file;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.userinput.field.file.AbstractFileField;
import com.izforge.izpack.panels.userinput.field.file.DirFieldConfig;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirField
extends AbstractFileField {
    private final boolean mustExist;
    private final boolean create;
    private static final Logger logger = Logger.getLogger(DirField.class.getName());

    public DirField(DirFieldConfig config, InstallData installData) {
        super(config, installData);
        this.mustExist = config.getMustExist();
        this.create = config.getCreate();
    }

    public boolean getMustExist() {
        return this.mustExist;
    }

    public boolean getCreate() {
        return this.create;
    }

    public boolean isWritable(File dir) {
        boolean result = false;
        File parent = IoHelper.existingParent(dir);
        if (parent != null) {
            Platform platform = this.getInstallData().getPlatform();
            if (platform.isA(Platforms.WINDOWS)) {
                try {
                    File tmpFile = File.createTempFile("izWrTe", ".tmp", parent);
                    if (!tmpFile.delete()) {
                        tmpFile.deleteOnExit();
                    }
                    result = true;
                }
                catch (IOException exception) {
                    logger.log(Level.WARNING, exception.getMessage(), exception);
                }
            } else {
                result = parent.canWrite();
            }
        }
        return result;
    }
}

