/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.custom;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldFactory;
import com.izforge.izpack.panels.userinput.field.FieldReader;
import com.izforge.izpack.panels.userinput.field.custom.Column;
import com.izforge.izpack.panels.userinput.field.custom.CustomFieldConfig;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.List;

public class CustomFieldReader
extends FieldReader
implements CustomFieldConfig {
    private InstallData installData;
    private final Config config;
    private final PlatformModelMatcher matcher;

    public CustomFieldReader(IXMLElement field, Config config, PlatformModelMatcher matcher, InstallData installData) {
        super(field, config);
        this.installData = installData;
        this.config = config;
        this.matcher = matcher;
    }

    @Override
    public List<Column> getColumns() {
        ArrayList<Column> result = new ArrayList<Column>();
        for (IXMLElement column : this.getSpec().getChildrenNamed("col")) {
            result.add(new Column(this.getValidators(column)));
        }
        return result;
    }

    @Override
    public List<Field> getFields() {
        ArrayList<Field> result = new ArrayList<Field>();
        FieldFactory factory = new FieldFactory(this.config, this.installData, this.matcher);
        for (IXMLElement column : this.getSpec().getChildrenNamed("col")) {
            List<IXMLElement> fieldConfig = column.getChildrenNamed("field");
            for (IXMLElement fieldElement : fieldConfig) {
                Field field = factory.create(fieldElement);
                result.add(field);
            }
        }
        return result;
    }

    @Override
    public int getMinRow() {
        String minRowString = this.getConfig().getAttribute(this.getField(), "minRow", true);
        try {
            return Integer.parseInt(minRowString);
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public int getMaxRow() {
        String maxRowString = this.getConfig().getAttribute(this.getField(), "maxRow", true);
        try {
            return Integer.parseInt(maxRowString);
        }
        catch (Exception e) {
            return 5;
        }
    }
}

