/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;

public class WinServiceUserDataValidator
implements DataValidator {
    private static final String errLogon = "errwinsrvaccount";
    private static final String errLogonService = "warnwinsrvaccount";
    private static final String warnLogonServiceChanged = "warnLogonServiceChanged";
    private String errorMsg = "errwinsrvaccount";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        if (!OsVersion.IS_WINDOWS) {
            return DataValidator.Status.OK;
        }
        DataValidator.Status bReturn = DataValidator.Status.ERROR;
        try {
            String userName = adata.getVariable("syracuse.winservice.username");
            String passWord = adata.getVariable("syracuse.winservice.password");
            String strDomain = ".";
            String bUseDomain = "true";
            if (userName.contains("\\")) {
                strDomain = userName.substring(0, userName.indexOf("\\"));
                userName = userName.substring(userName.indexOf("\\") + 1);
            } else if (userName.contains("@")) {
                strDomain = null;
            } else {
                bUseDomain = "false";
            }
            WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
            if (!Advapi32.INSTANCE.LogonUser(userName, strDomain, passWord, 3, 0, phToken)) {
                throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
            }
            Kernel32.INSTANCE.CloseHandle(phToken.getValue());
            if (!Advapi32.INSTANCE.LogonUser(userName, strDomain, passWord, 5, 0, phToken)) {
                bReturn = DataValidator.Status.ERROR;
                this.errorMsg = errLogonService;
                return bReturn;
            }
            bReturn = DataValidator.Status.OK;
            Kernel32.INSTANCE.CloseHandle(phToken.getValue());
            adata.setVariable("syracuse.winservice.usedomain", bUseDomain);
            if (strDomain != null && ".".equals(strDomain)) {
                adata.setVariable("syracuse.winservice.username", userName);
            }
        }
        catch (Exception ex) {
            Debug.trace(ex.getMessage());
            bReturn = DataValidator.Status.ERROR;
        }
        return bReturn;
    }

    @Override
    public String getErrorMessageId() {
        return this.errorMsg;
    }

    @Override
    public String getWarningMessageId() {
        return this.errorMsg;
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

