/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;

public class WinRegistry {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final String CLASSES_ROOT = "HKEY_CLASSES_ROOT";
    private static final String CURRENT_USER = "HKEY_CURRENT_USER";
    private static final String LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";

    public static String valueForKey(int hkey, String path, String key) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException, InterruptedException {
        return WinRegistry.queryValueForKey(hkey, path, key);
    }

    public static List<String> subKeysForPath(int hkey, String path) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BackingStoreException, IOException {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, String> resultsMap = WinRegistry.queryValuesForPath(hkey, path);
        Set<String> keys = resultsMap.keySet();
        for (String key : keys) {
            result.add(key);
        }
        return result;
    }

    private static String queryValueForKey(int hkey, String path, String key) throws IOException {
        return WinRegistry.queryValuesForPath(hkey, path).get(key);
    }

    private static Map<String, String> queryValuesForPath(int hkey, String path) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        Process process = Runtime.getRuntime().exec("reg query \"" + WinRegistry.getParentKey(hkey) + "\\" + path + "\"");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            if (!line.contains("REG_")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line, " \t");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.startsWith("REG_")) {
                    builder.append("\t ");
                    continue;
                }
                builder.append(token).append(" ");
            }
            String[] arr = builder.toString().split("\t");
            map.put(arr[0].trim(), arr[1].trim());
            builder.setLength(0);
        }
        return map;
    }

    private static String getParentKey(int hkey) {
        if (hkey == Integer.MIN_VALUE) {
            return CLASSES_ROOT;
        }
        if (hkey == -2147483647) {
            return CURRENT_USER;
        }
        if (hkey == -2147483646) {
            return LOCAL_MACHINE;
        }
        return null;
    }
}

