/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.WinConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VariableSubstitutor
implements Serializable {
    private static final long serialVersionUID = 3907213762447685687L;
    protected transient Properties variables;
    protected boolean bracesRequired = false;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static final int TYPE_AT = 4;
    protected static final int TYPE_JAVA = 5;
    protected static final int TYPE_ANT = 6;
    protected static final int TYPE_X3WEB = 7;
    protected static final int TYPE_BATCH = 8;
    public static final String PLAIN = "plain";
    public static final String X3WEB = "x3web";
    protected static final Map<String, Integer> typeNameToConstantMap = new HashMap<String, Integer>();
    public static final Map<Integer, String> dosCodePageIdToNameMap;

    public VariableSubstitutor(Properties variables) {
        this.variables = variables;
    }

    public boolean areBracesRequired() {
        return this.bracesRequired;
    }

    public void setBracesRequired(boolean braces) {
        this.bracesRequired = braces;
    }

    public String substitute(String str, String type) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        StringReader reader = new StringReader(str);
        StringWriter writer = new StringWriter();
        try {
            this.substitute(reader, writer, type);
        }
        catch (IOException e) {
            throw new Error("Unexpected I/O exception when reading/writing memory buffer; nested exception is: " + e);
        }
        return writer.getBuffer().toString();
    }

    public int substitute(InputStream in, OutputStream out, String type, String encoding) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        if (encoding == null) {
            int t = this.getTypeConstant(type);
            switch (t) {
                case 1: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case 2: {
                    encoding = "UTF-8";
                    break;
                }
                case 8: {
                    encoding = dosCodePageIdToNameMap.get(WinConsole.INSTANCE.GetConsoleOutputCP());
                }
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        OutputStreamWriter writer = encoding != null ? new OutputStreamWriter(out, encoding) : new OutputStreamWriter(out);
        int subs = 0;
        subs = X3WEB.equals(type) ? this.substituteforweb(reader, writer, type) : this.substitute(reader, writer, type);
        writer.flush();
        return subs;
    }

    public String substitute(InputStream in, String type) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        String encoding = PLAIN;
        int t = this.getTypeConstant(type);
        switch (t) {
            case 1: {
                encoding = "ISO-8859-1";
                break;
            }
            case 2: {
                encoding = "UTF-8";
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        StringWriter writer = new StringWriter();
        this.substitute(reader, writer, type);
        writer.flush();
        return writer.getBuffer().toString();
    }

    public int substituteforweb(Reader reader, Writer writer, String type) throws IllegalArgumentException, IOException {
        String nextLine;
        int subs = 0;
        BufferedReader strReader = new BufferedReader(reader);
        while ((nextLine = strReader.readLine()) != null) {
            String[] chunks = nextLine.split("\\$\\$");
            for (int i = 0; i < chunks.length; ++i) {
                if (this.variables.containsKey(chunks[i])) {
                    String varvalue = this.variables.getProperty(chunks[i]);
                    if (varvalue != null) {
                        writer.write(varvalue);
                        ++subs;
                        continue;
                    }
                    writer.write(chunks[i]);
                    continue;
                }
                writer.write(chunks[i]);
            }
            if (OsVersion.IS_WINDOWS) {
                writer.write("\r\n");
                continue;
            }
            writer.write("\n");
        }
        return subs;
    }

    public int substitute(Reader reader, Writer writer, String type) throws IllegalArgumentException, IOException {
        int t = this.getTypeConstant(type);
        int variable_start = 36;
        int variable_end = 0;
        if (t == 3) {
            variable_start = 37;
        } else if (t == 4) {
            variable_start = 64;
        } else if (t == 6) {
            variable_start = 64;
            variable_end = 64;
        }
        int subs = 0;
        int c = reader.read();
        while (true) {
            if (c != -1 && c != variable_start) {
                writer.write(c);
                c = reader.read();
                continue;
            }
            if (c == -1) {
                return subs;
            }
            boolean braces = false;
            c = reader.read();
            if (c == 123) {
                braces = true;
                c = reader.read();
            } else {
                if (this.bracesRequired) {
                    writer.write(variable_start);
                    continue;
                }
                if (c == -1) {
                    writer.write(variable_start);
                    return subs;
                }
            }
            StringBuffer nameBuffer = new StringBuffer();
            while (c != -1 && braces && c != 125 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || braces && (c == 91 || c == 93) || (c >= 48 && c <= 57 || c == 95 || c == 46 || c == 45) && nameBuffer.length() > 0) {
                nameBuffer.append((char)c);
                c = reader.read();
            }
            String name = nameBuffer.toString();
            String varvalue = null;
            if (!(braces && c != 125 || braces && variable_end != 0 && variable_end != c || name.length() <= 0)) {
                if (braces && name.startsWith("ENV[") && name.lastIndexOf(93) == name.length() - 1) {
                    varvalue = IoHelper.getenv(name.substring(4, name.length() - 1));
                    if (varvalue == null) {
                        varvalue = "";
                    }
                } else if (braces && name.startsWith("regkey[") && name.lastIndexOf(93) == name.length() - 1) {
                    varvalue = IoHelper.getRegistry(name.substring(7, name.length() - 1));
                    if (varvalue == null) {
                        varvalue = "";
                    }
                } else {
                    varvalue = this.variables.getProperty(name);
                }
                ++subs;
            }
            if (varvalue != null) {
                writer.write(this.escapeSpecialChars(varvalue, t));
                if (!braces && variable_end == 0) continue;
                c = reader.read();
                continue;
            }
            writer.write(variable_start);
            if (braces) {
                writer.write(123);
            }
            writer.write(name);
        }
    }

    protected int getTypeConstant(String type) {
        if (type == null) {
            return 0;
        }
        Integer integer = typeNameToConstantMap.get(type);
        if (integer == null) {
            throw new IllegalArgumentException("Unknown file type " + type);
        }
        return integer;
    }

    protected String escapeSpecialChars(String str, int type) {
        switch (type) {
            case 0: 
            case 4: 
            case 6: {
                return str;
            }
            case 3: {
                return str.replace("\r", "");
            }
            case 8: {
                return str.replace("%", "%%").replace("\\\"", "\\\\\"");
            }
            case 1: 
            case 5: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    char c = buffer.charAt(i);
                    if (type == 1) {
                        if (c == '\t' || c == '\n' || c == '\r') {
                            char tag = c == '\t' ? (char)'t' : (c == '\n' ? (char)'n' : 'r');
                            buffer.replace(i, i + 1, "\\" + tag);
                            ++len;
                            ++i;
                        }
                        if (c != '\\' && c != '\"' && c != '\'' && c != ' ') continue;
                        buffer.insert(i, '\\');
                        ++len;
                        ++i;
                        continue;
                    }
                    if (c != '\\') continue;
                    buffer.replace(i, i + 1, "\\\\");
                    ++len;
                    ++i;
                }
                return buffer.toString();
            }
            case 2: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i = 0; i < len; ++i) {
                    String r = null;
                    char c = buffer.charAt(i);
                    switch (c) {
                        case '<': {
                            r = "&lt;";
                            break;
                        }
                        case '>': {
                            r = "&gt;";
                            break;
                        }
                        case '&': {
                            r = "&amp;";
                            break;
                        }
                        case '\'': {
                            r = "&apos;";
                            break;
                        }
                        case '\"': {
                            r = "&quot;";
                        }
                    }
                    if (r == null) continue;
                    buffer.replace(i, i + 1, r);
                    len = buffer.length();
                    i += r.length() - 1;
                }
                return buffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + type);
    }

    static {
        typeNameToConstantMap.put(PLAIN, 0);
        typeNameToConstantMap.put("javaprop", 1);
        typeNameToConstantMap.put("java", 5);
        typeNameToConstantMap.put("xml", 2);
        typeNameToConstantMap.put("shell", 3);
        typeNameToConstantMap.put("at", 4);
        typeNameToConstantMap.put("ant", 6);
        typeNameToConstantMap.put(X3WEB, 7);
        typeNameToConstantMap.put("batch", 8);
        dosCodePageIdToNameMap = new HashMap<Integer, String>();
        dosCodePageIdToNameMap.put(31, "IBM037");
        dosCodePageIdToNameMap.put(437, "IBM437");
        dosCodePageIdToNameMap.put(500, "IBM500");
        dosCodePageIdToNameMap.put(708, "ASMO-708");
        dosCodePageIdToNameMap.put(709, "Arabic");
        dosCodePageIdToNameMap.put(710, "Arabic");
        dosCodePageIdToNameMap.put(720, "DOS-720");
        dosCodePageIdToNameMap.put(737, "ibm737");
        dosCodePageIdToNameMap.put(775, "ibm775");
        dosCodePageIdToNameMap.put(850, "ibm850");
        dosCodePageIdToNameMap.put(852, "ibm852");
        dosCodePageIdToNameMap.put(855, "IBM855");
        dosCodePageIdToNameMap.put(857, "ibm857");
        dosCodePageIdToNameMap.put(858, "IBM00858");
        dosCodePageIdToNameMap.put(860, "IBM860");
        dosCodePageIdToNameMap.put(861, "ibm861");
        dosCodePageIdToNameMap.put(862, "DOS-862");
        dosCodePageIdToNameMap.put(863, "IBM863");
        dosCodePageIdToNameMap.put(864, "IBM864");
        dosCodePageIdToNameMap.put(865, "IBM865");
        dosCodePageIdToNameMap.put(866, "cp866");
        dosCodePageIdToNameMap.put(869, "ibm869");
        dosCodePageIdToNameMap.put(870, "IBM870");
        dosCodePageIdToNameMap.put(874, "windows-874");
        dosCodePageIdToNameMap.put(875, "cp875");
        dosCodePageIdToNameMap.put(932, "shift_jis");
        dosCodePageIdToNameMap.put(936, "gb2312");
        dosCodePageIdToNameMap.put(949, "ks_c_5601-1987");
        dosCodePageIdToNameMap.put(950, "big5");
        dosCodePageIdToNameMap.put(1026, "IBM1026");
        dosCodePageIdToNameMap.put(1047, "IBM01047");
        dosCodePageIdToNameMap.put(1140, "IBM01140");
        dosCodePageIdToNameMap.put(1141, "IBM01141");
        dosCodePageIdToNameMap.put(1142, "IBM01142");
        dosCodePageIdToNameMap.put(1143, "IBM01143");
        dosCodePageIdToNameMap.put(1144, "IBM01144");
        dosCodePageIdToNameMap.put(1145, "IBM01145");
        dosCodePageIdToNameMap.put(1146, "IBM01146");
        dosCodePageIdToNameMap.put(1147, "IBM01147");
        dosCodePageIdToNameMap.put(1148, "IBM01148");
        dosCodePageIdToNameMap.put(1149, "IBM01149");
        dosCodePageIdToNameMap.put(1200, "utf-16");
        dosCodePageIdToNameMap.put(1201, "unicodeFFFE");
        dosCodePageIdToNameMap.put(1250, "windows-1250");
        dosCodePageIdToNameMap.put(1251, "windows-1251");
        dosCodePageIdToNameMap.put(1252, "windows-1252");
        dosCodePageIdToNameMap.put(1253, "windows-1253");
        dosCodePageIdToNameMap.put(1254, "windows-1254");
        dosCodePageIdToNameMap.put(1255, "windows-1255");
        dosCodePageIdToNameMap.put(1256, "windows-1256");
        dosCodePageIdToNameMap.put(1257, "windows-1257");
        dosCodePageIdToNameMap.put(1258, "windows-1258");
        dosCodePageIdToNameMap.put(1361, "Johab");
        dosCodePageIdToNameMap.put(10000, "macintosh");
        dosCodePageIdToNameMap.put(10001, "x-mac-japanese");
        dosCodePageIdToNameMap.put(10002, "x-mac-chinesetrad");
        dosCodePageIdToNameMap.put(10003, "x-mac-korean");
        dosCodePageIdToNameMap.put(10004, "x-mac-arabic");
        dosCodePageIdToNameMap.put(10005, "x-mac-hebrew");
        dosCodePageIdToNameMap.put(10006, "x-mac-greek");
        dosCodePageIdToNameMap.put(10007, "x-mac-cyrillic");
        dosCodePageIdToNameMap.put(10008, "x-mac-chinesesimp");
        dosCodePageIdToNameMap.put(10010, "x-mac-romanian");
        dosCodePageIdToNameMap.put(10017, "x-mac-ukrainian");
        dosCodePageIdToNameMap.put(10021, "x-mac-thai");
        dosCodePageIdToNameMap.put(10029, "x-mac-ce");
        dosCodePageIdToNameMap.put(10079, "x-mac-icelandic");
        dosCodePageIdToNameMap.put(10081, "x-mac-turkish");
        dosCodePageIdToNameMap.put(10082, "x-mac-croatian");
        dosCodePageIdToNameMap.put(12000, "utf-32");
        dosCodePageIdToNameMap.put(12001, "utf-32BE");
        dosCodePageIdToNameMap.put(20000, "x-Chinese_CNS");
        dosCodePageIdToNameMap.put(20001, "x-cp20001");
        dosCodePageIdToNameMap.put(20002, "x_Chinese-Eten");
        dosCodePageIdToNameMap.put(20003, "x-cp20003");
        dosCodePageIdToNameMap.put(20004, "x-cp20004");
        dosCodePageIdToNameMap.put(20005, "x-cp20005");
        dosCodePageIdToNameMap.put(20105, "x-IA5");
        dosCodePageIdToNameMap.put(20106, "x-IA5-German");
        dosCodePageIdToNameMap.put(20107, "x-IA5-Swedish");
        dosCodePageIdToNameMap.put(20108, "x-IA5-Norwegian");
        dosCodePageIdToNameMap.put(20127, "us-ascii");
        dosCodePageIdToNameMap.put(20261, "x-cp20261");
        dosCodePageIdToNameMap.put(20269, "x-cp20269");
        dosCodePageIdToNameMap.put(20273, "IBM273");
        dosCodePageIdToNameMap.put(20277, "IBM277");
        dosCodePageIdToNameMap.put(20278, "IBM278");
        dosCodePageIdToNameMap.put(20280, "IBM280");
        dosCodePageIdToNameMap.put(20284, "IBM284");
        dosCodePageIdToNameMap.put(20285, "IBM285");
        dosCodePageIdToNameMap.put(20290, "IBM290");
        dosCodePageIdToNameMap.put(20297, "IBM297");
        dosCodePageIdToNameMap.put(20420, "IBM420");
        dosCodePageIdToNameMap.put(20423, "IBM423");
        dosCodePageIdToNameMap.put(20424, "IBM424");
        dosCodePageIdToNameMap.put(20833, "x-EBCDIC-KoreanExtended");
        dosCodePageIdToNameMap.put(20838, "IBM-Thai");
        dosCodePageIdToNameMap.put(20866, "koi8-r");
        dosCodePageIdToNameMap.put(20871, "IBM871");
        dosCodePageIdToNameMap.put(20880, "IBM880");
        dosCodePageIdToNameMap.put(20905, "IBM905");
        dosCodePageIdToNameMap.put(20924, "IBM00924");
        dosCodePageIdToNameMap.put(20932, "EUC-JP");
        dosCodePageIdToNameMap.put(20936, "x-cp20936");
        dosCodePageIdToNameMap.put(20949, "x-cp20949");
        dosCodePageIdToNameMap.put(21025, "cp1025");
        dosCodePageIdToNameMap.put(21027, "(deprecated)");
        dosCodePageIdToNameMap.put(21866, "koi8-u");
        dosCodePageIdToNameMap.put(28591, "iso-8859-1");
        dosCodePageIdToNameMap.put(28592, "iso-8859-2");
        dosCodePageIdToNameMap.put(28593, "iso-8859-3");
        dosCodePageIdToNameMap.put(28594, "iso-8859-4");
        dosCodePageIdToNameMap.put(28595, "iso-8859-5");
        dosCodePageIdToNameMap.put(28596, "iso-8859-6");
        dosCodePageIdToNameMap.put(28597, "iso-8859-7");
        dosCodePageIdToNameMap.put(28598, "iso-8859-8");
        dosCodePageIdToNameMap.put(28599, "iso-8859-9");
        dosCodePageIdToNameMap.put(28603, "iso-8859-13");
        dosCodePageIdToNameMap.put(28605, "iso-8859-15");
        dosCodePageIdToNameMap.put(29001, "x-Europa");
        dosCodePageIdToNameMap.put(38598, "iso-8859-8-i");
        dosCodePageIdToNameMap.put(50220, "iso-2022-jp");
        dosCodePageIdToNameMap.put(50221, "csISO2022JP");
        dosCodePageIdToNameMap.put(50222, "iso-2022-jp");
        dosCodePageIdToNameMap.put(50225, "iso-2022-kr");
        dosCodePageIdToNameMap.put(50227, "x-cp50227");
        dosCodePageIdToNameMap.put(50229, "ISO");
        dosCodePageIdToNameMap.put(50930, "EBCDIC");
        dosCodePageIdToNameMap.put(50931, "EBCDIC");
        dosCodePageIdToNameMap.put(50933, "EBCDIC");
        dosCodePageIdToNameMap.put(50935, "EBCDIC");
        dosCodePageIdToNameMap.put(50936, "EBCDIC");
        dosCodePageIdToNameMap.put(50937, "EBCDIC");
        dosCodePageIdToNameMap.put(50939, "EBCDIC");
        dosCodePageIdToNameMap.put(51932, "euc-jp");
        dosCodePageIdToNameMap.put(51936, "EUC-CN");
        dosCodePageIdToNameMap.put(51949, "euc-kr");
        dosCodePageIdToNameMap.put(51950, "EUC");
        dosCodePageIdToNameMap.put(52936, "hz-gb-2312");
        dosCodePageIdToNameMap.put(54936, "GB18030");
        dosCodePageIdToNameMap.put(57002, "x-iscii-de");
        dosCodePageIdToNameMap.put(57003, "x-iscii-be");
        dosCodePageIdToNameMap.put(57004, "x-iscii-ta");
        dosCodePageIdToNameMap.put(57005, "x-iscii-te");
        dosCodePageIdToNameMap.put(57006, "x-iscii-as");
        dosCodePageIdToNameMap.put(57007, "x-iscii-or");
        dosCodePageIdToNameMap.put(57008, "x-iscii-ka");
        dosCodePageIdToNameMap.put(57009, "x-iscii-ma");
        dosCodePageIdToNameMap.put(57010, "x-iscii-gu");
        dosCodePageIdToNameMap.put(57011, "x-iscii-pa");
        dosCodePageIdToNameMap.put(65000, "utf-7");
        dosCodePageIdToNameMap.put(65001, "utf-8");
    }
}

