/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import java.util.Map;
import java.util.regex.Pattern;

public class RegularExpressionValidator
implements Validator {
    public static final String STR_PATTERN_DEFAULT = "[a-zA-Z0-9._-]{3,}@[a-zA-Z0-9._-]+([.][a-zA-Z0-9_-]+)*[.][a-zA-Z0-9._-]{2,4}";
    private static final String PATTERN_PARAM = "pattern";

    @Override
    public boolean validate(ProcessingClient client, AutomatedInstallData adata) {
        String patternString;
        if (client.hasParams()) {
            Map<String, String> paramMap = client.getValidatorParams();
            patternString = paramMap.get(PATTERN_PARAM);
        } else {
            patternString = STR_PATTERN_DEFAULT;
        }
        Pattern pattern = Pattern.compile(patternString);
        return pattern.matcher(this.getString(client)).matches();
    }

    private String getString(ProcessingClient client) {
        int numFields;
        String returnValue = "";
        returnValue = client instanceof PasswordGroup ? ((numFields = client.getNumFields()) > 0 ? client.getFieldContents(0) : client.getText()) : client.getText();
        return returnValue;
    }
}

