/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.OsVersionConstants;
import com.izforge.izpack.util.StringConstants;
import com.izforge.izpack.util.StringTool;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public final class OsVersion
implements OsVersionConstants,
StringConstants {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean IS_X86 = StringTool.startsWithIgnoreCase(OS_ARCH, "x86") && !StringTool.startsWithIgnoreCase(OS_ARCH, "x86_64") || StringTool.startsWithIgnoreCase(OS_ARCH, "i386");
    public static final boolean IS_X86_64 = StringTool.startsWithIgnoreCase(OS_ARCH, "x86_64") || StringTool.startsWithIgnoreCase(OS_ARCH, "amd64");
    public static final boolean IS_PPC = StringTool.startsWithIgnoreCase(OS_ARCH, "ppc");
    public static final boolean IS_SPARC = StringTool.startsWithIgnoreCase(OS_ARCH, "sparc");
    public static final boolean IS_FREEBSD = StringTool.startsWithIgnoreCase(OS_NAME, "FreeBSD");
    public static final boolean IS_LINUX = StringTool.startsWithIgnoreCase(OS_NAME, "Linux");
    public static final boolean IS_HPUX = StringTool.startsWithIgnoreCase(OS_NAME, "HP-UX");
    public static final boolean IS_AIX = StringTool.startsWithIgnoreCase(OS_NAME, "AIX");
    public static final boolean IS_SUNOS = StringTool.startsWithIgnoreCase(OS_NAME, "SunOS") || StringTool.startsWithIgnoreCase(OS_NAME, "Solaris");
    public static final boolean IS_SUNOS_X86 = IS_SUNOS && IS_X86;
    public static final boolean IS_SUNOS_SPARC = IS_SUNOS && IS_SPARC;
    public static final boolean IS_OS2 = StringTool.startsWith(OS_NAME, "OS/2");
    public static final boolean IS_MAC = StringTool.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OSX = StringTool.startsWithIgnoreCase(OS_NAME, "mac os x");
    public static final boolean IS_WINDOWS = StringTool.startsWith(OS_NAME, "Windows");
    public static final boolean IS_WINDOWS_2000 = StringTool.startsWithIgnoreCase(OS_NAME, "Windows 2000");
    public static final boolean IS_WINDOWS_XP = StringTool.startsWithIgnoreCase(OS_NAME, "Windows XP");
    public static final boolean IS_WINDOWS_2003 = StringTool.startsWithIgnoreCase(OS_NAME, "Windows 2003");
    public static final boolean IS_WINDOWS_VISTA = StringTool.startsWithIgnoreCase(OS_NAME, "Windows Vista");
    public static final boolean IS_WINDOWS_7 = StringTool.startsWithIgnoreCase(OS_NAME, "Windows 7");
    public static final boolean IS_WINDOWS_8 = StringTool.startsWithIgnoreCase(OS_NAME, "Windows 8");
    public static final boolean IS_UNIX = !IS_OS2 && !IS_WINDOWS;
    public static final boolean IS_CENTOS_LINUX = IS_LINUX && FileUtil.fileContains("/etc/centos-release", "CentOS");
    public static final boolean IS_ORACLE_LINUX = IS_LINUX && (FileUtil.fileContains("/etc/oracle-release", "Oracle") || FileUtil.fileContains("/etc/oracle-release", "Entreprise Linux"));
    public static final boolean IS_REDHAT_LINUX = IS_LINUX && !IS_CENTOS_LINUX && !IS_ORACLE_LINUX && (FileUtil.fileContains("/etc/redhat-release", "RedHat") || FileUtil.fileContains("/etc/redhat-release", "Red Hat"));
    public static final boolean IS_FEDORA_LINUX = IS_LINUX && FileUtil.fileContains("/etc/fedora-release", "Fedora");
    public static final boolean IS_UBUNTU_LINUX = IS_LINUX && FileUtil.fileContains("/etc/lsb-release", "Ubuntu");
    public static final boolean IS_MANDRAKE_LINUX = IS_LINUX && FileUtil.fileContains("/etc/mandrake-release", "Mandrake");
    public static final boolean IS_AMI_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "Amazon Linux AMI");
    public static final boolean IS_MANDRIVA_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "Mandriva") || IS_MANDRAKE_LINUX;
    public static final boolean IS_SUSE_LINUX = IS_LINUX && FileUtil.fileContains(OsVersion.getReleaseFileName(), "SuSE", true);
    public static final boolean IS_DEBIAN_LINUX = IS_LINUX && FileUtil.fileContains("/proc/version", "Debian") || IS_LINUX && new File("/etc/debian_version").exists();
    public static final String OS_VERSION = IS_LINUX ? OsVersion.getLinuxversion() : System.getProperty("os.version");
    public static final String MACHINE_ID = OsVersion.getLinuxMachineId();
    public static final boolean MACHINE_ID_REGISTERED = IS_LINUX && MACHINE_ID != null;
    public static final boolean IS_WINDOWS_2008 = StringTool.startsWithIgnoreCase(OS_NAME, "Windows Server 2008") && StringTool.equalsWithIgnoreCase(OS_VERSION, "6.0");
    public static final boolean IS_WINDOWS_2008R2 = StringTool.startsWithIgnoreCase(OS_NAME, "Windows Server 2008 R2") && StringTool.equalsWithIgnoreCase(OS_VERSION, "6.1");

    private static String getReleaseFileName() {
        String result = "";
        File[] etcList = new File("/etc").listFiles();
        if (etcList != null) {
            for (File etcEntry : etcList) {
                if (!etcEntry.isFile() || !etcEntry.getName().endsWith("-release")) continue;
                result = etcEntry.toString();
                return result;
            }
        }
        return result;
    }

    private static String getLinuxMachineId() {
        String result = null;
        File machineIdFile = new File("/var/lib/dbus/machine-id");
        try {
            if (!machineIdFile.exists()) {
                machineIdFile = new File("/etc/machine-id");
            }
            if (machineIdFile.exists()) {
                result = FileUtil.getFileContent(machineIdFile.getAbsolutePath()).get(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static String getLinuxVersionFromFile(String strReleaseFile) {
        String regex = "^(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)$";
        String result = null;
        try {
            ArrayList<String> lstLines = FileUtil.getFileContent(strReleaseFile);
            block2: for (String strline : lstLines) {
                String[] strPattern = strline.trim().split(" |=");
                for (int i = 0; i < strPattern.length; ++i) {
                    if (!strPattern[i].matches("^(?:(\\d+)\\.)?(?:(\\d+)\\.)?(\\*|\\d+)$")) continue;
                    result = strPattern[i];
                    continue block2;
                }
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return result;
    }

    private static String getLinuxversion() {
        String result = null;
        if (IS_SUSE_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/sles-release");
            if (result == null) {
                result = OsVersion.getLinuxVersionFromFile("/etc/novell-release");
            }
            if (result == null) {
                result = OsVersion.getLinuxVersionFromFile("/etc/SuSE-release");
            }
        } else if (IS_UBUNTU_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/lsb-release");
        } else if (IS_REDHAT_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/redhat-release");
        } else if (IS_CENTOS_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/centos-release");
        } else if (IS_ORACLE_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/oracle-release");
        } else if (IS_FEDORA_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/fedora-release");
        } else if (IS_MANDRAKE_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/mandrake-release");
        } else if (IS_MANDRIVA_LINUX) {
            result = OsVersion.getLinuxVersionFromFile("/etc/mandriva-release");
            if (result == null) {
                result = OsVersion.getLinuxVersionFromFile("/etc/mandrake-release");
            }
            if (result == null) {
                result = OsVersion.getLinuxVersionFromFile("/etc/mandrakelinux-release");
            }
        } else {
            result = IS_DEBIAN_LINUX ? OsVersion.getLinuxVersionFromFile("/etc/debian_version") : OsVersion.getLinuxVersionFromFile(OsVersion.getReleaseFileName());
        }
        return result;
    }

    public static String getLinuxDistribution() {
        String result = null;
        if (IS_SUSE_LINUX) {
            try {
                result = "SuSE Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_UBUNTU_LINUX) {
            try {
                result = "Ubuntu Linux\n" + OsVersion.getLinuxversion();
            }
            catch (Exception exception) {}
        } else if (IS_REDHAT_LINUX) {
            try {
                result = "RedHat Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent("/etc/redhat-release"));
            }
            catch (IOException iOException) {}
        } else if (IS_CENTOS_LINUX) {
            try {
                result = "CentOS Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent("/etc/centos-release"));
            }
            catch (IOException iOException) {}
        } else if (IS_ORACLE_LINUX) {
            try {
                result = "Oracle Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent("/etc/oracle-release"));
            }
            catch (IOException iOException) {}
        } else if (IS_FEDORA_LINUX) {
            try {
                result = "Fedora Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_MANDRAKE_LINUX) {
            try {
                result = "Mandrake Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_MANDRIVA_LINUX) {
            try {
                result = "Mandriva Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {}
        } else if (IS_DEBIAN_LINUX) {
            try {
                result = "Debian Linux\n" + StringTool.stringArrayListToString(FileUtil.getFileContent("/etc/debian_version"));
            }
            catch (IOException iOException) {}
        } else {
            try {
                result = "Unknown Linux Distribution\n" + StringTool.stringArrayListToString(FileUtil.getFileContent(OsVersion.getReleaseFileName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getOsDetails() {
        StringBuffer result = new StringBuffer();
        result.append("OS_NAME=").append(OS_NAME).append("\n");
        if (IS_UNIX) {
            if (IS_LINUX) {
                result.append(OsVersion.getLinuxDistribution()).append("\n");
            } else {
                try {
                    result.append(FileUtil.getFileContent(OsVersion.getReleaseFileName())).append("\n");
                }
                catch (IOException e) {
                    Debug.log("Unable to get release file contents in 'getOsDetails'.");
                }
            }
        }
        if (IS_WINDOWS) {
            result.append(System.getProperty("os.name")).append(" ").append(System.getProperty("sun.os.patch.level", "")).append("\n");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(OsVersion.getOsDetails());
    }
}

