/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OsConstraint
implements Serializable {
    private static final long serialVersionUID = 3762248660406450488L;
    private String arch;
    private String family;
    private String jre;
    private String name;
    private String version;

    public OsConstraint(String family, String name, String version, String arch, String jre) {
        this.family = family != null ? family.toLowerCase() : null;
        this.name = name != null ? name.toLowerCase() : null;
        this.version = version != null ? version.toLowerCase() : null;
        this.arch = arch != null ? arch.toLowerCase() : null;
        this.jre = jre != null ? jre.toLowerCase() : null;
    }

    public OsConstraint(String family, String name, String version, String arch) {
        this(family, name, version, arch, null);
    }

    public boolean matchCurrentSystem() {
        boolean match = true;
        String osName = System.getProperty("os.name").toLowerCase();
        if (this.arch != null && this.arch.length() != 0) {
            match = System.getProperty("os.arch").toLowerCase().equals(this.arch);
        }
        if (match && this.version != null && this.version.length() != 0) {
            match = System.getProperty("os.version").toLowerCase().equals(this.version);
        }
        if (match && this.name != null && this.name.length() != 0) {
            match = osName.equals(this.name);
        }
        if (match && this.family != null) {
            if ("windows".equals(this.family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(this.family) || "osx".equals(this.family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(this.family)) {
                match = OsVersion.IS_UNIX;
            }
        }
        if (match && this.jre != null && this.jre.length() > 0) {
            match = System.getProperty("java.version").toLowerCase().startsWith(this.jre);
        }
        return match && (this.family != null || this.name != null || this.version != null || this.arch != null || this.jre != null);
    }

    public static List<OsConstraint> getOsList(IXMLElement element) {
        ArrayList<OsConstraint> osList = new ArrayList<OsConstraint>();
        for (IXMLElement os : element.getChildrenNamed("os")) {
            osList.add(new OsConstraint(os.getAttribute("family", null), os.getAttribute("name", null), os.getAttribute("version", null), os.getAttribute("arch", null), os.getAttribute("jre", null)));
        }
        String osattr = element.getAttribute("os");
        if (osattr != null && osattr.length() > 0) {
            osList.add(new OsConstraint(osattr, null, null, null, null));
        }
        return osList;
    }

    public static boolean oneMatchesCurrentSystem(List<OsConstraint> constraint_list) {
        if (constraint_list == null) {
            return true;
        }
        Iterator<OsConstraint> constraint_it = constraint_list.iterator();
        if (!constraint_it.hasNext()) {
            return true;
        }
        while (constraint_it.hasNext()) {
            OsConstraint osc = constraint_it.next();
            Debug.trace("checking if os constraints " + osc + " match current OS");
            if (!osc.matchCurrentSystem()) continue;
            Debug.trace("matched current OS.");
            return true;
        }
        Debug.trace("no match with current OS!");
        return false;
    }

    public static boolean oneMatchesCurrentSystem(IXMLElement el) {
        return OsConstraint.oneMatchesCurrentSystem(OsConstraint.getOsList(el));
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase();
    }

    public String getFamily() {
        return this.family;
    }

    public void setName(String n) {
        this.name = n.toLowerCase();
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String v) {
        this.version = v.toLowerCase();
    }

    public String getVersion() {
        return this.version;
    }

    public void setArch(String a) {
        this.arch = a.toLowerCase();
    }

    public String getArch() {
        return this.arch;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[Os ");
        retval.append(" family ").append(this.family);
        retval.append(" name ").append(this.name);
        retval.append(" version ").append(this.version);
        retval.append(" arch ").append(this.arch);
        retval.append(" jre ").append(this.jre);
        retval.append(" ]");
        return retval.toString();
    }
}

