/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NodeIdentifierDataValidator
implements DataValidator {
    private static final String SPEC_FILE_NAME = "productsSpec.txt";

    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        return this.validate(adata.getVariable("component.node.name"), adata.getVariable("APP_NAME"));
    }

    @Override
    public String getErrorMessageId() {
        return "nodealreadyexisterror";
    }

    @Override
    public String getWarningMessageId() {
        return "nodealreadyexistwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    public DataValidator.Status validate(String pstrNodeName, String pstrAppName) {
        DataValidator.Status bReturn;
        block14: {
            bReturn = DataValidator.Status.ERROR;
            try {
                String line;
                String nodeName = pstrNodeName;
                String svcExt = ".service";
                ArrayList<String> uninstallKeyPrefixList = new ArrayList<String>();
                uninstallKeyPrefixList.add(pstrAppName);
                try {
                    InputStream input = ResourceManager.getInstance().getInputStream(SPEC_FILE_NAME);
                    if (input != null) {
                        String line2;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                        File[] out = new StringBuilder();
                        while ((line2 = reader.readLine()) != null) {
                            uninstallKeyPrefixList.add(line2.trim());
                        }
                        reader.close();
                    }
                }
                catch (Exception ex) {
                    Debug.log(ex);
                }
                String serviceName = "";
                if (OsVersion.IS_UNIX) {
                    File etcInitDir = new File("/etc/systemd/system");
                    if (!etcInitDir.exists() || !etcInitDir.isDirectory()) {
                        etcInitDir = new File("/etc/init");
                        svcExt = ".conf";
                    }
                    bReturn = DataValidator.Status.OK;
                    for (File fileEntry : etcInitDir.listFiles()) {
                        if (!fileEntry.getName().endsWith("-" + pstrNodeName.toLowerCase() + svcExt) && !fileEntry.getName().endsWith("_-_" + pstrNodeName.toLowerCase() + svcExt)) continue;
                        BufferedReader reader = new BufferedReader(new FileReader(fileEntry));
                        String firstLine = reader.readLine();
                        reader.close();
                        for (String prefix : uninstallKeyPrefixList) {
                            if (!firstLine.startsWith("# " + prefix)) continue;
                            return DataValidator.Status.ERROR;
                        }
                    }
                    break block14;
                }
                bReturn = DataValidator.Status.OK;
                String commandquery = "sc query state= all | findstr /R /C:\"" + nodeName + "\"";
                String[] command = new String[]{"CMD", "/C", commandquery};
                ProcessBuilder probuilder = new ProcessBuilder(command);
                Process process = probuilder.start();
                InputStream is = process.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    for (String prefix : uninstallKeyPrefixList) {
                        if (!line.startsWith("DISPLAY_NAME: " + prefix)) continue;
                        bReturn = DataValidator.Status.ERROR;
                    }
                }
                try {
                    int prefix = process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                Debug.trace(ex.getMessage());
                bReturn = DataValidator.Status.ERROR;
            }
        }
        return bReturn;
    }
}

