/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class ElasticSearchDataValidator
implements DataValidator {
    @Override
    public DataValidator.Status validateData(AutomatedInstallData adata) {
        DataValidator.Status bReturn = DataValidator.Status.ERROR;
        try {
            String hostName = adata.getVariable("elasticsearch.url.hostname");
            String hostPort = adata.getVariable("elasticsearch.service.httpport");
            String strurl = "http://" + hostName + ":" + hostPort + "/_nodes";
            String condition = adata.getVariable("elasticsearch.install.now");
            if (condition != null && !RulesEngine.getCondition(condition).isTrue()) {
                adata.setVariable("elasticsearch.url.hostname", "");
                Debug.trace("Skip connection to " + strurl + " - elasticsearch.install.now=false");
                return DataValidator.Status.OK;
            }
            String strHttpResult = this.getHTML(strurl);
            if (strHttpResult.startsWith("{") && strHttpResult.endsWith("}")) {
                bReturn = DataValidator.Status.OK;
            }
        }
        catch (Exception ex) {
            Debug.trace(ex.getMessage());
        }
        return bReturn;
    }

    public String getHTML(String urlToRead) {
        String result = "";
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = result + line;
            }
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getErrorMessageId() {
        return "elasticsearchtesterror";
    }

    @Override
    public String getWarningMessageId() {
        return "elasticsearchtesterror";
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

