/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class AndCondition
extends Condition {
    private static final long serialVersionUID = -5854944262991488370L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public AndCondition() {
    }

    public AndCondition(Condition operand1, Condition operand2, AutomatedInstallData installdata) {
        this.installdata = installdata;
        this.leftoperand = operand1;
        if (this.leftoperand != null) {
            this.leftoperand.setInstalldata(this.installdata);
        }
        this.rightoperand = operand2;
        if (this.rightoperand != null) {
            this.rightoperand.setInstalldata(this.installdata);
        }
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 2) {
                Debug.log("and-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(1));
        }
        catch (Exception e) {
            Debug.log("missing element in and-condition");
        }
    }

    @Override
    public boolean isTrue() {
        if (this.leftoperand == null || this.rightoperand == null) {
            Debug.trace("Operands of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand.setInstalldata(this.installdata);
        return this.leftoperand.isTrue() && this.rightoperand.isTrue();
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul><li>");
        details.append(this.leftoperand.getDependenciesDetails());
        details.append("</li> AND <li>");
        details.append(this.rightoperand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement root) {
        IXMLElement left = RulesEngine.createConditionElement(this.leftoperand, root);
        this.leftoperand.makeXMLData(left);
        root.addChild(left);
        IXMLElement right = RulesEngine.createConditionElement(this.rightoperand, root);
        this.rightoperand.makeXMLData(right);
        root.addChild(right);
    }
}

