/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.gui.TwoColumnLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.DirInputField;
import com.izforge.izpack.panels.FileInputField;
import com.izforge.izpack.panels.MultipleFileInputField;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.PasswordUIElement;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RadioButtonUIElement;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.TextInputField;
import com.izforge.izpack.panels.UIElement;
import com.izforge.izpack.panels.UIElementType;
import com.izforge.izpack.panels.UserInputPanelAutomationHelper;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.rules.VariableExistenceCondition;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.HyperlinkHandler;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class UserInputPanel
extends IzPanel
implements ActionListener,
ItemListener,
FocusListener {
    private static final long serialVersionUID = 3257850965439886129L;
    protected static final String ICON_KEY = "icon";
    private static final String SPEC_FILE_NAME = "userInputSpec.xml";
    private static final String LANG_FILE_NAME = "userInputLang.xml";
    private static final String NODE_ID = "panel";
    private static final String FIELD_NODE_ID = "field";
    private static final String INSTANCE_IDENTIFIER = "order";
    protected static final String PANEL_IDENTIFIER = "id";
    private static final String TYPE = "type";
    private static final String DESCRIPTION = "description";
    private static final String VARIABLE = "variable";
    protected static final String TEXT = "txt";
    protected static final String KEY = "id";
    private static final String SPEC = "spec";
    private static final String SET = "set";
    private static final String REVALIDATE = "revalidate";
    private static final String TOPBUFFER = "topBuffer";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ALIGNMENT = "align";
    private static final String LEFT = "left";
    private static final String CENTER = "center";
    private static final String RIGHT = "right";
    private static final String TOP = "top";
    private static final String ITALICS = "italic";
    private static final String BOLD = "bold";
    private static final String SIZE = "size";
    protected static final String VALIDATOR = "validator";
    private static final String PROCESSOR = "processor";
    protected static final String CLASS = "class";
    private static final String TITLE_FIELD = "title";
    private static final String TEXT_FIELD = "text";
    private static final String TEXT_SIZE = "size";
    private static final String TEXT_ROWS = "rows";
    private static final String STATIC_TEXT = "staticText";
    private static final String COMBO_FIELD = "combo";
    private static final String COMBO_CHOICE = "choice";
    private static final String COMBO_VALUE = "value";
    private static final String RADIO_FIELD = "radio";
    private static final String RADIO_CHOICE = "choice";
    private static final String RADIO_VALUE = "value";
    private static final String SPACE_FIELD = "space";
    private static final String DIVIDER_FIELD = "divider";
    private static final String CHECK_FIELD = "check";
    private static final String RULE_FIELD = "rule";
    private static final String RULE_LAYOUT = "layout";
    private static final String RULE_SEPARATOR = "separator";
    private static final String RULE_RESULT_FORMAT = "resultFormat";
    private static final String RULE_PLAIN_STRING = "plainString";
    private static final String RULE_DISPLAY_FORMAT = "displayFormat";
    private static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    private static final String RULE_ENCRYPTED = "processed";
    protected static final String RULE_PARAM_NAME = "name";
    protected static final String RULE_PARAM_VALUE = "value";
    protected static final String RULE_PARAM = "param";
    private static final String PWD_FIELD = "password";
    private static final String PWD_INPUT = "pwd";
    private static final String PWD_SIZE = "size";
    private static final String SEARCH_FIELD = "search";
    private static final String FILE_FIELD = "file";
    private static final String DIR_FIELD = "dir";
    private static final String SEARCH_CHOICE = "choice";
    private static final String SEARCH_FILENAME = "filename";
    private static final String SEARCH_RESULT = "result";
    private static final String SEARCH_VALUE = "value";
    private static final String SEARCH_TYPE = "type";
    private static final String SEARCH_FILE = "file";
    private static final String SEARCH_DIRECTORY = "directory";
    private static final String SEARCH_PARENTDIR = "parentdir";
    private static final String SEARCH_CHECKFILENAME = "checkfilename";
    private static final String SELECTEDPACKS = "createForPack";
    private static final String UNSELECTEDPACKS = "createForUnselectedPack";
    protected static final String ATTRIBUTE_CONDITIONID_NAME = "conditionid";
    protected static final String VARIABLE_NODE = "variable";
    protected static final String ATTRIBUTE_VARIABLE_NAME = "name";
    protected static final String ATTRIBUTE_VARIABLE_VALUE = "value";
    private static final String NAME = "name";
    private static final String OS = "os";
    private static final String FAMILY = "family";
    private static final String MULTIPLE_FILE_FIELD = "multiFile";
    private static int instanceCount = 0;
    protected int instanceNumber = 0;
    private boolean packsDefined = false;
    private InstallerFrame parentFrame;
    private IXMLElement spec;
    private boolean haveSpec = false;
    private Vector<ButtonGroup> buttonGroups = new Vector();
    private Vector<PasswordGroup> passwordGroups = new Vector();
    private Vector passwordGroupsRead = new Vector();
    private Vector<SearchField> searchFields = new Vector();
    private Vector<TextValuePair> entries = new Vector();
    private LocaleDatabase langpack = null;
    private boolean validating = true;
    private boolean eventsActivated = false;
    private Vector<UIElement> elements = new Vector();
    private JPanel panel;

    public UserInputPanel(InstallerFrame parent, InstallData installData) {
        super(parent, installData);
        this.instanceNumber = instanceCount++;
        this.parentFrame = parent;
    }

    private void createBuiltInVariableConditions(String variable) {
        if (variable != null) {
            VariableExistenceCondition variableCondition = new VariableExistenceCondition();
            variableCondition.setId("izpack.input." + variable);
            variableCondition.setInstalldata(this.idata);
            variableCondition.setVariable(variable);
            this.parent.getRules().addCondition(variableCondition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        TwoColumnLayout layout;
        this.eventsActivated = false;
        super.removeAll();
        this.elements.clear();
        try {
            this.langpack = (LocaleDatabase)this.parent.langpack.clone();
            String resource = "userInputLang.xml_" + this.idata.localeISO3;
            this.langpack.add(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (ResourceNotFoundException e) {
            Debug.trace(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.readSpec();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        int topbuff = 0;
        try {
            topbuff = Integer.parseInt(this.spec.getAttribute(TOPBUFFER));
        }
        catch (Exception exception) {
        }
        finally {
            layout = new TwoColumnLayout(10, 5, 30, topbuff, 0);
        }
        this.setLayout(new BorderLayout());
        this.panel = new JPanel();
        this.panel.setLayout(layout);
        if (!this.haveSpec) {
            return;
        }
        this.updateVariables();
        Vector<IXMLElement> fields = this.spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < fields.size(); ++i) {
            String conditionid;
            IXMLElement field = fields.elementAt(i);
            String attribute = field.getAttribute("type");
            String associatedVariable = field.getAttribute("variable");
            if (associatedVariable != null) {
                this.createBuiltInVariableConditions(associatedVariable);
            }
            if ((conditionid = field.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !this.parent.getRules().isConditionTrue(conditionid, this.idata.getVariables()) || attribute == null) continue;
            if (attribute.equals(RULE_FIELD)) {
                this.addRuleField(field);
                continue;
            }
            if (attribute.equals(TEXT_FIELD)) {
                this.addTextField(field);
                continue;
            }
            if (attribute.equals(COMBO_FIELD)) {
                this.addComboBox(field);
                continue;
            }
            if (attribute.equals(RADIO_FIELD)) {
                this.addRadioButton(field);
                continue;
            }
            if (attribute.equals(PWD_FIELD)) {
                this.addPasswordField(field);
                continue;
            }
            if (attribute.equals(SPACE_FIELD)) {
                this.addSpace(field);
                continue;
            }
            if (attribute.equals(DIVIDER_FIELD)) {
                this.addDivider(field);
                continue;
            }
            if (attribute.equals(CHECK_FIELD)) {
                this.addCheckBox(field);
                continue;
            }
            if (attribute.equals(STATIC_TEXT)) {
                this.addText(field);
                continue;
            }
            if (attribute.equals(TITLE_FIELD)) {
                this.addTitle(field);
                continue;
            }
            if (attribute.equals(SEARCH_FIELD)) {
                this.addSearch(field);
                continue;
            }
            if (attribute.equals(MULTIPLE_FILE_FIELD)) {
                this.addMultipleFileField(field);
                continue;
            }
            if (attribute.equals("file")) {
                this.addFileField(field);
                continue;
            }
            if (!attribute.equals(DIR_FIELD)) continue;
            this.addDirectoryField(field);
        }
        this.eventsActivated = true;
    }

    private List<ValidatorContainer> analyzeValidator(IXMLElement specElement) {
        ArrayList<ValidatorContainer> result = null;
        Vector<IXMLElement> validatorsElem = specElement.getChildrenNamed(VALIDATOR);
        if (validatorsElem != null && validatorsElem.size() > 0) {
            int vsize = validatorsElem.size();
            result = new ArrayList<ValidatorContainer>(vsize);
            for (int i = 0; i < vsize; ++i) {
                IXMLElement element2 = validatorsElem.get(i);
                String validator = element2.getAttribute(CLASS);
                String message = this.getText(element2);
                HashMap<String, String> validateParamMap = new HashMap<String, String>();
                Vector<IXMLElement> validateParams = element2.getChildrenNamed(RULE_PARAM);
                if (validateParams != null && validateParams.size() > 0) {
                    for (IXMLElement element2 : validateParams) {
                        String paramName = element2.getAttribute("name");
                        String paramValue = element2.getAttribute("value");
                        validateParamMap.put(paramName, paramValue);
                    }
                }
                result.add(new ValidatorContainer(validator, message, validateParamMap));
            }
        }
        return result;
    }

    private void addDirectoryField(IXMLElement field) {
        int size;
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String variable = field.getAttribute("variable");
        if (variable == null || variable.length() == 0) {
            return;
        }
        boolean allowEmptyValue = false;
        boolean mustExist = true;
        boolean create = true;
        IXMLElement element = field.getFirstChildNamed(SPEC);
        if (element == null) {
            Debug.trace("Error: no spec element defined in file field");
            return;
        }
        JLabel label = new JLabel(this.getText(element));
        String set = element.getAttribute(SET);
        if (set == null) {
            set = this.idata.getVariable(variable);
            if (set == null) {
                set = "";
            }
        } else if (set != null && !"".equals(set)) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            set = vs.substitute(set, null);
            if (this.idata.getVariable(variable) == null || "".equals(this.idata.getVariable(variable))) {
                this.idata.setVariable(variable, set);
            }
        }
        try {
            size = Integer.parseInt(element.getAttribute("size"));
        }
        catch (Throwable exception) {
            size = 1;
        }
        allowEmptyValue = Boolean.parseBoolean(element.getAttribute("allowEmptyValue", FALSE));
        mustExist = Boolean.parseBoolean(element.getAttribute("mustExist", TRUE));
        create = Boolean.parseBoolean(element.getAttribute("create", FALSE));
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(constraints);
        labelUiElement.setComponent(label);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        this.elements.add(labelUiElement);
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        DirInputField fileInput = new DirInputField((IzPanel)this, this.idata, true, set, size, validatorConfig, mustExist, create);
        fileInput.setAllowEmptyInput(allowEmptyValue);
        UIElement dirUiElement = new UIElement();
        dirUiElement.setType(UIElementType.DIRECTORY);
        dirUiElement.setConstraints(constraints2);
        dirUiElement.setComponent(fileInput);
        dirUiElement.setForPacks(forPacks);
        dirUiElement.setForOs(forOs);
        dirUiElement.setAssociatedVariable(variable);
        this.elements.add(dirUiElement);
    }

    private void addMultipleFileField(IXMLElement field) {
        String prefY;
        String prefX;
        int size;
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String filter = null;
        String filterdesc = null;
        String variable = field.getAttribute("variable");
        if (variable == null || variable.length() == 0) {
            return;
        }
        boolean allowEmptyValue = false;
        boolean createMultipleVariables = false;
        int preferredX = 200;
        int preferredY = 200;
        int visibleRows = 10;
        IXMLElement element = field.getFirstChildNamed(SPEC);
        if (element == null) {
            Debug.trace("Error: no spec element defined in multi file field");
            return;
        }
        String labelText = this.getText(element);
        String set = element.getAttribute(SET);
        if (set == null) {
            set = this.idata.getVariable(variable);
            if (set == null) {
                set = "";
            }
        } else if (set != null && !"".equals(set)) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            set = vs.substitute(set, null);
        }
        try {
            size = Integer.parseInt(element.getAttribute("size"));
        }
        catch (Throwable exception) {
            size = 1;
        }
        filter = element.getAttribute("fileext");
        if (filter == null) {
            filter = "";
        }
        if ((filterdesc = element.getAttribute("fileextdesc")) == null) {
            filterdesc = "";
        }
        filterdesc = this.langpack.getString(filterdesc);
        String visRows = element.getAttribute("visibleRows");
        if (visRows != null) {
            try {
                visibleRows = Integer.parseInt(visRows);
            }
            catch (Exception e) {
                Debug.error("Illegal value for visibleRows found.");
            }
        }
        if ((prefX = element.getAttribute("prefX")) != null) {
            try {
                preferredX = Integer.parseInt(prefX);
            }
            catch (Exception e) {
                Debug.error("Illegal value for prefX found.");
            }
        }
        if ((prefY = element.getAttribute("prefY")) != null) {
            try {
                preferredY = Integer.parseInt(prefY);
            }
            catch (Exception e) {
                Debug.error("Illegal value for prefY found.");
            }
        }
        createMultipleVariables = Boolean.parseBoolean(element.getAttribute("multipleVariables", FALSE));
        allowEmptyValue = Boolean.parseBoolean(element.getAttribute("allowEmptyValue", FALSE));
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        MultipleFileInputField fileInputField = new MultipleFileInputField(this.parentFrame, this.idata, false, set, size, validatorConfig, filter, filterdesc, createMultipleVariables, visibleRows, preferredX, preferredY, labelText);
        fileInputField.setAllowEmptyInput(allowEmptyValue);
        UIElement fileUiElement = new UIElement();
        fileUiElement.setType(UIElementType.MULTIPLE_FILE);
        fileUiElement.setConstraints(constraints2);
        fileUiElement.setComponent(fileInputField);
        fileUiElement.setForPacks(forPacks);
        fileUiElement.setForOs(forOs);
        fileUiElement.setAssociatedVariable(variable);
        this.elements.add(fileUiElement);
    }

    private void addFileField(IXMLElement field) {
        int size;
        Vector<IXMLElement> forPacks = field.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = field.getChildrenNamed(OS);
        String filter = null;
        String filterdesc = null;
        String variable = field.getAttribute("variable");
        if (variable == null || variable.length() == 0) {
            return;
        }
        boolean allowEmptyValue = false;
        IXMLElement element = field.getFirstChildNamed(SPEC);
        if (element == null) {
            Debug.trace("Error: no spec element defined in file field");
            return;
        }
        JLabel label = new JLabel(this.getText(element));
        String set = element.getAttribute(SET);
        if (set == null) {
            set = this.idata.getVariable(variable);
            if (set == null) {
                set = "";
            }
        } else if (set != null && !"".equals(set)) {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            set = vs.substitute(set, null);
            if (this.idata.getVariable(variable) != null && !"".equals(this.idata.getVariable(variable))) {
                this.idata.setVariable(variable, set);
            }
        }
        try {
            size = Integer.parseInt(element.getAttribute("size"));
        }
        catch (Throwable exception) {
            size = 1;
        }
        filter = element.getAttribute("fileext");
        if (filter == null) {
            filter = "";
        }
        if ((filterdesc = element.getAttribute("fileextdesc")) == null) {
            filterdesc = "";
        }
        filterdesc = this.idata.langpack.getString(filterdesc);
        allowEmptyValue = Boolean.parseBoolean(element.getAttribute("allowEmptyValue", FALSE));
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(field);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(constraints);
        labelUiElement.setComponent(label);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        this.elements.add(labelUiElement);
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        FileInputField fileInputField = new FileInputField(this, this.idata, false, set, size, validatorConfig, filter, filterdesc);
        fileInputField.setAllowEmptyInput(allowEmptyValue);
        UIElement fileUiElement = new UIElement();
        fileUiElement.setType(UIElementType.FILE);
        fileUiElement.setConstraints(constraints2);
        fileUiElement.setComponent(fileInputField);
        fileUiElement.setForPacks(forPacks);
        fileUiElement.setForOs(forOs);
        fileUiElement.setAssociatedVariable(variable);
        this.elements.add(fileUiElement);
    }

    protected void updateUIElements() {
        boolean updated = false;
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        for (UIElement element : this.elements) {
            FileInputField fileInput;
            JComponent textf;
            if (!element.hasVariableAssignment()) continue;
            String variable = element.getAssociatedVariable();
            String value = this.idata.getVariable(variable);
            Debug.trace("updateUIElements() variable=" + variable + " value=" + value + "\n");
            if (element.getType() == UIElementType.RADIOBUTTON) {
                JRadioButton choice = (JRadioButton)element.getComponent();
                if (value == null) continue;
                if (value.equals(element.getTrueValue())) {
                    choice.setSelected(true);
                } else {
                    choice.setSelected(false);
                }
            } else if (element.getType() == UIElementType.TEXT) {
                textf = (TextInputField)element.getComponent();
                if (value == null) {
                    value = ((TextInputField)textf).getText();
                }
                ((TextInputField)textf).setText(vs.substitute(value, null));
            } else if (element.getType() == UIElementType.PASSWORD) {
                textf = (JTextComponent)element.getComponent().getComponent(0);
                if (value == null) {
                    value = ((JTextComponent)textf).getText();
                }
                ((JTextComponent)textf).setText(vs.substitute(value, null));
            } else if (element.getType() == UIElementType.RULE) {
                RuleInputField rulef = (RuleInputField)element.getComponent();
                if (value == null) {
                    value = rulef.getText();
                }
            } else if (element.getType() == UIElementType.MULTIPLE_FILE) {
                MultipleFileInputField multifile = (MultipleFileInputField)element.getComponent();
                if (value != null) {
                    multifile.clearFiles();
                    if (multifile.isCreateMultipleVariables()) {
                        multifile.addFile(value);
                        String basevariable = element.getAssociatedVariable();
                        int index = 1;
                        while (value != null) {
                            StringBuffer builder = new StringBuffer(basevariable);
                            builder.append("_");
                            builder.append(index++);
                            value = this.idata.getVariable(builder.toString());
                            if (value == null) continue;
                            multifile.addFile(value);
                        }
                    } else {
                        String[] files;
                        for (String file : files = value.split(";")) {
                            multifile.addFile(file);
                        }
                    }
                }
            } else if (element.getType() == UIElementType.FILE) {
                fileInput = (FileInputField)element.getComponent();
                if (value != null) {
                    fileInput.setFile(value);
                }
            } else if (element.getType() == UIElementType.DIRECTORY) {
                fileInput = (FileInputField)element.getComponent();
                if (value != null) {
                    fileInput.setFile(value);
                }
            }
            updated = true;
        }
        if (updated) {
            super.invalidate();
        }
    }

    @Override
    public boolean isValidated() {
        return this.readInput();
    }

    @Override
    public void panelActivate() {
        this.init();
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parentFrame.skipPanel();
        }
        this.updateUIElements();
        Vector<IXMLElement> forPacks = this.spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forUnselectedPacks = this.spec.getChildrenNamed(UNSELECTEDPACKS);
        Vector<IXMLElement> forOs = this.spec.getChildrenNamed(OS);
        if (!(this.itemRequiredFor(forPacks) && this.itemRequiredForUnselected(forUnselectedPacks) && this.itemRequiredForOs(forOs))) {
            this.parentFrame.skipPanel();
            return;
        }
        if (!this.haveSpec) {
            this.parentFrame.skipPanel();
            return;
        }
        this.buildUI();
        this.setSize(this.getMaximumSize().width, this.getMaximumSize().height);
        this.validate();
        if (this.packsDefined) {
            this.parentFrame.lockPrevButton();
        }
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (int i = 0; i < this.entries.size(); ++i) {
            TextValuePair pair = this.entries.elementAt(i);
            String key = pair.toString();
            entryMap.put(key, this.idata.getVariable(key));
        }
        new UserInputPanelAutomationHelper(entryMap).makeXMLData(this.idata, panelRoot);
    }

    private void buildUI() {
        for (UIElement element : this.elements) {
            if (this.itemRequiredFor(element.getForPacks()) && this.itemRequiredForOs(element.getForOs())) {
                if (element.isDisplayed()) continue;
                element.setDisplayed(true);
                this.panel.add((Component)element.getComponent(), element.getConstraints());
                continue;
            }
            if (!element.isDisplayed()) continue;
            element.setDisplayed(false);
            this.panel.remove(element.getComponent());
        }
        JScrollPane scroller = new JScrollPane(this.panel);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        scroller.setViewportBorder(emptyBorder);
        scroller.getVerticalScrollBar().setBorder(emptyBorder);
        scroller.getHorizontalScrollBar().setBorder(emptyBorder);
        this.add((Component)scroller, "Center");
    }

    private boolean readInput() {
        boolean success = true;
        this.passwordGroupsRead.clear();
        for (UIElement element : this.elements) {
            if (!element.isDisplayed()) continue;
            if (element.getType() == UIElementType.RULE) {
                success = this.readRuleField(element);
            } else if (element.getType() == UIElementType.PASSWORD) {
                success = this.readPasswordField(element);
            } else if (element.getType() == UIElementType.TEXT) {
                success = this.readTextField(element);
            } else if (element.getType() == UIElementType.COMBOBOX) {
                success = this.readComboBox(element);
            } else if (element.getType() == UIElementType.RADIOBUTTON) {
                success = this.readRadioButton(element);
            } else if (element.getType() == UIElementType.CHECKBOX) {
                success = this.readCheckBox(element);
            } else if (element.getType() == UIElementType.SEARCH) {
                success = this.readSearch(element);
            } else if (element.getType() == UIElementType.MULTIPLE_FILE) {
                success = this.readMultipleFileField(element);
            } else if (element.getType() == UIElementType.FILE) {
                success = this.readFileField(element);
            } else if (element.getType() == UIElementType.DIRECTORY) {
                success = this.readDirectoryField(element);
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    private boolean readDirectoryField(UIElement field) {
        boolean result;
        block4: {
            result = false;
            try {
                FileInputField input = (FileInputField)field.getComponent();
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = "";
                    File inputFile = input.getSelectedFile();
                    if (inputFile != null && !inputFile.getName().equals("")) {
                        value = input.getSelectedFile().getAbsolutePath();
                    }
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block4;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean readFileField(UIElement field) {
        boolean result;
        block4: {
            result = false;
            try {
                FileInputField input = (FileInputField)field.getComponent();
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    String value = "";
                    File inputFile = input.getSelectedFile();
                    if (inputFile != null && !inputFile.getName().equals("")) {
                        value = input.getSelectedFile().getAbsolutePath();
                    }
                    this.idata.setVariable(field.getAssociatedVariable(), value);
                    this.entries.add(new TextValuePair(field.getAssociatedVariable(), value));
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block4;
                Debug.trace(e);
            }
        }
        return result;
    }

    private boolean readMultipleFileField(UIElement field) {
        boolean result;
        block8: {
            result = false;
            try {
                MultipleFileInputField input = (MultipleFileInputField)field.getComponent();
                boolean bl = result = !this.validating || input.validateField();
                if (result) {
                    List<String> files = input.getSelectedFiles();
                    String variable = field.getAssociatedVariable();
                    if (input.isCreateMultipleVariables()) {
                        int index = 0;
                        for (String file : files) {
                            StringBuffer indexedVariableName = new StringBuffer(variable);
                            if (index > 0) {
                                indexedVariableName.append("_");
                                indexedVariableName.append(index);
                            }
                            ++index;
                            this.idata.setVariable(indexedVariableName.toString(), file);
                            this.entries.add(new TextValuePair(indexedVariableName.toString(), file));
                        }
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        for (String file : files) {
                            buffer.append(file);
                            buffer.append(";");
                        }
                        this.idata.setVariable(variable, buffer.toString());
                        this.entries.add(new TextValuePair(variable, buffer.toString()));
                    }
                }
            }
            catch (Exception e) {
                if (!Debug.stackTracing()) break block8;
                Debug.trace(e);
            }
        }
        return result;
    }

    private void readSpec() throws Exception {
        InputStream input = null;
        String instance = Integer.toString(this.instanceNumber);
        String panelid = null;
        Panel p = this.getMetadata();
        if (p != null) {
            panelid = p.getPanelid();
        }
        try {
            input = this.parentFrame.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveSpec = false;
            return;
        }
        if (input == null) {
            this.haveSpec = false;
            return;
        }
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(input);
        if (data.hasChildren()) {
            Vector<IXMLElement> specElements = data.getChildrenNamed(NODE_ID);
            for (int i = 0; i < specElements.size(); ++i) {
                data = specElements.elementAt(i);
                String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
                String panelattribute = data.getAttribute("id");
                if ((attribute == null || !instance.equals(attribute)) && (panelattribute == null || panelid == null || !panelid.equals(panelattribute))) continue;
                this.spec = data;
                input.close();
                this.haveSpec = true;
                return;
            }
            this.haveSpec = false;
            return;
        }
        this.haveSpec = false;
    }

    private void addTitle(IXMLElement spec) {
        String title = this.getText(spec);
        boolean italic = this.getBoolean(spec, ITALICS, false);
        boolean bold = this.getBoolean(spec, BOLD, false);
        float multiplier = this.getFloat(spec, "size", 2.0f);
        int justify = this.getAlignment(spec);
        String icon = this.getIconName(spec);
        if (title != null) {
            JLabel label = null;
            ImageIcon imgicon = null;
            try {
                imgicon = this.parent.icons.getImageIcon(icon);
                label = LabelFactory.create(title, imgicon, 11, true);
            }
            catch (Exception e) {
                Debug.trace("Icon " + icon + " not found in icon list. " + e.getMessage());
                label = LabelFactory.create(title);
            }
            Font font = label.getFont();
            float size = font.getSize();
            int style = 0;
            if (bold) {
                ++style;
            }
            if (italic) {
                style += 2;
            }
            font = font.deriveFont(style, size * multiplier);
            label.setFont(font);
            label.setAlignmentX(0.0f);
            TwoColumnConstraints constraints = new TwoColumnConstraints();
            constraints.align = justify;
            constraints.position = 9;
            this.panel.add((Component)label, constraints);
        }
    }

    protected String getIconName(IXMLElement element) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute(ICON_KEY);
        String text = null;
        if (key != null && this.langpack != null) {
            try {
                text = this.langpack.getString(key);
            }
            catch (Throwable exception) {
                text = null;
            }
        }
        return text;
    }

    private void addRuleField(IXMLElement spec) {
        String separator;
        String set;
        String layout;
        JLabel label;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        RuleInputField field = null;
        String validator = null;
        String message = null;
        boolean hasParams = false;
        String paramName = null;
        String paramValue = null;
        HashMap<String, String> validateParamMap = null;
        Vector<IXMLElement> validateParams = null;
        String processor = null;
        int resultFormat = 2;
        if (element != null) {
            label = new JLabel(this.getText(element));
            layout = element.getAttribute(RULE_LAYOUT);
            set = element.getAttribute(SET);
            separator = element.getAttribute(RULE_SEPARATOR);
            String format = element.getAttribute(RULE_RESULT_FORMAT);
            if (format != null) {
                if (format.equals(RULE_PLAIN_STRING)) {
                    resultFormat = 1;
                } else if (format.equals(RULE_DISPLAY_FORMAT)) {
                    resultFormat = 2;
                } else if (format.equals(RULE_SPECIAL_SEPARATOR)) {
                    resultFormat = 3;
                } else if (format.equals(RULE_ENCRYPTED)) {
                    resultFormat = 4;
                }
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        element = spec.getFirstChildNamed(VALIDATOR);
        if (element != null) {
            validator = element.getAttribute(CLASS);
            message = this.getText(element);
            validateParams = element.getChildrenNamed(RULE_PARAM);
            if (validateParams != null && validateParams.size() > 0) {
                hasParams = true;
                if (validateParamMap == null) {
                    validateParamMap = new HashMap<String, String>();
                }
                Iterator<IXMLElement> iterator = validateParams.iterator();
                while (iterator.hasNext()) {
                    IXMLElement validateParam;
                    element = validateParam = iterator.next();
                    paramName = element.getAttribute("name");
                    paramValue = element.getAttribute("value");
                    validateParamMap.put(paramName, paramValue);
                }
            }
        }
        if ((element = spec.getFirstChildNamed(PROCESSOR)) != null) {
            processor = element.getAttribute(CLASS);
        }
        field = hasParams ? new RuleInputField(layout, set, separator, validator, validateParamMap, processor, resultFormat, this.getToolkit(), this.idata) : new RuleInputField(layout, set, separator, validator, processor, resultFormat, this.getToolkit(), this.idata);
        field.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(6, 5, 6, 0)));
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(constraints);
        labelUiElement.setComponent(label);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        this.elements.add(labelUiElement);
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        UIElement ruleField = new UIElement();
        ruleField.setType(UIElementType.RULE);
        ruleField.setConstraints(constraints2);
        ruleField.setComponent(field);
        ruleField.setForPacks(forPacks);
        ruleField.setForOs(forOs);
        ruleField.setAssociatedVariable(variable);
        ruleField.setMessage(message);
        this.elements.add(ruleField);
    }

    private boolean readRuleField(UIElement field) {
        boolean success;
        RuleInputField ruleField = null;
        String variable = null;
        String message = null;
        try {
            ruleField = (RuleInputField)field.getComponent();
            variable = field.getAssociatedVariable();
            message = field.getMessage();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || ruleField == null) {
            return true;
        }
        boolean bl = success = !this.validating || ruleField.validateContents();
        if (!success) {
            this.showWarningMessageDialog(this.parentFrame, message);
            return false;
        }
        this.idata.setVariable(variable, ruleField.getText());
        this.entries.add(new TextValuePair(variable, ruleField.getText()));
        return true;
    }

    private void addTextField(IXMLElement spec) {
        int size;
        String set;
        JLabel label;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        int rows = 1;
        Object validateParamMap = null;
        Object validateParams = null;
        String message = null;
        String variable = spec.getAttribute("variable");
        if (variable == null || variable.length() == 0) {
            return;
        }
        if (element != null) {
            label = new JLabel(this.getText(element));
            set = element.getAttribute(SET);
            if (set == null) {
                set = this.idata.getVariable(variable);
                if (set == null) {
                    set = "";
                }
            } else if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                set = vs.substitute(set, null);
            }
            try {
                size = Integer.parseInt(element.getAttribute("size"));
            }
            catch (Throwable exception) {
                size = 1;
            }
            if (element.getAttribute(TEXT_ROWS) != null) {
                try {
                    rows = Integer.parseInt(element.getAttribute(TEXT_ROWS));
                }
                catch (Throwable exception) {
                    rows = 1;
                }
            }
        } else {
            Debug.trace("No specification element, returning.");
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        List<ValidatorContainer> validatorConfig = this.analyzeValidator(spec);
        TextInputField inputField = new TextInputField(this, set, size, rows, validatorConfig, this.idata);
        inputField.addFocusListener(this);
        inputField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(6, 5, 6, 0)));
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(constraints);
        labelUiElement.setComponent(label);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        this.elements.add(labelUiElement);
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        UIElement textUiElement = new UIElement();
        textUiElement.setType(UIElementType.TEXT);
        textUiElement.setConstraints(constraints2);
        textUiElement.setComponent(inputField);
        textUiElement.setForPacks(forPacks);
        textUiElement.setForOs(forOs);
        textUiElement.setAssociatedVariable(variable);
        textUiElement.setMessage(message);
        this.elements.add(textUiElement);
    }

    private boolean readTextField(UIElement field) {
        boolean success;
        TextInputField textField = null;
        String variable = null;
        String value = null;
        String message = null;
        try {
            textField = (TextInputField)field.getComponent();
            variable = field.getAssociatedVariable();
            message = field.getMessage();
            value = textField.getText();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        Debug.trace("Validating text field");
        boolean bl = success = !this.validating || textField.validateContents();
        if (!success) {
            Debug.trace("Validation did not pass, message: " + message);
            if (message == null) {
                message = "Text entered did not pass validation.";
            }
            return false;
        }
        Debug.trace("Field validated");
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addComboBox(IXMLElement spec) {
        JLabel label;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        TextValuePair listItem = null;
        JComboBox<TextValuePair> field = new JComboBox<TextValuePair>();
        field.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(6, 5, 6, 0)));
        String causesValidataion = spec.getAttribute(REVALIDATE);
        if (causesValidataion != null && causesValidataion.equals("yes")) {
            field.addItemListener(this);
        }
        boolean userinput = false;
        if (element != null) {
            int size = 0;
            try {
                size = Integer.parseInt(element.getAttribute("size"));
            }
            catch (Throwable exception) {
                size = 20;
            }
            Dimension dimen = new Dimension(size * 10, 35);
            field.setSize(dimen);
            field.setPreferredSize(dimen);
            label = new JLabel(this.getText(element));
            Vector<IXMLElement> choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            String currentvariablevalue = this.idata.getVariable(variable);
            if (currentvariablevalue != null) {
                userinput = true;
            }
            for (int i = 0; i < choices.size(); ++i) {
                VariableSubstitutor vs;
                String set;
                String processorClass = choices.elementAt(i).getAttribute(PROCESSOR);
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).newInstance()).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    set = choices.elementAt(i).getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        vs = new VariableSubstitutor(this.idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        listItem = new TextValuePair(token, token);
                        field.addItem(listItem);
                        if (set.equals(token)) {
                            field.setSelectedIndex(field.getItemCount() - 1);
                        }
                        ++counter;
                    }
                    continue;
                }
                String value = choices.elementAt(i).getAttribute("value");
                listItem = new TextValuePair(this.getText(choices.elementAt(i)), value);
                field.addItem(listItem);
                if (userinput) {
                    if (value == null || value.length() <= 0 || !currentvariablevalue.equals(value)) continue;
                    field.setSelectedIndex(i);
                    continue;
                }
                set = choices.elementAt(i).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                field.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(constraints);
        labelUiElement.setComponent(label);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        this.elements.add(labelUiElement);
        JPanel tmppanel = new JPanel();
        tmppanel.add(field);
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        UIElement comboUiElement = new UIElement();
        comboUiElement.setType(UIElementType.COMBOBOX);
        comboUiElement.setConstraints(constraints2);
        comboUiElement.setComponent(tmppanel);
        comboUiElement.setForPacks(forPacks);
        comboUiElement.setForOs(forOs);
        comboUiElement.setAssociatedVariable(variable);
        this.elements.add(comboUiElement);
    }

    private boolean readComboBox(UIElement field) {
        String value;
        String variable;
        try {
            variable = field.getAssociatedVariable();
            JComboBox comboBox = (JComboBox)((JPanel)field.getComponent()).getComponent(0);
            value = ((TextValuePair)comboBox.getSelectedItem()).getValue();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addRadioButton(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        String variable = spec.getAttribute("variable");
        String value = null;
        IXMLElement element = null;
        ButtonGroup group = new ButtonGroup();
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.indent = true;
        constraints.stretch = true;
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        element = spec.getFirstChildNamed(SPEC);
        if (element != null) {
            Vector<IXMLElement> choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                JRadioButton choice = new JRadioButton();
                choice.setText(this.getText(choices.elementAt(i)));
                String causesValidataion = choices.elementAt(i).getAttribute(REVALIDATE);
                if (causesValidataion != null && causesValidataion.equals("yes")) {
                    choice.addActionListener(this);
                }
                value = choices.elementAt(i).getAttribute("value");
                group.add(choice);
                String set = choices.elementAt(i).getAttribute(SET);
                if (this.idata.getVariable(variable) == null && set != null) {
                    this.idata.setVariable(variable, value);
                }
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    if (set.equals(TRUE)) {
                        choice.setSelected(true);
                    }
                }
                this.buttonGroups.add(group);
                RadioButtonUIElement radioUiElement = new RadioButtonUIElement();
                radioUiElement.setType(UIElementType.RADIOBUTTON);
                radioUiElement.setConstraints(constraints);
                radioUiElement.setComponent(choice);
                radioUiElement.setForPacks(forPacks);
                radioUiElement.setForOs(forOs);
                radioUiElement.setButtonGroup(group);
                radioUiElement.setAssociatedVariable(variable);
                radioUiElement.setTrueValue(value);
                this.elements.add(radioUiElement);
            }
        }
    }

    private boolean readRadioButton(UIElement field) {
        String variable = null;
        String value = null;
        JRadioButton button = null;
        try {
            button = (JRadioButton)field.getComponent();
            if (!button.isSelected()) {
                return true;
            }
            variable = field.getAssociatedVariable();
            value = field.getTrueValue();
        }
        catch (Throwable exception) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addPasswordField(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        String variable = spec.getAttribute("variable");
        String processor = null;
        IXMLElement element = null;
        PasswordGroup group = null;
        int size = 0;
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        List<ValidatorContainer> validatorsList = this.analyzeValidator(spec);
        if (validatorsList == null) {
            validatorsList = new ArrayList<ValidatorContainer>();
        }
        if ((element = spec.getFirstChildNamed(PROCESSOR)) != null) {
            processor = element.getAttribute(CLASS);
        }
        group = new PasswordGroup(this.idata, validatorsList, processor);
        element = spec.getFirstChildNamed(SPEC);
        if (element != null) {
            Vector<IXMLElement> inputs = element.getChildrenNamed(PWD_INPUT);
            if (inputs == null) {
                return;
            }
            for (int i = 0; i < inputs.size(); ++i) {
                IXMLElement fieldSpec = inputs.elementAt(i);
                String set = fieldSpec.getAttribute(SET);
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                JLabel label = new JLabel(this.getText(fieldSpec));
                try {
                    size = Integer.parseInt(fieldSpec.getAttribute("size"));
                }
                catch (Throwable exception) {
                    size = 1;
                }
                JPanel panelPass = new JPanel();
                JPasswordField field = new JPasswordField(set, size);
                field.setCaretPosition(0);
                panelPass.add(field);
                TwoColumnConstraints constraints = new TwoColumnConstraints();
                constraints.position = 15;
                UIElement labelUiElement = new UIElement();
                labelUiElement.setType(UIElementType.LABEL);
                labelUiElement.setConstraints(constraints);
                labelUiElement.setComponent(label);
                labelUiElement.setForPacks(forPacks);
                labelUiElement.setForOs(forOs);
                this.elements.add(labelUiElement);
                TwoColumnConstraints constraints2 = new TwoColumnConstraints();
                constraints2.position = 26;
                PasswordUIElement passwordUiElement = new PasswordUIElement();
                passwordUiElement.setType(UIElementType.PASSWORD);
                passwordUiElement.setConstraints(constraints2);
                passwordUiElement.setComponent(panelPass);
                passwordUiElement.setForPacks(forPacks);
                passwordUiElement.setForOs(forOs);
                passwordUiElement.setPasswordGroup(group);
                passwordUiElement.setAssociatedVariable(variable);
                this.elements.add(passwordUiElement);
                group.addField(field);
            }
        }
        this.passwordGroups.add(group);
    }

    private boolean readPasswordField(UIElement field) {
        boolean success;
        PasswordUIElement pwdField = (PasswordUIElement)field;
        PasswordGroup group = null;
        String variable = null;
        try {
            group = pwdField.getPasswordGroup();
            variable = field.getAssociatedVariable();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || this.passwordGroupsRead.contains(group)) {
            return true;
        }
        this.passwordGroups.add(group);
        int size = group.validatorSize();
        boolean bl = success = !this.validating || size < 1;
        if (!success) {
            for (int i = 0; i < size; ++i) {
                success = group.validateContents(i);
                if (success) continue;
                JOptionPane.showMessageDialog(this.parentFrame, group.getValidatorMessage(i), this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
                break;
            }
        }
        if (success) {
            this.idata.setVariable(variable, group.getPassword());
            this.entries.add(new TextValuePair(variable, group.getPassword()));
        }
        return success;
    }

    private void addCheckBox(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        String label = "";
        String set = null;
        String trueValue = null;
        String falseValue = null;
        String variable = spec.getAttribute("variable");
        String causesValidataion = null;
        IXMLElement detail = spec.getFirstChildNamed(SPEC);
        if (variable == null) {
            return;
        }
        if (detail != null) {
            label = this.getText(detail);
            set = detail.getAttribute(SET);
            trueValue = detail.getAttribute(TRUE);
            falseValue = detail.getAttribute(FALSE);
            causesValidataion = detail.getAttribute(REVALIDATE);
            String value = this.idata.getVariable(variable);
            Debug.trace("check: value: " + value + ", set: " + set);
            if (value != null && value.equals(trueValue)) {
                set = TRUE;
            }
        }
        JCheckBox checkbox = new JCheckBox(label);
        if (causesValidataion != null && causesValidataion.equals("yes")) {
            checkbox.addActionListener(this);
        }
        if (set != null) {
            if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                set = vs.substitute(set, null);
            }
            if (set.equals(FALSE)) {
                checkbox.setSelected(false);
            }
            if (set.equals(TRUE)) {
                checkbox.setSelected(true);
            }
        }
        IXMLElement element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        constraints.indent = true;
        UIElement checkboxUiElement = new UIElement();
        checkboxUiElement.setType(UIElementType.CHECKBOX);
        checkboxUiElement.setConstraints(constraints);
        checkboxUiElement.setComponent(checkbox);
        checkboxUiElement.setForPacks(forPacks);
        checkboxUiElement.setForOs(forOs);
        checkboxUiElement.setTrueValue(trueValue);
        checkboxUiElement.setFalseValue(falseValue);
        checkboxUiElement.setAssociatedVariable(variable);
        this.elements.add(checkboxUiElement);
    }

    private boolean readCheckBox(UIElement field) {
        String variable = null;
        String trueValue = null;
        String falseValue = null;
        JCheckBox box = null;
        try {
            box = (JCheckBox)field.getComponent();
            variable = field.getAssociatedVariable();
            trueValue = field.getTrueValue();
            if (trueValue == null) {
                trueValue = "";
            }
            if ((falseValue = field.getFalseValue()) == null) {
                falseValue = "";
            }
        }
        catch (Throwable exception) {
            Debug.trace("readCheckBox(): failed: " + exception);
            return true;
        }
        if (box.isSelected()) {
            Debug.trace("readCheckBox(): selected, setting " + variable + " to " + trueValue);
            this.idata.setVariable(variable, trueValue);
            this.entries.add(new TextValuePair(variable, trueValue));
        } else {
            Debug.trace("readCheckBox(): not selected, setting " + variable + " to " + falseValue);
            this.idata.setVariable(variable, falseValue);
            this.entries.add(new TextValuePair(variable, falseValue));
        }
        return true;
    }

    private void addSearch(IXMLElement spec) {
        boolean showAutodetect;
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        IXMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute("variable");
        String filename = null;
        String check_filename = null;
        int search_type = 0;
        int result_type = 0;
        JComboBox<String> combobox = new JComboBox<String>();
        JLabel label = null;
        combobox.setEditable(true);
        if (element != null) {
            String result_type_str;
            label = new JLabel(this.getText(element));
            search_type = 2;
            String search_type_str = element.getAttribute("type");
            if (search_type_str != null) {
                if (search_type_str.equals("file")) {
                    search_type = 2;
                } else if (search_type_str.equals(SEARCH_DIRECTORY)) {
                    search_type = 1;
                }
            }
            if ((result_type_str = element.getAttribute(SEARCH_RESULT)) == null) {
                return;
            }
            if (result_type_str.equals("file")) {
                result_type = 2;
            } else if (result_type_str.equals(SEARCH_DIRECTORY)) {
                result_type = 1;
            } else if (result_type_str.equals(SEARCH_PARENTDIR)) {
                result_type = 3;
            } else {
                return;
            }
            filename = element.getAttribute(SEARCH_FILENAME);
            check_filename = element.getAttribute(SEARCH_CHECKFILENAME);
            Vector<IXMLElement> choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                IXMLElement choice_el = choices.elementAt(i);
                if (!OsConstraint.oneMatchesCurrentSystem(choice_el)) continue;
                String value = choice_el.getAttribute("value");
                combobox.addItem(value);
                String set = choices.elementAt(i).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                combobox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs);
        TwoColumnConstraints westconstraint1 = new TwoColumnConstraints();
        westconstraint1.position = 15;
        UIElement labelUiElement = new UIElement();
        labelUiElement.setType(UIElementType.LABEL);
        labelUiElement.setConstraints(westconstraint1);
        labelUiElement.setComponent(label);
        labelUiElement.setForPacks(forPacks);
        labelUiElement.setForOs(forOs);
        this.elements.add(labelUiElement);
        TwoColumnConstraints eastconstraint1 = new TwoColumnConstraints();
        eastconstraint1.position = 26;
        StringBuffer tooltiptext = new StringBuffer();
        if (filename != null && filename.length() > 0) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location"), new Object[]{new String[]{filename}}));
        }
        boolean bl = showAutodetect = check_filename != null && check_filename.length() > 0;
        if (showAutodetect) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location.checkedfile"), new Object[]{new String[]{check_filename}}));
        }
        if (tooltiptext.length() > 0) {
            combobox.setToolTipText(tooltiptext.toString());
        }
        JPanel comboPanel = new JPanel();
        comboPanel.add(combobox);
        UIElement searchUiElement = new UIElement();
        searchUiElement.setType(UIElementType.SEARCH);
        searchUiElement.setConstraints(eastconstraint1);
        searchUiElement.setComponent(comboPanel);
        searchUiElement.setForPacks(forPacks);
        searchUiElement.setForOs(forOs);
        searchUiElement.setAssociatedVariable(variable);
        this.elements.add(searchUiElement);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(3));
        JButton autodetectButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect"), this.idata.buttonsHColor);
        autodetectButton.setVisible(showAutodetect);
        autodetectButton.setToolTipText(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect.tooltip"));
        buttonPanel.add(autodetectButton);
        JButton browseButton = ButtonFactory.createButton(this.parentFrame.langpack.getString("UserInputPanel.search.browse"), this.idata.buttonsHColor);
        buttonPanel.add(browseButton);
        buttonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(6, 5, 6, 0)));
        TwoColumnConstraints eastonlyconstraint = new TwoColumnConstraints();
        eastonlyconstraint.position = 27;
        UIElement searchbuttonUiElement = new UIElement();
        searchbuttonUiElement.setType(UIElementType.SEARCHBUTTON);
        searchbuttonUiElement.setConstraints(eastonlyconstraint);
        searchbuttonUiElement.setComponent(buttonPanel);
        searchbuttonUiElement.setForPacks(forPacks);
        searchbuttonUiElement.setForOs(forOs);
        this.elements.add(searchbuttonUiElement);
        this.searchFields.add(new SearchField(filename, check_filename, this.parentFrame, combobox, autodetectButton, browseButton, search_type, result_type));
    }

    private boolean readSearch(UIElement field) {
        String variable = null;
        String value = null;
        JComboBox comboBox = null;
        try {
            variable = field.getAssociatedVariable();
            comboBox = (JComboBox)field.getComponent();
            for (int i = 0; i < this.searchFields.size(); ++i) {
                SearchField sf = this.searchFields.elementAt(i);
                if (!sf.belongsTo(comboBox)) continue;
                value = sf.getResult();
                break;
            }
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        this.entries.add(new TextValuePair(variable, value));
        return true;
    }

    private void addText(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        this.addDescription(spec, forPacks, forOs);
    }

    private void addSpace(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        UIElement spaceUiElement = new UIElement();
        spaceUiElement.setType(UIElementType.SPACE);
        spaceUiElement.setConstraints(constraints);
        spaceUiElement.setComponent(panel);
        spaceUiElement.setForPacks(forPacks);
        spaceUiElement.setForOs(forOs);
        this.elements.add(spaceUiElement);
    }

    private void addDivider(IXMLElement spec) {
        Vector<IXMLElement> forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector<IXMLElement> forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        String alignment = spec.getAttribute(ALIGNMENT);
        if (alignment != null) {
            if (alignment.equals(TOP)) {
                panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            }
        } else {
            panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        UIElement dividerUiElement = new UIElement();
        dividerUiElement.setType(UIElementType.DIVIDER);
        dividerUiElement.setConstraints(constraints);
        dividerUiElement.setComponent(panel);
        dividerUiElement.setForPacks(forPacks);
        dividerUiElement.setForOs(forOs);
        this.elements.add(dividerUiElement);
    }

    private void addDescription(IXMLElement spec, Vector<IXMLElement> forPacks, Vector<IXMLElement> forOs) {
        String description;
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        if (spec != null && (description = this.getText(spec)) != null) {
            JTextPane label = new JTextPane();
            label.setEditable(false);
            if (description.startsWith("<html>") && description.endsWith("</html>")) {
                label.setContentType("text/html");
                label.addHyperlinkListener(new HyperlinkHandler());
            }
            label.setText(description);
            label.setBackground(UIManager.getColor("label.backgroud"));
            label.setMargin(new Insets(3, 0, 3, 0));
            label.getPreferredSize();
            UIElement descUiElement = new UIElement();
            descUiElement.setType(UIElementType.DESCRIPTION);
            descUiElement.setConstraints(constraints);
            descUiElement.setComponent(label);
            descUiElement.setForPacks(forPacks);
            descUiElement.setForOs(forOs);
            this.elements.add(descUiElement);
        }
    }

    private boolean getBoolean(IXMLElement element, String attribute, boolean defaultValue) {
        String value;
        boolean result = defaultValue;
        if (attribute != null && attribute.length() > 0 && (value = element.getAttribute(attribute)) != null) {
            if (value.equals(TRUE)) {
                result = true;
            } else if (value.equals(FALSE)) {
                result = false;
            }
        }
        return result;
    }

    private float getFloat(IXMLElement element, String attribute, float defaultValue) {
        float result = defaultValue;
        if (attribute != null && attribute.length() > 0) {
            try {
                result = Float.parseFloat(element.getAttribute(attribute));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private String getText(IXMLElement element) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute("id");
        String text = element.getAttribute(TEXT);
        if (key != null && this.langpack != null) {
            try {
                String langPackText = this.langpack.getString(key);
                if (langPackText != null && !key.equals(langPackText)) {
                    text = langPackText;
                }
            }
            catch (Throwable langPackText) {
                // empty catch block
            }
        }
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        return vs.substitute(text, null);
    }

    private int getAlignment(IXMLElement element) {
        int result = 31;
        String value = element.getAttribute(ALIGNMENT);
        if (value != null) {
            if (value.equals(LEFT)) {
                result = 31;
            } else if (value.equals(CENTER)) {
                result = 35;
            } else if (value.equals(RIGHT)) {
                result = 47;
            }
        }
        return result;
    }

    public boolean itemRequiredForOs(Vector<IXMLElement> os) {
        if (os.size() == 0) {
            return true;
        }
        for (int i = 0; i < os.size(); ++i) {
            String family = os.elementAt(i).getAttribute(FAMILY);
            boolean match = false;
            if ("windows".equals(family)) {
                match = OsVersion.IS_WINDOWS;
            } else if ("mac".equals(family)) {
                match = OsVersion.IS_OSX;
            } else if ("unix".equals(family)) {
                match = OsVersion.IS_UNIX;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean itemRequiredFor(Vector<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean itemRequiredForUnselected(Vector<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = packs.elementAt(k).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return false;
            }
        }
        return true;
    }

    protected void updateVariables() {
        Vector<IXMLElement> variables = this.spec.getChildrenNamed("variable");
        RulesEngine rules = this.parent.getRules();
        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
        for (int i = 0; i < variables.size(); ++i) {
            String conditionid;
            IXMLElement variable = variables.elementAt(i);
            String vname = variable.getAttribute("name");
            String vvalue = variable.getAttribute("value");
            if (vvalue == null && variable.hasChildren()) {
                IXMLElement value = variable.getFirstChildNamed("value");
                vvalue = value.getContent();
            }
            if ((conditionid = variable.getAttribute(ATTRIBUTE_CONDITIONID_NAME)) != null && !rules.isConditionTrue(conditionid, this.idata.getVariables()) || !OsConstraint.oneMatchesCurrentSystem(variable) || vname == null) continue;
            if (vvalue != null) {
                vvalue = vs.substitute(vvalue, null);
                this.idata.setVariable(vname, "");
                vvalue = vs.substitute(vvalue, null);
            }
            this.idata.setVariable(vname, vvalue);
            this.entries.add(new TextValuePair(vname, vvalue));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Debug.trace("Setting validating to false");
        this.validating = false;
        this.updateDialog();
        Debug.trace("Setting validating back to true");
        this.validating = true;
    }

    private void showMessageDialog(InstallerFrame parentFrame, String message, String caption, int messageType) {
        String localizedCaption;
        String localizedMessage = parentFrame.langpack.getString(message);
        if (localizedMessage == null || localizedMessage.trim().length() == 0) {
            localizedMessage = message;
        }
        if ((localizedCaption = parentFrame.langpack.getString(caption)) == null || localizedCaption.trim().length() == 0) {
            localizedCaption = caption;
        }
        JOptionPane.showMessageDialog(parentFrame, localizedMessage, localizedCaption, messageType);
    }

    private void showWarningMessageDialog(InstallerFrame parentFrame, String message) {
        this.showMessageDialog(parentFrame, message, "UserInputPanel.error.caption", 2);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        this.updateDialog();
    }

    private void updateDialog() {
        if (this.eventsActivated) {
            this.eventsActivated = false;
            if (this.isValidated()) {
                this.init();
                this.updateVariables();
                this.updateUIElements();
                this.buildUI();
                this.validate();
                this.repaint();
            }
            this.eventsActivated = true;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateDialog();
    }

    @Override
    public String getSummaryBody() {
        StringBuffer strBody = new StringBuffer("");
        for (UIElement element : this.elements) {
            if (!element.hasVariableAssignment()) continue;
            String variable = element.getAssociatedVariable();
            String value = this.idata.getVariable(variable);
            if (variable.indexOf("pass") > -1) {
                strBody.append(variable).append("=");
                for (int i = 0; i < variable.length(); ++i) {
                    strBody.append("*");
                }
                strBody.append("<br>");
                continue;
            }
            strBody.append(variable).append("=").append(value).append("<br>");
        }
        return strBody.toString();
    }

    private class SearchField
    implements ActionListener {
        public static final int TYPE_DIRECTORY = 1;
        public static final int TYPE_FILE = 2;
        public static final int RESULT_DIRECTORY = 1;
        public static final int RESULT_FILE = 2;
        public static final int RESULT_PARENTDIR = 3;
        private String filename = null;
        private String checkFilename = null;
        private JButton autodetectButton = null;
        private JButton browseButton = null;
        private JComboBox pathComboBox = null;
        private int searchType = 1;
        private int resultType = 1;
        private InstallerFrame parent = null;

        public SearchField(String filename, String checkFilename, InstallerFrame parent, JComboBox combobox, JButton autobutton, JButton browsebutton, int search_type, int result_type) {
            this.filename = filename;
            this.checkFilename = checkFilename;
            this.parent = parent;
            this.autodetectButton = autobutton;
            this.browseButton = browsebutton;
            this.pathComboBox = combobox;
            this.searchType = search_type;
            this.resultType = result_type;
            this.autodetectButton.addActionListener(this);
            this.browseButton.addActionListener(this);
            ((JTextField)this.pathComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkNextButtonState();
                }

                private void checkNextButtonState() {
                    Document doc = ((JTextField)SearchField.this.pathComboBox.getEditor().getEditorComponent()).getDocument();
                    try {
                        if (SearchField.this.pathMatches(doc.getText(0, doc.getLength()))) {
                            SearchField.this.getInstallerFrame().unlockNextButton(false);
                        } else {
                            SearchField.this.getInstallerFrame().lockNextButton();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
            this.autodetect();
        }

        private InstallerFrame getInstallerFrame() {
            return this.parent;
        }

        public boolean belongsTo(JComboBox combobox) {
            return this.pathComboBox == combobox;
        }

        private boolean pathMatches(String path) {
            if (path != null) {
                File file = null;
                file = this.filename == null || this.searchType == 1 ? new File(path) : new File(path, this.filename);
                if (file.exists() && (this.searchType == 1 && file.isDirectory() || this.searchType == 2 && file.isFile())) {
                    if (this.checkFilename == null) {
                        return true;
                    }
                    file = new File(file, this.checkFilename);
                    return file.exists();
                }
            }
            return false;
        }

        public boolean autodetect() {
            String path;
            Vector<String> items = new Vector<String>();
            String selected = (String)this.pathComboBox.getSelectedItem();
            if (selected == null) {
                this.parent.lockNextButton();
                return false;
            }
            boolean found = false;
            for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
                if (!this.pathComboBox.getItemAt(x).equals(selected)) continue;
                found = true;
            }
            if (!found) {
                this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
            }
            VariableSubstitutor vs = new VariableSubstitutor(UserInputPanel.this.idata.getVariables());
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                path = vs.substitute((String)this.pathComboBox.getItemAt(i), null);
                if (path.endsWith("*")) {
                    File[] subdirs;
                    File dir = new File(path = path.substring(0, path.length() - 1));
                    if (!dir.isDirectory()) continue;
                    for (File subdir : subdirs = dir.listFiles()) {
                        String search = subdir.getAbsolutePath();
                        if (!this.pathMatches(search)) continue;
                        items.add(search);
                    }
                    continue;
                }
                if (!this.pathMatches(path)) continue;
                items.add(path);
            }
            items = new Vector(new HashSet(items));
            this.pathComboBox.removeAllItems();
            for (String item : items) {
                String res = vs.substitute(item, "plain");
                this.pathComboBox.addItem(res);
            }
            for (int i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                path = (String)this.pathComboBox.getItemAt(i);
                if (!this.pathMatches(path)) continue;
                this.pathComboBox.setSelectedIndex(i);
                this.parent.unlockNextButton();
                return true;
            }
            if (this.pathMatches((String)this.pathComboBox.getSelectedItem())) {
                this.parent.unlockNextButton();
                return true;
            }
            this.parent.lockNextButton();
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.autodetectButton) {
                if (!this.autodetect()) {
                    UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.autodetect.failed.message", "UserInputPanel.search.autodetect.failed.caption", 2);
                }
            } else if (event.getSource() == this.browseButton) {
                int result;
                JFileChooser chooser = new JFileChooser();
                if (this.resultType != 2) {
                    chooser.setFileSelectionMode(1);
                }
                if ((result = chooser.showOpenDialog(this.parent)) == 0) {
                    File f = chooser.getSelectedFile();
                    this.pathComboBox.setSelectedItem(f.getAbsolutePath());
                    if (this.resultType != 2 && !this.pathMatches(f.getAbsolutePath())) {
                        UserInputPanel.this.showMessageDialog(this.parent, "UserInputPanel.search.wrongselection.message", "UserInputPanel.search.wrongselection.caption", 2);
                    }
                }
            }
        }

        public String getResult() {
            String item = (String)this.pathComboBox.getSelectedItem();
            if (item != null) {
                item = item.trim();
            }
            String path = item;
            File f = new File(item);
            if (!f.isDirectory()) {
                path = f.getParent();
            }
            if (this.resultType == 1) {
                return path;
            }
            if (this.resultType == 2) {
                if (this.filename != null) {
                    return path + File.separatorChar + this.filename;
                }
                return item;
            }
            if (this.resultType == 3) {
                File dir = new File(path);
                return dir.getParent();
            }
            return null;
        }
    }

    private static class TextValuePair {
        private String text = "";
        private String value = "";

        public TextValuePair(String text, String value) {
            this.text = text;
            this.value = value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

