/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ProcessPanelWorker;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import java.io.PrintWriter;
import java.util.Properties;

public class ProcessPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole,
AbstractUIProcessHandler {
    private int noOfJobs = 0;
    private AutomatedInstallData installdata;
    private int currentJob = 0;

    @Override
    public void emitNotification(String message) {
        System.out.println(message);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        System.err.println("[ WARNING: " + title + " ]");
        System.err.println(message);
        return true;
    }

    @Override
    public void emitError(String title, String message) {
        System.err.println("[ ERROR: " + title + " ]");
        System.err.println(message);
    }

    @Override
    public void emitErrorAndBlockNext(String title, String message) {
        System.err.println("[ ERROR: " + title + " ]");
        System.err.println(message);
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, 2);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int default_choice) {
        boolean jo_choices = false;
        if (choices == 37) {
            jo_choices = false;
        } else if (choices == 38) {
            jo_choices = true;
        }
        System.out.println("[ " + title + " ]");
        System.out.println(question);
        int user_choice = this.askQuestion(this.installdata, this.installdata.langpack.getString("consolehelper.askyesnocancel"), 2) - 1;
        if (user_choice == 2) {
            return 45;
        }
        if (user_choice == 0) {
            return 47;
        }
        if (user_choice == -1) {
            return 49;
        }
        if (user_choice == 1) {
            return 49;
        }
        return default_choice;
    }

    @Override
    public void logOutput(String message, boolean stderr) {
        if (stderr) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    @Override
    public void startProcessing(int no_of_processes) {
        System.out.println("[ Starting processing ]");
        this.noOfJobs = no_of_processes;
    }

    @Override
    public void startProcess(String name) {
        ++this.currentJob;
        System.out.println("Starting process " + name + " (" + Integer.toString(this.currentJob) + "/" + Integer.toString(this.noOfJobs) + ")");
    }

    @Override
    public void finishProcess() {
    }

    @Override
    public void finishProcessing(boolean unlockPrev, boolean unlockNext) {
    }

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        this.installdata = installData;
        return false;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        this.installdata = installData;
        return this.runConsole(installData);
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData) {
        this.installdata = installData;
        try {
            ProcessPanelWorker worker = new ProcessPanelWorker(installData, this);
            worker.run();
            System.out.println("");
            if (worker.getResult()) {
                int i;
                do {
                    if ((i = this.askEndOfConsolePanel(installData)) != 1) continue;
                    return true;
                } while (i != 2);
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("The work done by the ProcessPanel failed", e);
        }
    }
}

