/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.LayoutHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PathSelectionPanel
extends JPanel
implements ActionListener,
LayoutConstants {
    private static final long serialVersionUID = 3618700794577105718L;
    private JTextField textField;
    private JButton browseButton;
    private IzPanel parent;
    private InstallData idata;

    public PathSelectionPanel(IzPanel parent, InstallData idata) {
        this.parent = parent;
        this.idata = idata;
        this.createLayout();
    }

    protected void createLayout() {
        LayoutHelper layoutHelper = new LayoutHelper(this);
        layoutHelper.startLayout(new IzPanelLayout());
        IzPanelConstraints ipc = IzPanelLayout.getDefaultConstraint(1);
        ipc.setXStretch(1.0);
        this.textField = new JTextField(this.idata.getInstallPath(), 10);
        this.textField.addActionListener(this);
        this.parent.setInitialFocus(this.textField);
        this.add((Component)this.textField, ipc);
        this.add(IzPanelLayout.createHorizontalFiller(3));
        this.browseButton = ButtonFactory.createButton(this.parent.getInstallerFrame().langpack.getString("TargetPanel.browse"), this.parent.getInstallerFrame().icons.getImageIcon("open"), this.idata.buttonsHColor);
        this.browseButton.addActionListener(this);
        this.add(this.browseButton);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension ss = super.getPreferredSize();
        Dimension retval = this.parent.getSize();
        retval.height = ss.height;
        return retval;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.browseButton) {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.textField.getText()));
            fc.setMultiSelectionEnabled(false);
            fc.setFileSelectionMode(1);
            fc.addChoosableFileFilter(fc.getAcceptAllFileFilter());
            if (fc.showSaveDialog(this) == 0) {
                String path = fc.getSelectedFile().getAbsolutePath();
                this.textField.setText(path);
            }
        } else if (this.parent instanceof ActionListener) {
            ((ActionListener)((Object)this.parent)).actionPerformed(e);
        }
    }

    public String getPath() {
        return this.textField.getText();
    }

    public void setPath(String path) {
        this.textField.setText(path);
    }

    public JTextField getPathInputField() {
        return this.textField;
    }

    public JButton getBrowseButton() {
        return this.browseButton;
    }
}

