/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LicencePanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3691043187997552948L;
    private String licence;
    private JRadioButton yesRadio;
    private JRadioButton noRadio;

    public LicencePanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new IzPanelLayout());
        this.loadLicence();
        this.add((Component)LabelFactory.create(parent.langpack.getString("LicencePanel.info"), parent.icons.getImageIcon("history"), 10), "nextLine");
        JTextArea textArea = new JTextArea(this.licence);
        textArea.setCaretPosition(0);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setAlignmentX(0.0f);
        this.add((Component)scroller, "nextLine");
        ButtonGroup group = new ButtonGroup();
        String label = parent.langpack.getString("LicencePanel.agree");
        this.yesRadio = new JRadioButton(label, false);
        group.add(this.yesRadio);
        this.add((Component)this.yesRadio, "nextLine");
        this.yesRadio.addActionListener(this);
        char mnemonics = '\u0000';
        if (label != null && label.length() > 0) {
            mnemonics = label.toLowerCase().charAt(0);
            this.yesRadio.setMnemonic(mnemonics);
        }
        label = parent.langpack.getString("LicencePanel.notagree");
        this.noRadio = new JRadioButton(label, true);
        group.add(this.noRadio);
        this.add((Component)this.noRadio, "nextLine");
        this.noRadio.addActionListener(this);
        if (label != null && label.length() > 0) {
            char noMnemonics = label.toLowerCase().charAt(0);
            if (mnemonics == noMnemonics) {
                if (label.indexOf(" ") != -1 && label.indexOf(" ") < label.length() - 2) {
                    noMnemonics = label.toLowerCase().charAt(label.indexOf(" ") + 1);
                } else if (label.length() > 0) {
                    noMnemonics = label.toLowerCase().charAt(1);
                }
            }
            if (noMnemonics > '\u0000') {
                this.noRadio.setMnemonic(noMnemonics);
            }
        }
        this.setInitialFocus(this.noRadio);
        this.getLayoutHelper().completeLayout();
    }

    private void loadLicence() {
        try {
            String resNamePrifix = "LicencePanel.licence";
            this.licence = ResourceManager.getInstance().getTextResource(resNamePrifix);
        }
        catch (Exception err) {
            this.licence = "Error : could not load the licence text !";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.yesRadio.isSelected()) {
            this.parent.unlockNextButton();
        } else {
            this.parent.lockNextButton();
        }
    }

    @Override
    public boolean isValidated() {
        if (this.noRadio.isSelected()) {
            this.parent.exit();
            return false;
        }
        return this.yesRadio.isSelected();
    }

    @Override
    public void panelActivate() {
        if (!this.yesRadio.isSelected()) {
            this.parent.lockNextButton();
        }
    }
}

