/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.PanelConsoleHelper;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InstallTypePanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    private static final String SPEC_FILE_NAME = "productsSpec.txt";
    public static String ADX_NODE_TYPE = "component.node.type";
    public static String ADX_NODE_FAMILY = "component.node.family";

    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        printWriter.println("MODIFY.IZPACK.INSTALL=");
        printWriter.println("installpath=");
        return true;
    }

    @Override
    public boolean runConsoleFromPropertiesFile(AutomatedInstallData installData, Properties p) {
        String strType = p.getProperty("MODIFY.IZPACK.INSTALL").trim();
        if (strType == null || "".equals(strType)) {
            installData.setVariable("MODIFY.IZPACK.INSTALL", "false");
        } else if (Boolean.parseBoolean(strType)) {
            installData.setVariable("MODIFY.IZPACK.INSTALL", "true");
            String strInstallpath = p.getProperty("installpath").trim();
            installData.setInstallPath(strInstallpath);
        } else {
            installData.setVariable("MODIFY.IZPACK.INSTALL", "false");
        }
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData installData) {
        String str = installData.langpack.getString("InstallationTypePanel.info");
        System.out.println("");
        System.out.println(str);
        int i = 0;
        while (i < 1 || i > 3) {
            i = this.askQuestion(installData, installData.langpack.getString("InstallationTypePanel.asktype"), 1);
        }
        if (i != 1) {
            if (i == 2) {
                installData.setVariable("MODIFY.IZPACK.INSTALL", "true");
                return this.chooseComponent(installData);
            }
            return false;
        }
        installData.setVariable("MODIFY.IZPACK.INSTALL", "false");
        return true;
    }

    public boolean chooseComponent(AutomatedInstallData installData) {
        String strQuestion = installData.langpack.getString("InstallationTypePanel.askUpdatePath");
        List installedProducts = this.loadListInstalledProducts(installData);
        System.out.println();
        for (int i = 0; i < installedProducts.size(); ++i) {
            String[] product = (String[])installedProducts.get(i);
            System.out.println(i + " - " + product[0]);
        }
        System.out.println();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                System.out.println(strQuestion);
                String strIn = br.readLine().trim();
                int j = -1;
                try {
                    j = Integer.valueOf(strIn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (j > -1 && j < installedProducts.size()) {
                    String[] product = (String[])installedProducts.get(j);
                    installData.setInstallPath(product[2]);
                    return true;
                }
                System.out.println(installData.langpack.getString("UserInputPanel.search.wrongselection.caption"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private List loadListInstalledProducts(AutomatedInstallData installData) {
        if (installData.info.needAdxAdmin()) {
            return this.loadListFromAdxadmin(installData);
        }
        if (OsVersion.IS_WINDOWS) {
            return this.loadListFromRegistry(installData);
        }
        this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
        return null;
    }

    private List loadListFromRegistry(AutomatedInstallData installData) {
        try {
            String uninstallName = installData.getVariable("UNINSTALL_NAME");
            String uninstallKeySuffix = installData.getVariable("UninstallKeySuffix");
            String uninstallKeyPrefix = new String(uninstallName);
            ArrayList<String> uninstallKeyPrefixList = new ArrayList<String>();
            if (uninstallKeySuffix != null && !"".equals(uninstallKeySuffix)) {
                uninstallKeyPrefix = uninstallKeyPrefix.substring(0, uninstallKeyPrefix.length() - uninstallKeySuffix.length());
            }
            uninstallKeyPrefixList.add(uninstallKeyPrefix);
            try {
                InputStream input = ResourceManager.getInstance().getInputStream(SPEC_FILE_NAME);
                if (input != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    StringBuilder out = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        uninstallKeyPrefixList.add(line.trim());
                    }
                    reader.close();
                }
            }
            catch (Exception ex) {
                Debug.log(ex);
            }
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh == null) {
                this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            }
            rh.verify(installData);
            String UninstallKeyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\";
            int oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            List<String> lstSubKeys = Arrays.asList(rh.getSubkeys(UninstallKeyName));
            ArrayList<String[]> tblComps = new ArrayList<String[]>();
            for (String uninstallKey : lstSubKeys) {
                for (String keyToSearchFor : uninstallKeyPrefixList) {
                    File installInformation;
                    if (!uninstallKey.startsWith(keyToSearchFor)) continue;
                    String productPath = rh.getValue(UninstallKeyName + "\\" + uninstallKey, "UninstallString").getStringData();
                    productPath = productPath.substring(productPath.lastIndexOf("\"", productPath.length() - 2) + 1, productPath.length() - 29);
                    String productVersion = rh.getValue(UninstallKeyName + "\\" + uninstallKey, "DisplayVersion").getStringData();
                    String name = uninstallKey;
                    if (name.indexOf(" - ") > 0) {
                        name = name.substring(name.indexOf(" - ") + 3);
                    }
                    if (!(installInformation = new File(productPath + File.separator + ".installationinformation")).exists()) continue;
                    String[] elem = new String[]{name + " " + productVersion + " (" + productPath + ")", name, productPath, productVersion};
                    tblComps.add(elem);
                }
            }
            rh.setRoot(oldVal);
            return tblComps;
        }
        catch (Exception ex) {
            Debug.trace(ex);
            this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            return null;
        }
    }

    private List<String[]> loadListFromAdxadmin(AutomatedInstallData installData) {
        try {
            File dirAdxDir;
            String strAdxAdminPath = "";
            if (OsVersion.IS_UNIX) {
                File adxadmFile = new File("/sage/adxadm");
                if (!adxadmFile.exists()) {
                    adxadmFile = new File("/adonix/adxadm");
                }
                if (!adxadmFile.exists()) {
                    this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
                }
                FileReader readerAdxAdmFile = new FileReader(adxadmFile);
                BufferedReader buffread = new BufferedReader(readerAdxAdmFile);
                strAdxAdminPath = buffread.readLine();
            } else {
                RegistryHandler rh = RegistryDefaultHandler.getInstance();
                if (rh == null) {
                    this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
                }
                rh.verify(installData);
                if (!rh.adxadminProductRegistered()) {
                    this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
                }
                String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
                int oldVal = rh.getRoot();
                rh.setRoot(-2147483646);
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
                }
                if (!rh.valueExist(keyName, "ADXDIR")) {
                    this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
                }
                strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
                rh.setRoot(oldVal);
            }
            if (strAdxAdminPath == null || "".equals(strAdxAdminPath)) {
                this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            }
            if (!(dirAdxDir = new File(strAdxAdminPath)).exists() || !dirAdxDir.isDirectory()) {
                this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            }
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(dirAdxDir.getAbsolutePath());
            strBuilder.append(File.separator);
            strBuilder.append("inst");
            strBuilder.append(File.separator);
            strBuilder.append("adxinstalls.xml");
            File fileAdxinstalls = new File(strBuilder.toString());
            if (!fileAdxinstalls.exists()) {
                this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            }
            String strComponentType = installData.getVariable(ADX_NODE_TYPE);
            String strComponentFamily = installData.getVariable(ADX_NODE_FAMILY);
            if (strComponentFamily == null) {
                this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(fileAdxinstalls);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "//module[@family='" + strComponentFamily + "'";
            if (strComponentType != null) {
                expression = expression + " and @type='" + strComponentType + "'";
            }
            expression = expression + "]";
            NodeList nodeLst = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
            ArrayList<String[]> tblComps = new ArrayList<String[]>();
            for (int i = 0; i < nodeLst.getLength(); ++i) {
                String[] elem;
                Element moduleNode = (Element)nodeLst.item(i);
                String path = xPath.evaluate("./component." + strComponentFamily.toLowerCase() + ".path", moduleNode);
                String strversion = xPath.evaluate("./component." + strComponentFamily.toLowerCase() + ".version", moduleNode);
                String name = moduleNode.getAttribute("name");
                File installInformation = new File(path + File.separator + ".installationinformation");
                if (installInformation.exists()) {
                    elem = new String[]{name + " " + strversion + " (" + path + ")", name, path, strversion};
                    tblComps.add(elem);
                    continue;
                }
                if (!path.endsWith(File.separator + "tool") || !(installInformation = new File((path = path.substring(0, path.length() - 5)) + File.separator + ".installationinformation")).exists()) continue;
                elem = new String[]{name + " " + strversion + " (" + path + ")", name, path, strversion};
                tblComps.add(elem);
            }
            return tblComps;
        }
        catch (Exception ex) {
            Debug.trace(ex);
            this.emitErrorAndBlockNext(installData.langpack.getString("installer.error"), installData.langpack.getString("InstallationTypePanel.errNoCompFound"));
            return null;
        }
    }
}

