/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Info;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.awt.Component;
import java.awt.LayoutManager2;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class HelloPanel
extends IzPanel {
    private static final long serialVersionUID = 3257848774955905587L;

    public HelloPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, new IzPanelLayout());
    }

    public HelloPanel(InstallerFrame parent, InstallData idata, LayoutManager2 layout) {
        super(parent, idata, layout);
        String str = parent.langpack.getString("HelloPanel.welcome1") + idata.info.getAppName() + " " + idata.info.getAppVersion() + parent.langpack.getString("HelloPanel.welcome2");
        JLabel welcomeLabel = LabelFactory.create(str, parent.icons.getImageIcon("host"), 10);
        this.add((Component)welcomeLabel, "nextLine");
        this.add(IzPanelLayout.createParagraphGap());
        ArrayList<Info.Author> authors = idata.info.getAuthors();
        int size = authors.size();
        if (size > 0) {
            str = parent.langpack.getString("HelloPanel.authors");
            JLabel appAuthorsLabel = LabelFactory.create(str, parent.icons.getImageIcon("information"), 10);
            this.add((Component)appAuthorsLabel, "nextLine");
            for (int i = 0; i < size; ++i) {
                Info.Author a = authors.get(i);
                String email = a.getEmail() != null && a.getEmail().length() > 0 ? " <" + a.getEmail() + ">" : "";
                JLabel label = LabelFactory.create(" - " + a.getName() + email, parent.icons.getImageIcon("empty"), 10);
                this.add((Component)label, "nextLine");
            }
            this.add(IzPanelLayout.createParagraphGap());
        }
        if (idata.info.getAppURL() != null) {
            str = parent.langpack.getString("HelloPanel.url") + idata.info.getAppURL();
            JLabel appURLLabel = LabelFactory.create(str, parent.icons.getImageIcon("bookmark"), 10);
            this.add((Component)appURLLabel, "nextLine");
        }
        this.getLayoutHelper().completeLayout();
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public void panelActivate() {
        block32: {
            if (this.idata.info.needAdxAdmin()) {
                try {
                    File adxadmFile;
                    RegistryHandler rh = RegistryDefaultHandler.getInstance();
                    if (rh != null) {
                        rh.verify(this.idata);
                        if (!rh.adxadminProductRegistered()) {
                            JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminNotRegistered"), this.parent.langpack.getString("installer.error"), 0);
                            this.parent.lockNextButton();
                        }
                    } else if (OsVersion.IS_UNIX && !(adxadmFile = new File("/sage/adxadm")).exists() && !(adxadmFile = new File("/adonix/adxadm")).exists()) {
                        JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminNotRegistered"), this.parent.langpack.getString("installer.error"), 0);
                        this.parent.lockNextButton();
                    }
                }
                catch (Exception e) {
                    Debug.log(e);
                    JOptionPane.showMessageDialog(null, e.getMessage(), this.parent.langpack.getString("installer.error"), 0);
                    this.parent.lockNextButton();
                }
            } else if (this.idata.info.isAdxAdmin()) {
                if (OsVersion.IS_UNIX) {
                    File adxadmFileUnix = new File("/sage/adxadm");
                    if (adxadmFileUnix.exists()) {
                        try {
                            String adxadmPath = HelloPanel.readFile("/sage/adxadm", Charset.defaultCharset());
                            adxadmPath = adxadmPath.replace("\r\n", "").replace("\n", "").trim();
                            String installInformation = adxadmPath + "/" + ".installationinformation";
                            File installInformationFile = new File(installInformation);
                            if (!installInformationFile.exists()) {
                                JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminNoAdxDirSage"), this.parent.langpack.getString("installer.error"), 0);
                                this.parent.lockNextButton();
                                break block32;
                            }
                            if (this.askQuestion(this.parent.langpack.getString("updateMode"), this.parent.langpack.getString("compFoundAskUpdate"), 37, 47) == 47) {
                                this.idata.setInstallPath(adxadmPath);
                                Debug.trace("modification installation");
                                this.idata.setVariable("MODIFY.IZPACK.INSTALL", "true");
                                break block32;
                            }
                            this.parent.lockNextButton();
                        }
                        catch (IOException e) {
                            JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminNoAdxDirSage"), this.parent.langpack.getString("installer.error"), 0);
                            this.parent.lockNextButton();
                        }
                    } else {
                        adxadmFileUnix = new File("/adonix/adxadm");
                        if (adxadmFileUnix.exists()) {
                            try {
                                String adxadmPath = HelloPanel.readFile("/adonix/adxadm", Charset.defaultCharset());
                                adxadmPath = adxadmPath.replace("\r\n", "").replace("\n", "").trim();
                                JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminV6found") + "\r\n" + adxadmPath, this.parent.langpack.getString("installer.error"), 0);
                                this.parent.lockNextButton();
                            }
                            catch (IOException e) {
                                JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminV6found"), this.parent.langpack.getString("installer.error"), 0);
                                this.parent.lockNextButton();
                            }
                        }
                    }
                } else {
                    try {
                        String strAdxAdminPath = "";
                        RegistryHandler rh = RegistryDefaultHandler.getInstance();
                        if (rh != null) {
                            rh.verify(this.idata);
                            if (rh.adxadminProductRegistered()) {
                                String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
                                int oldVal = rh.getRoot();
                                rh.setRoot(-2147483646);
                                if (!rh.valueExist(keyName, "ADXDIR")) {
                                    keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
                                    if (!rh.valueExist(keyName, "ADXDIR")) {
                                        rh.setRoot(oldVal);
                                        JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminNoAdxDirReg"), this.parent.langpack.getString("installer.error"), 0);
                                        this.parent.lockNextButton();
                                    } else {
                                        strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
                                    }
                                } else {
                                    strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
                                }
                                rh.setRoot(oldVal);
                                File fInstallINf = new File(strAdxAdminPath + File.separator + ".installationinformation");
                                if (!fInstallINf.exists()) {
                                    JOptionPane.showMessageDialog(null, this.parent.langpack.getString("adxadminV6found") + "\r\n" + strAdxAdminPath, this.parent.langpack.getString("installer.error"), 0);
                                    this.parent.lockNextButton();
                                } else if (this.askQuestion(this.parent.langpack.getString("updateMode"), this.parent.langpack.getString("compFoundAskUpdate"), 37, 47) == 47) {
                                    this.idata.setInstallPath(strAdxAdminPath);
                                    Debug.trace("modification installation");
                                    this.idata.setVariable("MODIFY.IZPACK.INSTALL", "true");
                                } else {
                                    this.parent.lockNextButton();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Debug.log(e);
                        JOptionPane.showMessageDialog(null, e.getMessage(), this.parent.langpack.getString("installer.error"), 0);
                        this.parent.lockNextButton();
                    }
                }
            }
        }
    }

    static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return encoding.decode(ByteBuffer.wrap(encoded)).toString();
    }
}

