/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.AutomatedInstallScriptFilter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class FinishPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257282535107998009L;
    protected JButton autoButton;
    protected VariableSubstitutor vs;

    public FinishPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata, new GridBagLayout());
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    protected void addSetSuccessInfo(GridBagConstraints constraints) {
        JLabel jLabel = LabelFactory.create(this.idata.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("preferences"), 10);
        constraints.gridy = -1;
        constraints.gridx = 0;
        IzPanel.Filler dummy = new IzPanel.Filler();
        this.add((Component)dummy, constraints);
        this.add((Component)jLabel, constraints);
        if (this.idata.uninstallOutJar != null) {
            String path = this.translatePath(this.idata.info.getUninstallerPath());
            constraints.gridx = 0;
            this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("preferences"), 10), constraints);
            constraints.gridx = 0;
            this.add((Component)LabelFactory.create("  " + path, this.parent.icons.getImageIcon("empty"), 10), constraints);
        }
        this.autoButton = ButtonFactory.createButton(this.parent.langpack.getString("FinishPanel.auto"), this.parent.icons.getImageIcon("edit"), this.idata.buttonsHColor);
        this.autoButton.setToolTipText(this.parent.langpack.getString("FinishPanel.auto.tip"));
        this.autoButton.addActionListener(this);
        constraints.weighty = 1.0;
        constraints.insets = new Insets(40, 0, 0, 0);
        constraints.gridx = 0;
        this.add((Component)this.autoButton, constraints);
    }

    @Override
    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 4;
        if (this.idata.installSuccess) {
            this.addSetSuccessInfo(constraints);
        } else {
            this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("stop"), 10), "nextLine");
            ++constraints.gridy;
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File(this.idata.getInstallPath()));
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new AutomatedInstallScriptFilter());
        try {
            if (fc.showSaveDialog(this) == 0) {
                File file = fc.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
                FileOutputStream out = new FileOutputStream(file);
                BufferedOutputStream outBuff = new BufferedOutputStream(out, 5120);
                this.parent.writeXMLTree(this.idata.xmlData, outBuff);
                outBuff.flush();
                outBuff.close();
                this.autoButton.setEnabled(false);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
            JOptionPane.showMessageDialog(this, err.toString(), this.parent.langpack.getString("installer.error"), 0);
        }
    }

    protected String translatePath(String destination) {
        destination = this.vs.substitute(destination, null);
        return destination.replace('/', File.separatorChar);
    }
}

