/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.Pack;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class UpdateListener
extends SimpleInstallerListener
implements CleanupClient {
    public static final String BEFORE_UPDATE_SCRIPT = "BeforeUpdateScript";
    public static final String BEFORE_INSTALL_SCRIPT = "BeforeInstallScript";
    public static final String AFTER_UPDATE_SCRIPT = "AfterUpdateScript";
    public static final String AFTER_INSTALL_SCRIPT = "AfterInstallScript";
    public static final String PLATFORM = OsVersion.IS_UNIX ? "unix" : "windows";

    @Override
    public void cleanUp() {
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        super.afterPacks(idata, handler);
        if (Boolean.valueOf(idata.getVariable("MODIFY.IZPACK.INSTALL")).booleanValue()) {
            this.fetchAndExcuteResource("AfterUpdateScript_" + PLATFORM, idata);
        } else {
            this.fetchAndExcuteResource("AfterInstallScript_" + PLATFORM, idata);
        }
    }

    @Override
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        super.afterPack(pack, i, handler);
        if (Boolean.valueOf(this.getInstalldata().getVariable("MODIFY.IZPACK.INSTALL")).booleanValue()) {
            this.fetchAndExcuteResource(pack.id + "_" + AFTER_UPDATE_SCRIPT + "_" + PLATFORM, this.getInstalldata());
        } else {
            this.fetchAndExcuteResource(pack.id + "_" + AFTER_INSTALL_SCRIPT + "_" + PLATFORM, this.getInstalldata());
        }
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        if (Boolean.valueOf(idata.getVariable("MODIFY.IZPACK.INSTALL")).booleanValue()) {
            this.fetchAndExcuteResource("BeforeUpdateScript_" + PLATFORM, idata);
        } else {
            this.fetchAndExcuteResource("BeforeInstallScript_" + PLATFORM, idata);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        super.beforePack(pack, i, handler);
        if (Boolean.valueOf(this.getInstalldata().getVariable("MODIFY.IZPACK.INSTALL")).booleanValue()) {
            this.fetchAndExcuteResource(pack.id + "_" + BEFORE_UPDATE_SCRIPT + "_" + PLATFORM, this.getInstalldata());
        } else {
            this.fetchAndExcuteResource(pack.id + "_" + BEFORE_INSTALL_SCRIPT + "_" + PLATFORM, this.getInstalldata());
        }
    }

    @Override
    public void afterInstallerInitialization(AutomatedInstallData data) {
        super.afterInstallerInitialization(data);
    }

    public void fetchAndExcuteResource(String resource, AutomatedInstallData idata) throws Exception {
        SpecHelper spechelper = new SpecHelper();
        String ext = OsVersion.IS_UNIX ? ".sh" : ".cmd";
        InputStream stream = spechelper.getResource(resource);
        if (stream != null) {
            int len;
            InputStream substitutedStream = spechelper.substituteVariables(stream, new VariableSubstitutor(idata.getVariables()));
            File tempFile = File.createTempFile(resource, ext);
            FileOutputStream fos = null;
            tempFile.deleteOnExit();
            fos = new FileOutputStream(tempFile);
            byte[] buffer = new byte[1024];
            while ((len = substitutedStream.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            substitutedStream.close();
            fos.flush();
            fos.close();
            ProcessBuilder procBuilder = null;
            procBuilder = OsVersion.IS_UNIX ? new ProcessBuilder(System.getenv("SHELL"), tempFile.getAbsolutePath()) : new ProcessBuilder("cmd.exe", "/C", tempFile.getAbsolutePath());
            Debug.log("launching " + tempFile.getAbsolutePath());
            Process p = procBuilder.start();
            BufferedInputStream errorOutput = new BufferedInputStream(p.getErrorStream(), 10000);
            BufferedInputStream consoleOutput = new BufferedInputStream(p.getInputStream(), 10000);
            Debug.log("errorOutput:");
            BufferedReader br = new BufferedReader(new InputStreamReader(errorOutput));
            String read = br.readLine();
            while (read != null) {
                Debug.log(read);
                read = br.readLine();
            }
            Debug.log("consoleOutput:");
            BufferedReader br2 = new BufferedReader(new InputStreamReader(consoleOutput));
            String read2 = br2.readLine();
            while (read2 != null) {
                Debug.log(read2);
                read2 = br2.readLine();
            }
            int exitCode = p.waitFor();
            Debug.log("exitCode: " + exitCode);
            if (exitCode != 0) {
                Debug.log("Command failed: " + procBuilder.command());
                throw new InstallerException(resource + " return code is " + exitCode + " !");
            }
        }
    }
}

