/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.event.SimpleUninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.xml.XMLHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AdxCompUninstallerListener
extends SimpleUninstallerListener {
    private static final String SPEC_FILE_NAME = "AdxCompSpec.xml";
    protected static LocaleDatabase langpack = null;

    public AdxCompUninstallerListener() {
        if (langpack == null) {
            try {
                langpack = new LocaleDatabase(AdxCompUninstallerListener.class.getResourceAsStream("/langpack.xml"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/AdxCompSpec.xml");
        if (in == null) {
            return;
        }
        String strAdxAdminPath = "";
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh != null) {
            if (!rh.adxadminProductRegistered()) return;
            String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
            int oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            if (!rh.valueExist(keyName, "ADXDIR")) {
                keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
            }
            if (!rh.valueExist(keyName, "ADXDIR")) {
                return;
            }
            strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
            rh.setRoot(oldVal);
        } else {
            Debug.log("CheckedHelloPanel - Could not get RegistryHandler !");
            if (OsVersion.IS_UNIX) {
                File adxadmFile = new File("/sage/adxadm");
                if (!adxadmFile.exists() && !(adxadmFile = new File("/adonix/adxadm")).exists()) {
                    return;
                }
                FileReader readerAdxAdmFile = new FileReader(adxadmFile);
                BufferedReader buffread = new BufferedReader(readerAdxAdmFile);
                strAdxAdminPath = buffread.readLine();
            }
        }
        if (strAdxAdminPath == null || "".equals(strAdxAdminPath)) {
            return;
        }
        File dirAdxDir = new File(strAdxAdminPath);
        if (!dirAdxDir.exists() || !dirAdxDir.isDirectory()) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(dirAdxDir.getAbsolutePath());
        strBuilder.append(File.separator);
        strBuilder.append("inst");
        strBuilder.append(File.separator);
        strBuilder.append("adxinstalls.xml");
        File fileAdxinstalls = new File(strBuilder.toString());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document xdoc = null;
        Element xmodule = null;
        Document xdoc2 = null;
        Element xmodule2 = null;
        if (!fileAdxinstalls.exists()) {
            return;
        }
        xdoc = dBuilder.parse(fileAdxinstalls);
        XMLHelper.cleanEmptyTextNodes(xdoc);
        xdoc2 = dBuilder.parse(in);
        xmodule2 = (Element)xdoc2.getDocumentElement().getElementsByTagName("module").item(0);
        NodeList listAdxInstallsNodes = xdoc.getDocumentElement().getElementsByTagName("module");
        for (int i = 0; i < listAdxInstallsNodes.getLength(); ++i) {
            Element aNode = (Element)listAdxInstallsNodes.item(i);
            if (!aNode.getAttribute("name").equals(xmodule2.getAttribute("name")) || !aNode.getAttribute("type").equals(xmodule2.getAttribute("type")) || !aNode.getAttribute("family").equals(xmodule2.getAttribute("family"))) continue;
            xmodule = aNode;
            break;
        }
        if (xmodule == null) {
            return;
        }
        NodeList lstChilds = xmodule.getElementsByTagName("*");
        for (int i = 0; i < lstChilds.getLength(); ++i) {
            String modstatus;
            Element elem = (Element)lstChilds.item(i);
            if (!elem.getTagName().endsWith(".installstatus") || "idle".equalsIgnoreCase(modstatus = elem.getTextContent())) continue;
            handler.emitError(langpack.getString("installer.error"), langpack.getString("notidle"));
            System.exit(1);
        }
        xmodule.getParentNode().removeChild(xmodule);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(xdoc);
        StreamResult result = new StreamResult(fileAdxinstalls);
        transformer.transform(source, result);
    }
}

