/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.xml.XMLHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AdxCompInstallerListener
extends SimpleInstallerListener
implements CleanupClient {
    private static final String SPEC_FILE_NAME = "AdxCompSpec.xml";

    public AdxCompInstallerListener() {
        super(true);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        SimpleInstallerListener.langpack = idata.langpack;
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.verify(idata);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        String strAdxAdminPath = "";
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh != null) {
            rh.verify(idata);
            if (!rh.adxadminProductRegistered()) throw new Exception(langpack.getString("adxadminNotRegistered"));
            String keyName = "SOFTWARE\\Adonix\\X3RUNTIME\\ADXADMIN";
            int oldVal = rh.getRoot();
            rh.setRoot(-2147483646);
            if (!rh.valueExist(keyName, "ADXDIR")) {
                keyName = "SOFTWARE\\Wow6432Node\\Adonix\\X3RUNTIME\\ADXADMIN";
            }
            if (!rh.valueExist(keyName, "ADXDIR")) {
                throw new Exception(langpack.getString("adxadminNoAdxDirReg"));
            }
            strAdxAdminPath = rh.getValue(keyName, "ADXDIR").getStringData();
            rh.setRoot(oldVal);
        } else {
            Debug.log("CheckedHelloPanel - Could not get RegistryHandler !");
            if (OsVersion.IS_UNIX) {
                File adxadmFile = new File("/sage/adxadm");
                if (!adxadmFile.exists() && !(adxadmFile = new File("/adonix/adxadm")).exists()) {
                    throw new Exception(langpack.getString("adxadminNotRegistered"));
                }
                FileReader readerAdxAdmFile = new FileReader(adxadmFile);
                BufferedReader buffread = new BufferedReader(readerAdxAdmFile);
                strAdxAdminPath = buffread.readLine();
            }
        }
        if (strAdxAdminPath == null || "".equals(strAdxAdminPath)) {
            throw new Exception(langpack.getString("adxadminParseError"));
        }
        File dirAdxDir = new File(strAdxAdminPath);
        if (!dirAdxDir.exists() || !dirAdxDir.isDirectory()) {
            throw new Exception(langpack.getString("adxadminParseError"));
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(dirAdxDir.getAbsolutePath());
        strBuilder.append(File.separator);
        strBuilder.append("inst");
        strBuilder.append(File.separator);
        strBuilder.append("adxinstalls.xml");
        File fileAdxinstalls = new File(strBuilder.toString());
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document xdoc = null;
        Object xmodule = null;
        if (!fileAdxinstalls.exists()) {
            fileAdxinstalls.createNewFile();
            if (OsVersion.IS_UNIX) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                perms.add(PosixFilePermission.GROUP_READ);
                perms.add(PosixFilePermission.GROUP_WRITE);
                perms.add(PosixFilePermission.OTHERS_READ);
                perms.add(PosixFilePermission.OTHERS_WRITE);
                Files.setPosixFilePermissions(fileAdxinstalls.toPath(), perms);
            }
            xdoc = dBuilder.newDocument();
            xdoc.setXmlVersion("1.0");
            xdoc.setXmlStandalone(true);
            Element racine = xdoc.createElement("install");
            xdoc.appendChild(racine);
        } else {
            xdoc = dBuilder.parse(fileAdxinstalls);
        }
        XMLHelper.cleanEmptyTextNodes(xdoc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        IXMLElement elemSpec = this.getSpecHelper().getSpec();
        IXMLElement moduleSpec = elemSpec.getFirstChildNamed("module");
        VariableSubstitutor substitutor = new VariableSubstitutor(idata.getVariables());
        String name = substitutor.substitute(moduleSpec.getAttribute("name"), "plain");
        String family = substitutor.substitute(moduleSpec.getAttribute("family"), "plain");
        String type = substitutor.substitute(moduleSpec.getAttribute("type"), "plain");
        String version = substitutor.substitute(moduleSpec.getFirstChildNamed("component." + family.toLowerCase() + ".version").getContent(), "plain");
        Element module = null;
        boolean modifyinstallation = Boolean.valueOf(idata.getVariable("MODIFY.IZPACK.INSTALL"));
        if (modifyinstallation) {
            Node nodeVersion;
            Element xmlinstall = xdoc.getDocumentElement();
            XPath xPath = XPathFactory.newInstance().newXPath();
            module = (Element)xPath.compile("/install/module[@name='" + name + "' and @type='" + type + "' and @family='" + family + "']").evaluate(xdoc, XPathConstants.NODE);
            if (module == null) {
                throw new Exception(String.format(langpack.getString("sectionNotFound"), name));
            }
            Node status = module.getElementsByTagName("component." + family.toLowerCase() + ".installstatus").item(0);
            if (status == null) {
                status = module.appendChild(xdoc.createElement("component." + family.toLowerCase() + ".installstatus"));
                status.setTextContent("update");
            }
            if (status.getTextContent().equalsIgnoreCase("active")) {
                status.setTextContent("update");
            }
            if ((nodeVersion = module.getElementsByTagName("component." + family.toLowerCase() + ".version").item(0)) == null) {
                nodeVersion = module.appendChild(xdoc.createElement("component." + family.toLowerCase() + ".version"));
            }
            nodeVersion.setTextContent(version);
            if (family.equalsIgnoreCase("RUNTIME")) {
                Node nodedblink;
                Node nodedbhome = module.getElementsByTagName("runtime.odbc.dbhome").item(0);
                if (nodedbhome == null) {
                    nodedbhome = module.appendChild(xdoc.createElement("runtime.odbc.dbhome"));
                }
                if ((nodedblink = module.getElementsByTagName("runtime.odbc.forcedblink").item(0)) == null) {
                    nodedblink = module.appendChild(xdoc.createElement("runtime.odbc.forcedblink"));
                }
            }
        } else {
            module = xdoc.createElement("module");
            module.setAttribute("name", name);
            module.setAttribute("family", family);
            module.setAttribute("type", type);
            for (IXMLElement param : moduleSpec.getChildren()) {
                Element xmlParam = xdoc.createElement(param.getName());
                xmlParam.setTextContent(substitutor.substitute(param.getContent(), "plain"));
                module.appendChild(xmlParam);
            }
            xdoc.getDocumentElement().appendChild(module);
        }
        DOMSource source = new DOMSource(xdoc);
        StreamResult result = new StreamResult(fileAdxinstalls);
        transformer.transform(source, result);
        Document xdoc2 = dBuilder.newDocument();
        xdoc2.setXmlVersion("1.0");
        xdoc2.setXmlStandalone(true);
        Element racine2 = xdoc2.createElement("install");
        xdoc2.appendChild(racine2);
        xdoc2.getDocumentElement().appendChild(xdoc2.importNode(module, true));
        idata.uninstallOutJar.putNextEntry(new ZipEntry(SPEC_FILE_NAME));
        DOMSource source2 = new DOMSource(xdoc2);
        StreamResult result2 = new StreamResult(idata.uninstallOutJar);
        transformer.transform(source2, result2);
        idata.uninstallOutJar.closeEntry();
    }
}

